/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.core.common.ui.IListFilterDatePanel;
import org.openconcerto.erp.core.common.ui.IListTotalPanel;
import org.openconcerto.erp.core.finance.accounting.element.MouvementSQLElement;
import org.openconcerto.erp.core.finance.payment.component.EncaisserMontantSQLComponent;
import org.openconcerto.erp.core.sales.invoice.element.EcheanceClientSQLElement;
import org.openconcerto.erp.core.sales.invoice.ui.ListPanelEcheancesClients;
import org.openconcerto.erp.rights.ComptaUserRight;
import org.openconcerto.erp.rights.NXRights;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.IListPanel;
import org.openconcerto.sql.view.IListener;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.ui.DefaultGridBagConstraints;

public class ListeDesEcheancesClientsPanel
extends JPanel {
    private ListPanelEcheancesClients panelEcheances;
    private EditFrame editEncaisse = null;
    private EditFrame editRelance = null;
    private JButton relancer;
    private JButton encaisser;

    public ListeDesEcheancesClientsPanel() {
        this(false);
    }

    public ListeDesEcheancesClientsPanel(boolean onlyOld) {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        this.panelEcheances = new ListPanelEcheancesClients(onlyOld);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        c.fill = 1;
        this.add((Component)this.panelEcheances, c);
        IListe liste = this.panelEcheances.getListe();
        IListFilterDatePanel datePanel = new IListFilterDatePanel(liste, liste.getRequest().getPrimaryTable().getField("DATE"), IListFilterDatePanel.getDefaultMap());
        c.weighty = 0.0;
        ++c.gridy;
        c.weightx = 1.0;
        this.add((Component)datePanel, c);
        IListTotalPanel totalPanel = new IListTotalPanel(liste, Arrays.asList(this.panelEcheances.getElement().getTable().getField("MONTANT")));
        c.weighty = 0.0;
        ++c.gridy;
        c.anchor = 13;
        c.weightx = 0.0;
        c.fill = 0;
        this.add((Component)totalPanel, c);
        c.anchor = 17;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weighty = 0.0;
        c.fill = 0;
        c.weightx = 0.0;
        final JCheckBox checkRegCompta = new JCheckBox("Voir les r\u00e9gularisations de comptabilit\u00e9");
        if (UserRightsManager.getCurrentUserRights().haveRight(ComptaUserRight.MENU)) {
            this.add((Component)checkRegCompta, c);
        }
        checkRegCompta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListeDesEcheancesClientsPanel.this.panelEcheances.setShowRegCompta(checkRegCompta.isSelected());
            }
        });
        c.weightx = 1.0;
        c.anchor = 13;
        this.relancer = new JButton("Relancer");
        this.relancer.setHorizontalAlignment(4);
        if (UserRightsManager.getCurrentUserRights().haveRight(NXRights.GESTION_ENCAISSEMENT.getCode())) {
            ++c.gridx;
            this.add((Component)this.relancer, c);
            this.relancer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((EcheanceClientSQLElement)ListeDesEcheancesClientsPanel.this.panelEcheances.getElement()).relanceClient(ListeDesEcheancesClientsPanel.this.getListPanelEcheancesClients().getListe().getSelectedRow().asRow());
                }
            });
        }
        this.encaisser = new JButton("Encaisser");
        this.encaisser.setHorizontalAlignment(4);
        ++c.gridx;
        c.weightx = 0.0;
        if (UserRightsManager.getCurrentUserRights().haveRight(NXRights.GESTION_ENCAISSEMENT.getCode())) {
            this.add((Component)this.encaisser, c);
        }
        this.encaisser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int answer;
                List<Integer> selectedIds = ListeDesEcheancesClientsPanel.this.panelEcheances.getListe().getSelection().getSelectedIDs();
                ArrayList<SQLRow> selectedRows = new ArrayList<SQLRow>(selectedIds.size());
                int idCpt = -1;
                int idClient = -1;
                int idCptTiers = -1;
                String tiers = "";
                boolean showMessage = false;
                StringBuilder numerosFacturesBuilders = new StringBuilder();
                for (Integer integer : selectedIds) {
                    SQLRow rowCptTiers;
                    SQLRow row = ListeDesEcheancesClientsPanel.this.panelEcheances.getListe().getSource().getPrimaryTable().getRow(integer);
                    selectedRows.add(row);
                    tiers = row.getString("TIERS");
                    String nom = row.getForeignRow("ID_MOUVEMENT").getForeignRow("ID_PIECE").getString("NOM");
                    numerosFacturesBuilders.append(nom);
                    numerosFacturesBuilders.append(' ');
                    SQLRow rowClient = row.getForeignRow("ID_CLIENT");
                    if (rowClient != null && !rowClient.isUndefined()) {
                        int idTmp = rowClient.getInt("ID_COMPTE_PCE");
                        int idCliTmp = rowClient.getID();
                        if (idCpt > -1 && idCpt != idTmp) {
                            JOptionPane.showMessageDialog(null, "Impossible d'effectuer un encaissement sur plusieurs factures ayant des clients avec des comptes diff\u00e9rents.");
                            return;
                        }
                        idCpt = idTmp;
                        if (idClient > -1 && idClient != idCliTmp) {
                            showMessage = true;
                        } else {
                            idClient = idCliTmp;
                        }
                    }
                    if ((rowCptTiers = row.getForeignRow("ID_COMPTE_PCE_TIERS")) == null || rowCptTiers.isUndefined()) continue;
                    idCptTiers = rowCptTiers.getID();
                }
                if (showMessage && (answer = JOptionPane.showConfirmDialog(null, "Attention vous avez s\u00e9lectionn\u00e9 des factures ayant des clients diff\u00e9rents. Voulez vous continuer?")) != 0) {
                    return;
                }
                SQLElement encaisseElt = Configuration.getInstance().getDirectory().getElement("ENCAISSER_MONTANT");
                if (ListeDesEcheancesClientsPanel.this.editEncaisse == null) {
                    ListeDesEcheancesClientsPanel.this.editEncaisse = new EditFrame(encaisseElt);
                    ListeDesEcheancesClientsPanel.this.editEncaisse.setIconImages(Gestion.getFrameIcon());
                }
                SQLRowValues rowVals = new SQLRowValues(encaisseElt.getTable());
                if (idClient > -1) {
                    rowVals.put("ID_CLIENT", idClient);
                }
                rowVals.put("NOM", numerosFacturesBuilders.toString().trim());
                rowVals.put("TIERS", tiers);
                if (idCptTiers > -1) {
                    rowVals.put("ID_COMPTE_PCE_TIERS", idCptTiers);
                }
                EncaisserMontantSQLComponent sqlComponent = (EncaisserMontantSQLComponent)ListeDesEcheancesClientsPanel.this.editEncaisse.getSQLComponent();
                sqlComponent.resetValue();
                sqlComponent.select(rowVals);
                sqlComponent.loadEcheancesFromRows(selectedRows);
                ListeDesEcheancesClientsPanel.this.editEncaisse.setTitle("Encaissement de factures clients");
                ListeDesEcheancesClientsPanel.this.editEncaisse.pack();
                ListeDesEcheancesClientsPanel.this.editEncaisse.setVisible(true);
            }
        });
        this.panelEcheances.getJTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mE) {
                if (mE.getButton() == 1) {
                    SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
                    SQLRowValues selectedRow = ListeDesEcheancesClientsPanel.this.panelEcheances.getListe().getSelectedRow();
                    SQLRow row = selectedRow.asRow();
                    if (row == null) {
                        JOptionPane.showMessageDialog(ListeDesEcheancesClientsPanel.this, "Selection", "Merci de s\u00e9lectionner une ligne", -1);
                        return;
                    }
                    if (ListeDesEcheancesClientsPanel.this.editEncaisse != null) {
                        SQLRowValues rowVals = new SQLRowValues(base.getTable("ENCAISSER_MONTANT"));
                        rowVals.put("ID_ECHEANCE_CLIENT", row.getID());
                        ListeDesEcheancesClientsPanel.this.editEncaisse.getSQLComponent().select(rowVals);
                        ListeDesEcheancesClientsPanel.this.editEncaisse.pack();
                    }
                }
            }
        });
        liste.addIListener(new IListener(){

            @Override
            public void selectionId(int id, int field) {
                if (id > 1) {
                    SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
                    SQLTable tableEch = base.getTable("ECHEANCE_CLIENT");
                    SQLRow rowEch = tableEch.getRow(id);
                    int idMvtSource = MouvementSQLElement.getSourceId(rowEch.getInt("ID_MOUVEMENT"));
                    SQLRow rowMvtSource = base.getTable("MOUVEMENT").getRow(idMvtSource);
                    ListeDesEcheancesClientsPanel.this.relancer.setEnabled(rowMvtSource.getString("SOURCE").equalsIgnoreCase("SAISIE_VENTE_FACTURE"));
                    ListeDesEcheancesClientsPanel.this.encaisser.setEnabled(true);
                } else {
                    ListeDesEcheancesClientsPanel.this.relancer.setEnabled(false);
                    ListeDesEcheancesClientsPanel.this.encaisser.setEnabled(false);
                }
            }
        });
        this.relancer.setEnabled(false);
        this.encaisser.setEnabled(false);
    }

    public IListPanel getListPanelEcheancesClients() {
        return this.panelEcheances;
    }
}

