/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.report;

import org.openconcerto.erp.generationDoc.AbstractSheetXMLWithDate;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;

public class VenteFactureXmlSheet
extends AbstractSheetXMLWithDate {
    public static final String TEMPLATE_ID = "VenteFacture";
    public static final String TEMPLATE_SITUATION_SUFFIX = "Situation";
    public static final String TEMPLATE_PROPERTY_NAME = "LocationFacture";

    @Override
    public String getReference() {
        return this.row.getString("NOM");
    }

    @Override
    public String getName() {
        String startName = this.row.getBoolean("COMPLEMENT") != false ? "FactureComplement_" : (this.row.getBoolean("ACOMPTE") != false ? "FactureAcompte_" : "Facture_");
        return String.valueOf(startName) + this.row.getString("NUMERO");
    }

    @Override
    public SQLRow getRowLanguage() {
        SQLRow rowClient = this.row.getForeignRow("ID_CLIENT");
        if (rowClient.getTable().contains("ID_LANGUE")) {
            if (!rowClient.isForeignEmpty("ID_LANGUE")) {
                return rowClient.getForeign("ID_LANGUE");
            }
            return null;
        }
        return super.getRowLanguage();
    }

    public VenteFactureXmlSheet(SQLRow row) {
        super(row);
        this.printer = PrinterNXProps.getInstance().getStringProperty("FacturePrinter");
        this.elt = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE");
        this.getDefaultTemplateId();
    }

    @Override
    public String getType() {
        String type = this.row.getBoolean("COMPLEMENT") != false ? "Complement" : (this.row.getBoolean("ACOMPTE") != false ? "Acompte" : (this.row.getBoolean("PARTIAL") != false || this.row.getBoolean("SOLDE") != false ? TEMPLATE_SITUATION_SUFFIX : null));
        return type;
    }

    @Override
    public String getDefaultTemplateId() {
        return TEMPLATE_ID;
    }
}

