/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.payment.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.erp.core.common.element.BanqueSQLElement;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.finance.accounting.element.MouvementSQLElement;
import org.openconcerto.erp.core.finance.payment.component.ModeDeReglementSQLComponent;
import org.openconcerto.erp.core.finance.payment.ui.RegleMontantTable;
import org.openconcerto.erp.generationEcritures.GenerationReglementAchat;
import org.openconcerto.erp.preferences.ModeReglementDefautPrefPanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.ElementSQLObject;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.ui.warning.JLabelWarning;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class ReglerMontantSQLComponent
extends BaseSQLComponent {
    private RegleMontantTable table = new RegleMontantTable();
    private DeviseField montant = new DeviseField(10);
    private JDate date;
    private JLabel labelWarning = new JLabelWarning();
    private JLabel labelWarningText = new JLabel("Le montant n'est pas valide!");

    public ReglerMontantSQLComponent(SQLElement elt) {
        super(elt);
    }

    @Override
    public void select(SQLRowAccessor r) {
        super.select(r);
        if (r != null) {
            this.table.getRowValuesTable().insertFrom(r);
        }
    }

    @Override
    public void addViews() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 0;
        c.weightx = 1.0;
        this.add((Component)new JLabelBold("Ech\u00e9ances"), c);
        ++c.gridy;
        c.weighty = 1.0;
        c.fill = 1;
        this.add((Component)this.table, c);
        this.table.getRowValuesTable().setEnabled(false);
        c.fill = 2;
        c.gridwidth = 1;
        ++c.gridy;
        c.weighty = 0.0;
        ElementComboBox comboFournisseur = new ElementComboBox(true, 25);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)new JLabel(this.getLabelFor("ID_FOURNISSEUR"), 4), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 1;
        this.add((Component)comboFournisseur, c);
        this.addSQLObject(comboFournisseur, "ID_FOURNISSEUR");
        this.date = new JDate(true);
        ++c.gridx;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.add((Component)new JLabel("Date", 4), c);
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)this.date, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Montant r\u00e9gl\u00e9", 4), c);
        ++c.gridx;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        this.add((Component)this.montant, c);
        ++c.gridx;
        c.gridwidth = 1;
        c.fill = 2;
        this.labelWarning.setHorizontalAlignment(4);
        this.add((Component)this.labelWarning, c);
        ++c.gridx;
        this.add((Component)this.labelWarningText, c);
        c.gridwidth = 0;
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.insets = new Insets(10, 2, 1, 2);
        this.add((Component)new JLabelBold("Mode de r\u00e8glement"), c);
        c.insets = new Insets(2, 2, 1, 2);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        this.addView("ID_MODE_REGLEMENT", "required;notdecorated;noseparator");
        final ElementSQLObject eltModeRegl = (ElementSQLObject)this.getView("ID_MODE_REGLEMENT");
        this.add((Component)eltModeRegl, c);
        ModeDeReglementSQLComponent modeReglComp = (ModeDeReglementSQLComponent)eltModeRegl.getSQLChild();
        modeReglComp.addDateCompListener(this.date);
        this.addRequiredSQLObject(this.date, "DATE");
        this.addRequiredSQLObject(this.montant, "MONTANT");
        final TableModelListener tableListener = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                RowValuesTableModel model = ReglerMontantSQLComponent.this.table.getRowValuesTable().getRowValuesTableModel();
                if (e.getColumn() == -1 || e.getColumn() == model.getColumnIndexForElement(ReglerMontantSQLComponent.this.table.getMontantElement())) {
                    int rowCount = model.getRowCount();
                    long total = 0L;
                    int i = 0;
                    while (i < rowCount) {
                        Number nHT = (Number)model.getValueAt(i, model.getColumnIndexForElement(ReglerMontantSQLComponent.this.table.getMontantElement()));
                        if (nHT != null) {
                            total += nHT.longValue();
                        }
                        ++i;
                    }
                    ReglerMontantSQLComponent.this.montant.setText(GestionDevise.currencyToString(total));
                    if (ReglerMontantSQLComponent.this.getMode() == SQLComponent.Mode.INSERTION && rowCount >= 1) {
                        int idScr = MouvementSQLElement.getSourceId(model.getRowValuesAt(0).getInt("ID_MOUVEMENT_ECHEANCE"));
                        SQLTable tableMvt = Configuration.getInstance().getDirectory().getElement("MOUVEMENT").getTable();
                        if (idScr > 1) {
                            SQLRow rowModeRegl;
                            SQLRow rowSource;
                            SQLRow rowMvt = tableMvt.getRow(idScr);
                            String source = rowMvt.getString("SOURCE");
                            int idSource = rowMvt.getInt("IDSOURCE");
                            SQLElement eltSource = Configuration.getInstance().getDirectory().getElement(source);
                            if (eltSource != null && (rowSource = eltSource.getTable().getRow(idSource)) != null && (rowModeRegl = rowSource.getForeignRow("ID_MODE_REGLEMENT")) != null) {
                                System.err.println("Set mode de r\u00e8glement");
                                int idTypeRegl = rowModeRegl.getInt("ID_TYPE_REGLEMENT");
                                SQLTable tableModeRegl = Configuration.getInstance().getDirectory().getElement("MODE_REGLEMENT").getTable();
                                SQLRowValues rowVals = new SQLRowValues(tableModeRegl);
                                rowVals.put("ID_TYPE_REGLEMENT", idTypeRegl);
                                rowVals.put("COMPTANT", Boolean.TRUE);
                                rowVals.put("AJOURS", 0);
                                rowVals.put("LENJOUR", 0);
                                rowVals.put("ID_" + BanqueSQLElement.TABLENAME, rowModeRegl.getInt("ID_" + BanqueSQLElement.TABLENAME));
                                eltModeRegl.setValue(rowVals);
                            }
                        }
                    }
                }
                if (e.getColumn() == -1 || e.getColumn() == model.getColumnIndexForElement(ReglerMontantSQLComponent.this.table.getMontantAReglerElement())) {
                    ReglerMontantSQLComponent.this.updateWarning();
                }
            }
        };
        this.montant.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                ReglerMontantSQLComponent.this.table.getRowValuesTable().getRowValuesTableModel().removeTableModelListener(tableListener);
                ReglerMontantSQLComponent.this.updateMontant(ReglerMontantSQLComponent.this.montant.getText());
                ReglerMontantSQLComponent.this.table.getRowValuesTable().getRowValuesTableModel().addTableModelListener(tableListener);
                ReglerMontantSQLComponent.this.updateWarning();
            }
        });
        this.table.getRowValuesTable().getRowValuesTableModel().addTableModelListener(tableListener);
    }

    @Override
    public int insert(SQLRow order) {
        int id = super.insert(order);
        try {
            this.table.updateField("ID_REGLER_MONTANT", id);
            System.out.println("G\u00e9n\u00e9ration des ecritures du reglement");
            new GenerationReglementAchat(id);
            SQLRow row = this.getTable().getRow(id);
            Collection l = row.getReferentRows(Configuration.getInstance().getDirectory().getElement("REGLER_MONTANT_ELEMENT").getTable());
            if (l.isEmpty()) {
                JOptionPane.showMessageDialog(null, "Un probl\u00e8me a \u00e9t\u00e9 rencontr\u00e9 lors du d\u00e9caissement! \n Les \u00e9critures comptables non pu \u00eatre g\u00e9n\u00e9rer!");
                System.err.println("Liste des \u00e9ch\u00e9ances vides pour le d\u00e9caissement ID " + id);
                Thread.dumpStack();
            }
            for (SQLRow sqlRow : l) {
                SQLRow rowEch = sqlRow.getForeignRow("ID_ECHEANCE_FOURNISSEUR");
                SQLRowValues rowValsEch = rowEch.createEmptyUpdateRow();
                if (sqlRow.getLong("MONTANT_REGLE") >= sqlRow.getLong("MONTANT_A_REGLER")) {
                    rowValsEch.put("REGLE", Boolean.TRUE);
                }
                rowValsEch.put("MONTANT", rowEch.getLong("MONTANT") - sqlRow.getLong("MONTANT_REGLE"));
                rowValsEch.update();
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle("Erreur lors de la g\u00e9n\u00e9ration des ecritures du reglement", e);
        }
        return id;
    }

    private void updateMontant(String s) {
        long total = 0L;
        if (s.trim().length() > 0) {
            total = GestionDevise.parseLongCurrency(s);
        }
        RowValuesTableModel model = this.table.getRowValuesTable().getRowValuesTableModel();
        int rowCount = model.getRowCount();
        int i = 0;
        while (i < rowCount) {
            Number nHT = (Number)model.getValueAt(i, model.getColumnIndexForElement(this.table.getMontantAReglerElement()));
            Long value = 0L;
            value = i < rowCount - 1 ? (nHT.longValue() <= total ? Long.valueOf(nHT.longValue()) : Long.valueOf(total)) : Long.valueOf(total);
            model.putValue(value, i, "MONTANT_REGLE");
            total -= value.longValue();
            ++i;
        }
    }

    @Override
    protected SQLRowValues createDefaults() {
        SQLRowValues vals = new SQLRowValues(this.getTable());
        this.table.getModel().clearRows();
        try {
            SQLRow r = ModeReglementDefautPrefPanel.getDefaultRow(false);
            SQLElement eltModeReglement = Configuration.getInstance().getDirectory().getElement("MODE_REGLEMENT");
            if (((SQLRowAccessor)r).getID() > 1) {
                SQLRowValues rowVals = eltModeReglement.createCopy(((SQLRowAccessor)r).getID());
                System.err.println(rowVals.getInt("ID_TYPE_REGLEMENT"));
                vals.put("ID_MODE_REGLEMENT", (Object)rowVals);
            }
        }
        catch (SQLException e) {
            System.err.println("Impossible de s\u00e9lectionner le mode de r\u00e8glement par d\u00e9faut du client.");
            e.printStackTrace();
        }
        return vals;
    }

    private final void updateWarning() {
        long montantValue = 0L;
        if (this.table.getRowValuesTable().getRowCount() == 0) {
            this.labelWarning.setVisible(false);
            this.labelWarningText.setVisible(false);
            return;
        }
        try {
            if (this.montant.getText().trim().length() != 0) {
                montantValue = GestionDevise.parseLongCurrency(this.montant.getText().trim());
            }
        }
        catch (NumberFormatException e) {
            System.err.println("format float incorrect " + e);
            e.printStackTrace();
        }
        RowValuesTableModel model = this.table.getRowValuesTable().getRowValuesTableModel();
        int rowCount = model.getRowCount();
        long total = 0L;
        int i = 0;
        while (i < rowCount) {
            Number nHT = (Number)model.getValueAt(i, model.getColumnIndexForElement(this.table.getMontantAReglerElement()));
            total += nHT.longValue();
            ++i;
        }
        this.labelWarning.setVisible(montantValue <= 0L || montantValue > total);
        this.labelWarningText.setVisible(montantValue <= 0L || montantValue > total);
    }

    public void loadEcheancesFromRows(List<SQLRow> rows) {
        Collections.sort(rows, new Comparator<SQLRow>(){

            @Override
            public int compare(SQLRow o1, SQLRow o2) {
                Calendar c1 = o1.getDate("DATE");
                Calendar c2 = o2.getDate("DATE");
                if (c1 == null) {
                    return -1;
                }
                if (c2 == null) {
                    return 1;
                }
                if (c1.getTime().before(c2.getTime())) {
                    return -1;
                }
                return 1;
            }
        });
        SQLTable tableEch = Configuration.getInstance().getDirectory().getElement("ECHEANCE_FOURNISSEUR").getTable();
        SQLTable tableEnc = Configuration.getInstance().getDirectory().getElement("REGLER_MONTANT_ELEMENT").getTable();
        SQLInjector inj = SQLInjector.getInjector(tableEch, tableEnc);
        for (SQLRow row : rows) {
            SQLRowValues rowVals = inj.createRowValuesFrom(row.getID());
            rowVals.put("MONTANT_REGLE", rowVals.getObject("MONTANT_A_REGLER"));
            this.table.getModel().addRow(rowVals);
            int rowIndex = this.table.getModel().getRowCount() - 1;
            this.table.getModel().fireTableModelModified(rowIndex);
        }
        this.table.getModel().fireTableDataChanged();
        this.table.repaint();
    }
}

