/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.report;

import com.ibm.icu.text.SimpleDateFormat;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.openconcerto.erp.core.finance.accounting.report.PdfGenerator_2033B;
import org.openconcerto.task.config.ComptaBasePropsConfiguration;
import org.openconcerto.utils.ExceptionHandler;

public abstract class PdfGenerator {
    private int offsetX;
    private int offsetY;
    private int templateOffsetX;
    private int templateOffsetY;
    private PdfContentByte cb;
    private Document document;
    private BaseFont bf;
    private BaseFont bfb;
    private int width;
    private Map<String, String> map;
    private String fileNameIn;
    private String fileNameOut;
    private File directoryOut;
    private File fOut;

    public static void main(String[] args) {
        new PdfGenerator_2033B().generateFrom(null);
    }

    PdfGenerator(String fileNameIn, String fileNameOut, String directoryOut) {
        this.fileNameIn = "/Configuration/Template/PDF/" + fileNameIn;
        this.fileNameOut = fileNameOut;
        this.directoryOut = new File(directoryOut, String.valueOf(Calendar.getInstance().get(1)));
    }

    public void generateFrom(Map<String, String> m) {
        try {
            if (m == null) {
                System.err.println(this + " : filling with defaults");
            }
            this.map = m;
            this.init();
            this.cb.beginText();
            this.generate();
            this.cb.endText();
            this.document.close();
        }
        catch (FileNotFoundException e) {
            ExceptionHandler.handle("Impossible de g\u00e9n\u00e9rer le fichier. \n" + e, e);
        }
    }

    private void init() throws FileNotFoundException {
        PdfWriter writer = null;
        try (PdfReader reader = null;){
            try {
                reader = new PdfReader(ComptaBasePropsConfiguration.getStreamStatic(this.fileNameIn));
                Rectangle psize = reader.getPageSize(1);
                psize.setRight(psize.getRight() - (float)this.templateOffsetX);
                psize.setTop(psize.getTop() - (float)this.templateOffsetY);
                this.width = (int)psize.getWidth();
                int margin = 32;
                this.document = new Document(psize, (float)margin, (float)margin, (float)margin, (float)margin);
                if (!this.directoryOut.exists()) {
                    this.directoryOut.mkdirs();
                }
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd-HHmmss");
                String computedFileName = String.valueOf(sdf.format(new Date())) + "-" + this.fileNameOut;
                this.fOut = new File(this.directoryOut, computedFileName);
                System.err.println("Creation du fichier " + this.fOut.getCanonicalPath());
                writer = PdfWriter.getInstance((Document)this.document, (OutputStream)new FileOutputStream(this.fOut));
                this.document.open();
                this.cb = writer.getDirectContent();
                this.document.newPage();
                PdfImportedPage page1 = writer.getImportedPage(reader, 1);
                this.cb.addTemplate((PdfTemplate)page1, (float)(-this.templateOffsetX), (float)(-this.templateOffsetY));
                this.bf = BaseFont.createFont((String)"Times-Roman", (String)"Cp1252", (boolean)true);
                this.bfb = BaseFont.createFont((String)"Times-Bold", (String)"Cp1252", (boolean)true);
            }
            catch (FileNotFoundException fE) {
                throw fE;
            }
            catch (DocumentException | IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public abstract void generate();

    public File getGeneratedFile() {
        return this.fOut;
    }

    protected void setOffset(int i, int j) {
        this.offsetX = i;
        this.offsetY = j;
    }

    protected void setTemplateOffset(int i, int j) {
        this.templateOffsetX = i;
        this.templateOffsetY = j;
    }

    protected void addSplittedText(String code, String string, int fromx, int y, double deltax) {
        int x = fromx - this.offsetX - this.templateOffsetX;
        y = y - this.offsetY - this.templateOffsetY;
        boolean error = false;
        String s = string;
        if (this.map != null) {
            s = this.map.get(code);
        }
        if (s == null) {
            s = code;
            error = true;
            this.cb.setColorFill(Color.RED);
        }
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            String sub = String.valueOf(c);
            this.cb.showTextAligned(0, sub, (float)x, (float)y, 0.0f);
            x = (int)((double)x + deltax);
            ++i;
        }
        if (error) {
            this.cb.setColorStroke(Color.BLACK);
        }
    }

    protected void setFontRoman(int i) {
        this.cb.setFontAndSize(this.bf, (float)i);
    }

    protected void setFontBold(int i) {
        this.cb.setFontAndSize(this.bfb, (float)i);
    }

    protected void addText(String code, String string, int i, int j) {
        this.addText(code, string, i, j, 0);
    }

    protected void addText(String code, String string, int i, int j, int k) {
        this.addText(0, code, string, i, j, k);
    }

    protected void addTextRight(String code, String string, int i, int j) {
        int a = 2;
        boolean k = false;
        if (this.map == null) {
            this.cb.showTextAligned(a, string, (float)i, (float)j, (float)k);
        } else {
            boolean error = false;
            String s = this.map.get(code);
            if (s == null) {
                s = code;
                error = true;
            } else {
                if (s.equalsIgnoreCase("-0.0")) {
                    s = "0.0";
                }
                s = PdfGenerator.insertCurrencySpaces(s);
            }
            this.cb.showTextAligned(a, s, (float)i, (float)j, (float)k);
            if (error) {
                this.cb.setColorStroke(Color.BLACK);
            }
        }
    }

    private final void addText(int a, String code, String string, int i, int j, int k) {
        if (this.map == null) {
            this.cb.showTextAligned(a, string, (float)i, (float)j, (float)k);
        } else {
            boolean error = false;
            String s = this.map.get(code);
            if (s == null) {
                s = code;
                error = true;
            }
            this.cb.showTextAligned(a, s, (float)i, (float)j, (float)k);
            if (error) {
                this.cb.setColorStroke(Color.BLACK);
            }
        }
    }

    protected int getWidth() {
        return this.width;
    }

    protected static String insertCurrencySpaces(String string) {
        StringBuilder s = new StringBuilder();
        int i = string.length() - 1;
        while (i >= 0) {
            s.insert(0, string.charAt(i));
            if ((i - string.length()) % 3 == 0) {
                s.insert(0, " ");
            }
            --i;
        }
        return s.toString().trim();
    }
}

