/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.table.TableCellEditor;
import org.openconcerto.erp.core.common.ui.RowValuesMultiLineEditTable;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.view.list.RowValuesTable;

public class MultiLineTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private JDialog frame;
    private JTextField text;
    private boolean popupOpen = false;
    private RowValuesMultiLineEditTable tableItem;
    private JPanel panel;

    public MultiLineTableCellEditor(RowValuesMultiLineEditTable rowValuesTable, JPanel panel) {
        this.tableItem = rowValuesTable;
        this.panel = panel;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.text = new JTextField();
        this.createJFrame(table, row, column);
        this.text.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
                MultiLineTableCellEditor.this.showPopup();
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }
        });
        return this.text;
    }

    private void createJFrame(JTable table, int row, int column) {
        if (table instanceof RowValuesTable) {
            RowValuesTable rowValuesTable = (RowValuesTable)table;
            SQLRowValues rowVals = rowValuesTable.getRowValuesTableModel().getRowValuesAt(row);
            this.tableItem.getRowValuesTableModel().clearRows();
            this.tableItem.setRoots(rowValuesTable, row, rowVals);
        }
        JFrame rootFrame = (JFrame)SwingUtilities.getRoot(table);
        if (this.frame != null) {
            this.frame.dispose();
            this.frame = null;
        }
        this.frame = new JDialog((Frame)rootFrame, true);
        this.frame.setUndecorated(true);
        this.frame.getContentPane().add(this.panel);
        Rectangle rect = table.getCellRect(row, column, true);
        Point p = new Point(rect.x, rect.y + table.getRowHeight(row));
        SwingUtilities.convertPointToScreen(p, table);
        this.frame.pack();
        this.frame.setLocation(p.x - this.frame.getWidth() + rect.width, p.y);
        this.panel.grabFocus();
    }

    public void showPopup() {
        this.popupOpen = true;
        this.frame.setVisible(true);
        this.frame.requestFocusInWindow();
        this.frame.requestFocus();
    }

    @Override
    public Object getCellEditorValue() {
        return this.tableItem.getStringValue();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    public void refreshText() {
        this.text.setText(this.tableItem.getStringValue());
    }

    public void setTable(RowValuesMultiLineEditTable table) {
        this.tableItem = table;
    }
}

