/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.i18n;

import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.i18n.GrammaticalBase;
import org.openconcerto.utils.i18n.GrammaticalCase;
import org.openconcerto.utils.i18n.GrammaticalNumber;
import org.openconcerto.utils.i18n.VariantKey;

public class DefaultVariantKey
implements VariantKey {
    private final String id;
    private final GrammaticalNumber grNumber;
    private final GrammaticalCase grCase;
    private final String variant;

    private static final String camelCaseCat(Object ... l) {
        StringBuilder sb = new StringBuilder(64);
        Object[] objectArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o != null) {
                String s = o instanceof GrammaticalBase ? ((GrammaticalBase)o).getName() : o.toString();
                sb.append(sb.length() == 0 ? s : StringUtils.firstUp(s));
            }
            ++n2;
        }
        return sb.toString();
    }

    public DefaultVariantKey(GrammaticalNumber grNumber, String variant) {
        this(grNumber, null, variant);
    }

    public DefaultVariantKey(GrammaticalNumber grNumber, GrammaticalCase grCase, String variant) {
        this(null, grNumber, grCase, variant);
    }

    public DefaultVariantKey(String id, GrammaticalNumber grNumber, String variant) {
        this(id, grNumber, null, variant);
    }

    public DefaultVariantKey(String id, GrammaticalNumber grNumber, GrammaticalCase grCase, String variant) {
        if (id == null) {
            id = DefaultVariantKey.camelCaseCat(grCase, grNumber, variant);
        }
        if (id.length() == 0) {
            throw new IllegalArgumentException("Empty ID");
        }
        this.id = id;
        this.grNumber = grNumber;
        this.grCase = grCase;
        this.variant = variant;
    }

    @Override
    public final String getID() {
        return this.id;
    }

    public final GrammaticalNumber getNumber() {
        return this.grNumber;
    }

    public final GrammaticalCase getCase() {
        return this.grCase;
    }

    public final String getVariant() {
        return this.variant;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " '" + this.getID() + "'";
    }
}

