/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

public abstract class Value<V> {
    private static final Value NONE = new Value(false){

        public Object getValue() {
            throw new IllegalStateException(this.toString());
        }

        public String toString() {
            return "No Value";
        }
    };
    private final boolean hasValue;

    public static <V> Value<V> getNone() {
        return NONE;
    }

    public static <V> Value<V> getSome(V value) {
        return new Some<V>(value);
    }

    public static <V> Value<V> fromNonNull(V value) {
        return value == null ? Value.getNone() : Value.getSome(value);
    }

    private Value(boolean hasValue) {
        this.hasValue = hasValue;
    }

    public final boolean hasValue() {
        return this.hasValue;
    }

    public abstract V getValue() throws IllegalStateException;

    public final V toNonNull() throws IllegalStateException {
        if (!this.hasValue()) {
            return null;
        }
        V res = this.getValue();
        if (res == null) {
            throw new IllegalStateException("Null value");
        }
        return res;
    }

    /* synthetic */ Value(boolean bl, Value value) {
        this(bl);
    }

    private static final class Some<V>
    extends Value<V> {
        private final V val;

        public Some(V val) {
            super(true, null);
            this.val = val;
        }

        @Override
        public V getValue() {
            return this.val;
        }

        public String toString() {
            return "Value <" + this.getValue() + '>';
        }
    }
}

