/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.DesktopEnvironment;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.cc.ITransformer;

public abstract class Platform {
    private static final int PING_TIMEOUT = 250;
    private static final Platform LINUX = new Platform(){

        @Override
        public boolean supportsPID() {
            return true;
        }

        @Override
        public final boolean isRunning(int pid) throws IOException {
            Process p = Runtime.getRuntime().exec(new String[]{"ps", "-p", String.valueOf(pid)});
            return this.exitStatus(p) == 0;
        }

        @Override
        public String getPath(File f) {
            return f.getPath();
        }

        @Override
        protected String getBash() {
            return "bash";
        }

        @Override
        public String readLink(File f) throws IOException {
            Process p = Runtime.getRuntime().exec(new String[]{"readlink", "--no-newline", f.getAbsolutePath()});
            return DesktopEnvironment.cmdSubstitution(p);
        }

        @Override
        public boolean ping(InetAddress host, int timeout) throws IOException {
            return host.isReachable(timeout);
        }

        @Override
        public boolean isAdmin() throws IOException {
            return DesktopEnvironment.cmdSubstitution(this.eval("id -u")).trim().equals("0");
        }
    };
    private static final Platform CYGWIN = new Platform(){

        @Override
        public boolean supportsPID() {
            return false;
        }

        @Override
        public boolean isRunning(int pid) throws IOException {
            Process p = this.eval("export PATH=$PATH:/usr/bin ; test $(ps -sW -p " + pid + " | wc -l) -eq 2 ");
            return this.exitStatus(p) == 0;
        }

        @Override
        protected String getBash() {
            return "C:\\cygwin\\bin\\bash.exe";
        }

        @Override
        public String readLink(File f) throws IOException {
            Process p = Runtime.getRuntime().exec(new String[]{"readshortcut.exe", "-w", f.getAbsolutePath()});
            return DesktopEnvironment.cmdSubstitution(p).trim();
        }

        @Override
        public String getPath(File f) {
            return 2.toCygwinPath(f);
        }

        @Override
        public boolean ping(InetAddress host, int timeout) throws IOException {
            try {
                int exit = Runtime.getRuntime().exec("ping -n 1 -w " + timeout + " " + host.getHostAddress()).waitFor();
                return exit == 0;
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public boolean isAdmin() throws IOException {
            return this.exitStatus(this.eval("id -G | grep '\\b544\\b'")) == 0;
        }

        @Override
        public boolean isSymLink(File f) throws IOException {
            return this.getNativeSymlinkFile(f).exists() || super.isSymLink(f);
        }

        @Override
        public File getNativeSymlinkFile(File dir) {
            return FileUtils.addSuffix(dir, ".lnk");
        }
    };

    public static final Platform getInstance() {
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows")) {
            return CYGWIN;
        }
        return LINUX;
    }

    public abstract boolean supportsPID();

    public abstract boolean isRunning(int var1) throws IOException;

    public abstract String getPath(File var1);

    public final String getPID() throws IOException {
        Process p = this.eval("echo -n $PPID");
        BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
        try {
            String string = reader.readLine();
            return string;
        }
        finally {
            reader.close();
        }
    }

    public final String tail(File f, int n) throws IOException {
        Process p = Runtime.getRuntime().exec(new String[]{"tail", "-n" + n, this.getPath(f)});
        return DesktopEnvironment.cmdSubstitution(p);
    }

    protected abstract String getBash();

    public final void ln_s(File f1, File f2) throws IOException {
        FileUtils.ln(f1, f2);
    }

    public boolean isSymLink(File f) throws IOException {
        return this.exitStatus(Runtime.getRuntime().exec(new String[]{"test", "-L", f.getAbsolutePath()})) == 0;
    }

    public File getNativeSymlinkFile(File dir) {
        return dir;
    }

    public abstract String readLink(File var1) throws IOException;

    public final boolean exists(File f) throws IOException {
        return this.exitStatus(Runtime.getRuntime().exec(new String[]{"test", "-e", f.getAbsolutePath()})) == 0;
    }

    public final void append(File f1, File f2) throws IOException {
        String c = "cat '" + f1.getAbsolutePath() + "' >> '" + f2.getAbsolutePath() + "'";
        try {
            this.eval(c).waitFor();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    public Process cp_l(File src, File dest) throws IOException {
        return Runtime.getRuntime().exec(new String[]{"cp", "-prl", src.getAbsolutePath(), dest.getAbsolutePath()});
    }

    public final boolean ping(InetAddress host) throws IOException {
        return this.ping(host, 250);
    }

    public abstract boolean ping(InetAddress var1, int var2) throws IOException;

    public final Process eval(String s) throws IOException {
        return Runtime.getRuntime().exec(new String[]{this.getBash(), "-c", s});
    }

    public final int exitStatus(Process p) {
        try {
            return p.waitFor();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    public abstract boolean isAdmin() throws IOException;

    public static String toCygwinPath(File dir) {
        List<File> ancestors = Platform.getAncestors(dir);
        String root = ancestors.get(0).getPath();
        List<File> rest = ancestors.subList(1, ancestors.size());
        return "/cygdrive/" + root.charAt(0) + "/" + CollectionUtils.join(rest, "/", new ITransformer<File, String>(){

            @Override
            public String transformChecked(File f) {
                return f.getName();
            }
        });
    }

    public static List<File> getAncestors(File f) {
        File abs;
        File current = abs = f.getAbsoluteFile();
        ArrayList<File> res = new ArrayList<File>();
        while (current != null) {
            res.add(0, current);
            current = current.getParentFile();
        }
        return res;
    }
}

