/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.list;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JLabel;

public class HighLightableJLabel
extends JLabel {
    public static Color DEFAULT_COLOR = new Color(252, 252, 180);
    private String text;
    private Color highLightColor = DEFAULT_COLOR;

    public void setHightlight(String text) {
        this.text = text;
    }

    public void setHighLightColor(Color highLightColor) {
        this.highLightColor = highLightColor;
    }

    @Override
    public void paint(Graphics g) {
        String currentText;
        int offset;
        if (this.highLightColor != null && this.text != null && (offset = (currentText = this.getText()).indexOf(this.text)) >= 0) {
            FontMetrics metrics = g.getFontMetrics();
            String start = this.getText().substring(0, offset);
            int startX = metrics.stringWidth(start);
            int startY = 0;
            int length = metrics.stringWidth(this.text);
            int height = metrics.getHeight();
            g.setColor(this.highLightColor);
            g.fillRect(startX, startY, length, height);
        }
        super.paint(g);
    }
}

