/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openconcerto.ui.light.Row;

public class RowsBulk
implements Externalizable {
    private List<Row> rows;
    private int offset;
    private int total;

    public RowsBulk() {
    }

    public RowsBulk(List<Row> rows, int offset, int total) {
        this.rows = rows;
        this.offset = offset;
        this.total = total;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int rowCount = in.readInt();
        if (rowCount == 0) {
            this.rows = Collections.EMPTY_LIST;
        } else {
            this.rows = new ArrayList<Row>(rowCount);
            int columnCount = in.readByte();
            int j = 0;
            while (j < rowCount) {
                Row row = new Row(in.readLong(), columnCount);
                this.rows.add(row);
                ++j;
            }
            int i = 0;
            while (i < columnCount) {
                int j2 = 0;
                while (j2 < rowCount) {
                    Object v = in.readObject();
                    this.rows.get(j2).addValue(v);
                    ++j2;
                }
                ++i;
            }
        }
        this.offset = in.readInt();
        this.total = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int rowCount = this.rows.size();
        out.writeInt(rowCount);
        if (this.rows.size() > 0) {
            int columnCount = this.rows.get(0).getValues().size();
            out.writeByte(columnCount);
            int j = 0;
            while (j < rowCount) {
                Row row = this.rows.get(j);
                out.writeLong(row.getId());
                ++j;
            }
            int i = 0;
            while (i < columnCount) {
                int j2 = 0;
                while (j2 < rowCount) {
                    Row row = this.rows.get(j2);
                    Object v = row.getValues().get(i);
                    out.writeObject(v);
                    ++j2;
                }
                ++i;
            }
        }
        out.writeInt(this.offset);
        out.writeInt(this.total);
    }

    public List<Row> getRows() {
        return this.rows;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getTotal() {
        return this.total;
    }
}

