/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.openconcerto.utils.io.JSONAble;
import org.openconcerto.utils.io.JSONconverter;

public class RowSpec
implements Externalizable,
JSONAble {
    private String tableId;
    private String[] columnIds;

    public RowSpec() {
    }

    public RowSpec(String tableId, String[] columnIds) {
        this.tableId = tableId;
        this.columnIds = columnIds;
    }

    public String[] getIds() {
        return this.columnIds;
    }

    public void setIds(String[] columnIds) {
        this.columnIds = columnIds;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public String getTableId() {
        return this.tableId;
    }

    public String toString() {
        String r = "RowSpec:" + this.tableId + " : ";
        int i = 0;
        while (i < this.columnIds.length) {
            r = i < this.columnIds.length - 1 ? String.valueOf(r) + this.columnIds[i] + ", " : String.valueOf(r) + this.columnIds[i];
            ++i;
        }
        return r;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        try {
            out.writeUTF(this.tableId);
            out.writeObject(this.columnIds);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.tableId = in.readUTF();
        this.columnIds = (String[])in.readObject();
    }

    @Override
    public String toJSON() {
        StringBuilder result = new StringBuilder("{");
        result.append("\"tableId\":" + JSONconverter.getJSON(this.tableId) + ",");
        result.append("\"columnIds\":" + JSONconverter.getJSON(this.columnIds));
        result.append("}");
        return result.toString();
    }
}

