/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.openconcerto.ui.light.LightControler;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.ui.light.LightUILine;
import org.openconcerto.utils.io.JSONconverter;
import org.openconcerto.utils.io.Transferable;

public class LightUIDescriptor
extends LightUIElement
implements Transferable {
    private static final long serialVersionUID = -3399395824294128572L;
    private List<LightUILine> lines = new ArrayList<LightUILine>();
    private String title;
    private List<LightControler> controlers = new ArrayList<LightControler>();

    public LightUIDescriptor(String id) {
        this.setId(id);
        this.setType(8);
    }

    public void addLine(LightUILine line) {
        this.lines.add(line);
    }

    public LightUILine getLastLine() {
        if (this.lines.size() == 0) {
            LightUILine l = new LightUILine();
            this.lines.add(l);
            return l;
        }
        return this.lines.get(this.lines.size() - 1);
    }

    @Override
    public void dump(PrintStream out) {
        int size = this.lines.size();
        out.println(String.valueOf(this.getId()) + " : " + this.title);
        out.println("LightUIDescriptor " + size + " lines ");
        int i = 0;
        while (i < size) {
            LightUILine line = this.lines.get(i);
            out.println("LightUIDescriptor line " + i);
            line.dump(out);
            out.println();
            ++i;
        }
    }

    public LightUILine getLine(int i) {
        return this.lines.get(i);
    }

    public int getSize() {
        return this.lines.size();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void addControler(LightControler controler) {
        this.controlers.add(controler);
    }

    public List<LightControler> getControlers() {
        return this.controlers;
    }

    public void dumpControllers(PrintStream out) {
        this.dumpControllers(out, 0);
    }

    public void dumpControllers(PrintStream out, int depth) {
        this.addSpacer(out, depth);
        out.println("Contollers for id:" + this.getId() + " title: " + this.title);
        for (LightControler controler : this.controlers) {
            this.addSpacer(out, depth);
            out.println(controler);
        }
        int size = this.lines.size();
        this.addSpacer(out, depth);
        out.println(String.valueOf(this.getId()) + " : " + this.title);
        this.addSpacer(out, depth);
        out.println("LightUIDescriptor " + size + " lines ");
        int i = 0;
        while (i < size) {
            LightUILine line = this.lines.get(i);
            int j = 0;
            while (j < line.getSize()) {
                LightUIElement e = line.getElement(j);
                if (e instanceof LightUIDescriptor) {
                    ((LightUIDescriptor)e).dumpControllers(out, depth + 1);
                }
                ++j;
            }
            ++i;
        }
    }

    private void addSpacer(PrintStream out, int depth) {
        int i = 0;
        while (i < depth) {
            out.print("  ");
            ++i;
        }
    }

    @Override
    public String toJSON() {
        StringBuilder result = new StringBuilder("{");
        result.append("\"title\":" + JSONconverter.getJSON(this.title) + ",");
        result.append("\"lines\":" + JSONconverter.getJSON(this.lines) + ",");
        result.append("\"controlers\":" + JSONconverter.getJSON(this.controlers) + ",");
        result.append("\"element\":" + super.toJSON());
        result.append("}");
        return result.toString();
    }
}

