/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.group;

import org.openconcerto.ui.group.LayoutHintsBuilder;

public class LayoutHints {
    private final boolean visible;
    private final boolean largeWidth;
    private final boolean largeHeight;
    private final boolean showLabel;
    private final boolean separated;
    private final boolean fillWidth;
    private final boolean fillHeight;
    private final boolean split;
    public static final LayoutHints DEFAULT_FIELD_HINTS = new LayoutHints(false, false, true, false, false, false);
    public static final LayoutHints DEFAULT_LARGE_FIELD_HINTS = new LayoutHints(false, false, true, false, true, false);
    public static final LayoutHints DEFAULT_VERY_LARGE_FIELD_HINTS = new LayoutHints(true, false, true, false, false, false);
    public static final LayoutHints DEFAULT_VERY_LARGE_TEXT_HINTS = new LayoutHints(true, false, true, false, true, false, true);
    public static final LayoutHints DEFAULT_LIST_HINTS = new LayoutHints(true, true, false, true, true, true);
    public static final LayoutHints DEFAULT_GROUP_HINTS = new LayoutHints(true, false, false, false, true, true);
    public static final LayoutHints DEFAULT_SEPARATED_GROUP_HINTS = new LayoutHints(true, false, true, true, true, true);
    public static final LayoutHints DEFAULT_NOLABEL_SEPARATED_GROUP_HINTS = new LayoutHints(true, false, false, true, true, true);

    public LayoutHints(boolean largeWidth, boolean largeHeight, boolean showLabel) {
        this(largeWidth, largeHeight, showLabel, false, false, false);
    }

    public LayoutHints(boolean largeWidth, boolean largeHeight, boolean showLabel, boolean separated, boolean fillWidth, boolean fillHeight) {
        this(largeWidth, largeHeight, showLabel, separated, fillWidth, fillHeight, false);
    }

    public LayoutHints(boolean largeWidth, boolean largeHeight, boolean showLabel, boolean separated, boolean fillWidth, boolean fillHeight, boolean split) {
        this(largeWidth, largeHeight, showLabel, separated, fillWidth, fillHeight, split, true);
    }

    public LayoutHints(boolean largeWidth, boolean largeHeight, boolean showLabel, boolean separated, boolean fillWidth, boolean fillHeight, boolean split, boolean visible) {
        this.largeWidth = largeWidth;
        this.largeHeight = largeHeight;
        this.showLabel = showLabel;
        this.separated = separated;
        this.fillWidth = fillWidth;
        this.fillHeight = fillHeight;
        this.split = split;
        this.visible = visible;
    }

    public LayoutHints(LayoutHints localHint) {
        this.largeWidth = localHint.largeWidth;
        this.largeHeight = localHint.largeHeight;
        this.showLabel = localHint.showLabel;
        this.separated = localHint.separated;
        this.fillWidth = localHint.fillWidth;
        this.fillHeight = localHint.fillHeight;
        this.split = localHint.split;
        this.visible = localHint.visible;
    }

    public final LayoutHintsBuilder getBuilder() {
        return new LayoutHintsBuilder(this.largeWidth, this.largeHeight, this.showLabel).setFillHeight(this.fillHeight).setFillWidth(this.fillWidth).setSeparated(this.separated).setSplit(this.split).setVisible(this.visible);
    }

    public boolean largeWidth() {
        return this.largeWidth;
    }

    public boolean largeHeight() {
        return this.largeHeight;
    }

    public boolean showLabel() {
        return this.showLabel;
    }

    public boolean isSeparated() {
        return this.separated;
    }

    public boolean fillWidth() {
        return this.fillWidth;
    }

    public boolean fillHeight() {
        return this.fillHeight;
    }

    public boolean isSplit() {
        return this.split;
    }

    public String toString() {
        String r = "";
        if (this.largeHeight && this.largeWidth) {
            r = String.valueOf(r) + "LargeW&H";
        } else {
            if (this.largeHeight) {
                r = String.valueOf(r) + "LargeH";
            }
            if (this.largeWidth) {
                r = String.valueOf(r) + "LargeW";
            }
        }
        if (this.separated) {
            r = String.valueOf(r) + " Separated";
        }
        r = this.showLabel ? String.valueOf(r) + " StdLabel" : String.valueOf(r) + " NoLabel";
        if (this.split) {
            r = String.valueOf(r) + " (label and editor splitted)";
        }
        if (this.fillHeight && this.fillWidth) {
            r = String.valueOf(r) + " FillW&H";
        } else {
            if (this.fillHeight) {
                r = String.valueOf(r) + " FillH";
            }
            if (this.fillWidth) {
                r = String.valueOf(r) + " FillW";
            }
        }
        if (!this.isVisible()) {
            r = String.valueOf(r) + " (hidden)";
        }
        return r;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fillHeight ? 1231 : 1237);
        result = 31 * result + (this.fillWidth ? 1231 : 1237);
        result = 31 * result + (this.largeHeight ? 1231 : 1237);
        result = 31 * result + (this.largeWidth ? 1231 : 1237);
        result = 31 * result + (this.separated ? 1231 : 1237);
        result = 31 * result + (this.showLabel ? 1231 : 1237);
        result = 31 * result + (this.split ? 1231 : 1237);
        result = 31 * result + (this.visible ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LayoutHints other = (LayoutHints)obj;
        return this.fillHeight == other.fillHeight && this.fillWidth == other.fillWidth && this.largeHeight == other.largeHeight && this.largeWidth == other.largeWidth && this.separated == other.separated && this.showLabel == other.showLabel && this.split == other.split && this.visible == other.visible;
    }
}

