/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.component.combo;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.swing.SwingUtilities;
import org.openconcerto.ui.component.combo.ISearchableCombo;
import org.openconcerto.ui.component.combo.ISearchableComboItem;
import org.openconcerto.ui.component.combo.SearchMode;
import org.openconcerto.utils.IFutureTask;
import org.openconcerto.utils.RTInterruptedException;
import org.openconcerto.utils.model.ISearchable;

public class ISearchableComboCompletionThread<T>
extends Thread {
    private final ISearchableCombo<T> combo;
    private final String t;
    private boolean stopNow;

    public ISearchableComboCompletionThread(ISearchableCombo<T> combo, String t) {
        this.combo = combo;
        this.t = t;
        this.stopNow = false;
    }

    private ISearchableCombo<T> getCombo() {
        return this.combo;
    }

    @Override
    public void run() {
        this.computeAutoCompletion();
    }

    public synchronized void stopNow() {
        this.stopNow = true;
    }

    private synchronized boolean isStopped() {
        return this.stopNow;
    }

    private void computeAutoCompletion() {
        final boolean showAll = this.t == null;
        final List<ISearchableComboItem<T>> l = !showAll ? this.getMatchingValues() : this.getMaxValues();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ISearchableComboCompletionThread.this.isStopped()) {
                    return;
                }
                ISearchableComboCompletionThread.this.getCombo().setMatchingCompletions(l, showAll);
            }
        });
    }

    private List<ISearchableComboItem<T>> getMaxValues() {
        List<ISearchableComboItem<T>> allVals = this.getCombo().getModelValues();
        return allVals.subList(0, Math.min(this.getCombo().getMaximumResult(), allVals.size()));
    }

    private List<ISearchableComboItem<T>> getMatchingValues() {
        ISearchable searchableListModel;
        ArrayList<ISearchableComboItem<T>> result = new ArrayList<ISearchableComboItem<T>>();
        int minimumSearch = this.getCombo().getMinimumSearch();
        String aText = this.t.trim();
        String normalizedText = aText.length() < minimumSearch ? "" : aText;
        Boolean searched = null;
        if (this.getCombo().getCache() instanceof ISearchable && (searchableListModel = (ISearchable)((Object)this.getCombo().getCache())).isSearchable()) {
            FutureTask noOp = IFutureTask.createNoOp();
            searched = searchableListModel.setSearch(normalizedText, noOp);
            try {
                noOp.get();
            }
            catch (InterruptedException e) {
                throw new RTInterruptedException(e);
            }
            catch (ExecutionException e) {
                throw new IllegalStateException("No op couldn't be executed", e);
            }
        }
        if (!normalizedText.isEmpty() && searched != Boolean.FALSE) {
            List<ISearchableComboItem<T>> cache = this.getCombo().getModelValues();
            SearchMode.ComboMatcher search = Boolean.TRUE.equals(searched) ? null : this.getCombo().getCompletionMode().matcher(normalizedText.toLowerCase());
            int maximumResult = this.getCombo().getMaximumResult();
            int index = 0;
            while (index < cache.size()) {
                ISearchableComboItem<T> itemO = cache.get(index);
                String item = itemO.asString();
                if (index % 50 == 0 && this.isStopped()) {
                    return result;
                }
                boolean ok = search == null || search.match(item.toLowerCase());
                boolean removeDuplicate = true;
                if (ok) {
                    int i = 0;
                    while (i < result.size()) {
                        if (this.isStopped()) {
                            return result;
                        }
                        ISearchableComboItem element = (ISearchableComboItem)result.get(i);
                        if (element.asString().equalsIgnoreCase(item)) {
                            ok = false;
                            break;
                        }
                        ++i;
                    }
                }
                if (ok) {
                    result.add(itemO);
                }
                if (result.size() > maximumResult) break;
                ++index;
            }
        }
        return result;
    }

    static final List<String> cut(String value) {
        ArrayList<String> v = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(value);
        while (tokenizer.hasMoreElements()) {
            String element = (String)tokenizer.nextElement();
            v.add(element);
        }
        return v;
    }
}

