/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import org.jopencalendar.ui.DatePickerPanel;
import org.openconcerto.ui.TimeTextField;
import org.openconcerto.ui.table.TimestampTableCellEditor;

public class TimestampEditorPanel
extends JPanel
implements ActionListener {
    private TimeTextField time;
    private JPanel panelHour;
    private DatePickerPanel pickerPanel;
    private List<ActionListener> listeners = new Vector<ActionListener>();
    private TimestampTableCellEditor aCellEditor;
    private Calendar c = Calendar.getInstance();

    public TimestampEditorPanel() {
        this.c.set(13, 0);
        this.c.set(14, 0);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 3, 0, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 13;
        c.fill = 2;
        this.panelHour = new JPanel(new GridBagLayout());
        JLabel labelHour = new JLabel("Heure : ");
        labelHour.setFont(labelHour.getFont().deriveFont(1));
        this.panelHour.add((Component)labelHour, c);
        ++c.gridx;
        this.time = new TimeTextField();
        this.time.setMinimumSize(new Dimension(this.time.getPreferredSize()));
        this.panelHour.add((Component)this.time, c);
        ++c.gridx;
        JButton buttonClose = new JButton(new ImageIcon(TimestampEditorPanel.class.getResource("close_popup_gray.png")));
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TimestampEditorPanel.this.aCellEditor != null) {
                    TimestampEditorPanel.this.aCellEditor.hidePopup();
                    TimestampEditorPanel.this.aCellEditor.stopCellEditing();
                }
            }
        });
        buttonClose.setBorderPainted(false);
        buttonClose.setOpaque(false);
        buttonClose.setFocusPainted(false);
        buttonClose.setContentAreaFilled(false);
        buttonClose.setMargin(new Insets(1, 1, 1, 1));
        c.gridx = 0;
        this.panelHour.setOpaque(false);
        this.add((Component)this.panelHour, c);
        c.fill = 0;
        c.anchor = 12;
        c.weightx = 1.0;
        ++c.gridx;
        this.add((Component)buttonClose, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        c.insets = new Insets(4, 0, 0, 0);
        c.fill = 2;
        this.add((Component)new JSeparator(0), c);
        this.setBackground(Color.WHITE);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        c.fill = 1;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        this.pickerPanel = new DatePickerPanel();
        this.add((Component)this.pickerPanel, c);
        ++c.gridy;
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.pickerPanel.addPropertyChangeListener("timeInMillis", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TimestampEditorPanel.this.stateChanged();
                TimestampEditorPanel.this.fireTimeChangedPerformed();
            }
        });
        this.time.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TimestampEditorPanel.this.stateChanged();
                TimestampEditorPanel.this.fireTimeChangedPerformed();
            }
        });
    }

    public void setTime(Date time) {
        this.c.setTimeInMillis(time.getTime());
        int hour = this.c.get(11);
        int minute = this.c.get(12);
        this.pickerPanel.setSelectedDate(this.c);
        this.time.setTime(hour, minute);
    }

    public Timestamp getTime() {
        return new Timestamp(this.c.getTimeInMillis());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.stateChanged();
        this.fireTimeChangedPerformed();
    }

    public void stateChanged() {
        this.c.setTime(this.pickerPanel.getSelectedDate());
        this.c.set(11, this.time.getHours());
        this.c.set(12, this.time.getMinutes());
    }

    private void fireTimeChangedPerformed() {
        int size = this.listeners.size();
        int i = 0;
        while (i < size) {
            ActionListener element = this.listeners.get(i);
            element.actionPerformed(null);
            ++i;
        }
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listeners.remove(listener);
    }

    public void setCellEditor(TimestampTableCellEditor editor) {
        this.aCellEditor = editor;
    }

    public void setHourVisible(boolean b) {
        this.panelHour.setVisible(b);
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        TimestampEditorPanel t = new TimestampEditorPanel();
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(1, 2014);
        c.set(6, 8);
        c.set(11, 13);
        c.set(12, 14);
        t.setTime(c.getTime());
        t.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("TimestampEditorPanel got :" + TimestampEditorPanel.this.getTime());
            }
        });
        f.setContentPane(t);
        f.pack();
        f.setLocationRelativeTo(null);
        f.setVisible(true);
    }
}

