/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import org.openconcerto.ui.FormLayouter;
import org.openconcerto.ui.component.HTMLTextField;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.utils.SystemInfo;
import org.openconcerto.utils.i18n.TM;

public class SystemInfoPanel
extends JPanel {
    public SystemInfoPanel() {
        Map<SystemInfo.Info, String> infos = SystemInfo.get(true);
        FormLayouter l = new FormLayouter(this, 1);
        HTMLTextField p = new HTMLTextField(infos.get((Object)SystemInfo.Info.JAVA)){

            private final String getClassName(HyperlinkEvent e) {
                String uri = e.getDescription();
                if (uri.startsWith("class:")) {
                    return uri.substring("class".length() + 1);
                }
                return null;
            }

            @Override
            protected String getToolTip(HyperlinkEvent e) {
                String className = this.getClassName(e);
                if (className != null) {
                    return className;
                }
                return super.getToolTip(e);
            }

            @Override
            protected void linkActivated(HyperlinkEvent e, JComponent src) {
                String className = this.getClassName(e);
                if (className != null) {
                    String msg = className;
                    try {
                        Class<?> cl = Class.forName(className);
                        msg = String.valueOf(msg) + " (exists\nand its superclass is " + cl.getSuperclass() + ")";
                    }
                    catch (ClassNotFoundException e1) {
                        msg = String.valueOf(msg) + " (couldn't be loaded)";
                    }
                    ITextArea txtComp = new ITextArea(msg, 3, 50);
                    txtComp.setEditable(false);
                    txtComp.setBorder(BorderFactory.createEmptyBorder());
                    txtComp.setOpaque(false);
                    JOptionPane.showMessageDialog(src, txtComp, "Class name", 1);
                } else {
                    super.linkActivated(e, src);
                }
            }
        };
        l.add("Java", p);
        l.add(TM.tr("os", new Object[0]), new JLabel("<html>" + infos.get((Object)SystemInfo.Info.OS) + "</html>"));
        l.add(TM.tr("user", new Object[0]), new HTMLTextField(infos.get((Object)SystemInfo.Info.USER)));
        l.add(TM.tr("network", new Object[0]), new HTMLTextField(infos.get((Object)SystemInfo.Info.NETWORK)));
    }
}

