/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PrintPreviewFrame
extends JFrame
implements ActionListener,
ItemListener {
    private JButton print = new JButton("Imprimer");
    private Pageable pg = null;
    private double scale = 1.0;
    private Page[] page = null;
    private JComboBox jcb = new JComboBox();
    private CardLayout cl = new CardLayout();
    private JPanel p = new JPanel(this.cl);
    private JButton back = new JButton("<<");
    private JButton forward = new JButton(">>");

    public PrintPreviewFrame(Pageable pg) {
        this.init(pg);
    }

    public void init(Pageable pg) {
        this.setTitle("Aper\u00e7u avant impression");
        this.pg = pg;
        this.createPreview();
    }

    public PrintPreviewFrame(final Printable pr, final PageFormat p) {
        Pageable pageable = new Pageable(){

            @Override
            public int getNumberOfPages() {
                Graphics g = new BufferedImage(2, 2, 1).getGraphics();
                int n = 0;
                try {
                    while (pr.print(g, p, n) == 0) {
                        if (++n <= 100000) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception ex) {
                    throw new IllegalStateException(ex);
                }
                return n;
            }

            @Override
            public PageFormat getPageFormat(int x) {
                return p;
            }

            @Override
            public Printable getPrintable(int x) {
                return pr;
            }
        };
        this.init(pageable);
    }

    private void createPreview() {
        this.page = new Page[this.pg.getNumberOfPages()];
        PageFormat pf = this.pg.getPageFormat(0);
        Dimension size = new Dimension((int)pf.getPaper().getWidth(), (int)pf.getPaper().getHeight());
        if (pf.getOrientation() != 1) {
            size = new Dimension(size.height, size.width);
        }
        int i = 0;
        while (i < this.page.length) {
            this.jcb.addItem("" + (i + 1));
            this.page[i] = new Page(i, size);
            this.p.add("" + (i + 1), new JScrollPane(this.page[i]));
            ++i;
        }
        this.setTopPanel();
        this.getContentPane().add((Component)this.p, "Center");
        Dimension d = this.getToolkit().getScreenSize();
        this.setSize(d.width, d.height - 60);
        this.setVisible(true);
        this.page[this.jcb.getSelectedIndex()].refreshScale();
    }

    private void setTopPanel() {
        FlowLayout fl = new FlowLayout();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel topPanel = new JPanel(gbl);
        JPanel temp = new JPanel(fl);
        this.back.addActionListener(this);
        this.forward.addActionListener(this);
        this.back.setEnabled(false);
        this.forward.setEnabled(this.page.length > 1);
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        temp.add(this.back);
        temp.add(this.jcb);
        temp.add(this.forward);
        temp.add(this.print);
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        gbl.setConstraints(temp, gbc);
        topPanel.add(temp);
        this.print.addActionListener(this);
        this.jcb.addItemListener(this);
        this.print.setMnemonic('P');
        this.getContentPane().add((Component)topPanel, "North");
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        this.cl.show(this.p, (String)this.jcb.getSelectedItem());
        this.page[this.jcb.getSelectedIndex()].refreshScale();
        this.back.setEnabled(this.jcb.getSelectedIndex() != 0);
        this.forward.setEnabled(this.jcb.getSelectedIndex() != this.jcb.getItemCount() - 1);
        this.validate();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object o = ae.getSource();
        if (o == this.print) {
            this.printAllPages();
        } else if (o == this.back) {
            this.jcb.setSelectedIndex(this.jcb.getSelectedIndex() == 0 ? 0 : this.jcb.getSelectedIndex() - 1);
            if (this.jcb.getSelectedIndex() == 0) {
                this.back.setEnabled(false);
            }
        } else if (o == this.forward) {
            this.jcb.setSelectedIndex(this.jcb.getSelectedIndex() == this.jcb.getItemCount() - 1 ? 0 : this.jcb.getSelectedIndex() + 1);
            if (this.jcb.getSelectedIndex() == this.jcb.getItemCount() - 1) {
                this.forward.setEnabled(false);
            }
        }
    }

    public void printAllPages() {
        try {
            PrinterJob pj = PrinterJob.getPrinterJob();
            pj.defaultPage(this.pg.getPageFormat(0));
            pj.setPageable(this.pg);
            if (pj.printDialog()) {
                pj.print();
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex.toString(), "Error in Printing", 1);
        }
    }

    public void printCurrentPage(Printable p) {
        try {
            PrinterJob pj = PrinterJob.getPrinterJob();
            pj.defaultPage(this.pg.getPageFormat(0));
            pj.setPrintable(p);
            HashPrintRequestAttributeSet pra = new HashPrintRequestAttributeSet();
            if (pj.printDialog(pra)) {
                pj.print(pra);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex.toString(), "Error in Printing", 1);
        }
    }

    public Pageable getPageable() {
        return this.pg;
    }

    class Page
    extends JPanel {
        private final Dimension size;
        private final BufferedImage bi;
        private BufferedImage image;

        public Page(int x, Dimension size) {
            this.size = size;
            this.bi = new BufferedImage(size.width, size.height, 2);
            int n = x;
            PageFormat pf = PrintPreviewFrame.this.pg.getPageFormat(n);
            Graphics g = this.bi.getGraphics();
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            Color c = g.getColor();
            g.setColor(Color.white);
            g.fillRect(0, 0, (int)pf.getWidth(), (int)pf.getHeight());
            g.setColor(c);
            try {
                g.setColor(Color.BLACK);
                g.clipRect(0, 0, (int)pf.getWidth(), (int)pf.getHeight());
                Printable printable = PrintPreviewFrame.this.pg.getPrintable(n);
                printable.print(g, pf, n);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.image = this.bi;
            this.setPreferredSize(new Dimension(size.width, size.height));
        }

        public void refreshScale() {
            BufferedImage scaledInstance = this.bi;
            if (PrintPreviewFrame.this.scale != 1.0) {
                scaledInstance = (BufferedImage)this.bi.getScaledInstance((int)((double)this.size.width * PrintPreviewFrame.this.scale), (int)((double)this.size.height * PrintPreviewFrame.this.scale), 2);
            }
            this.image = scaledInstance;
            this.validate();
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            System.out.println(g.getClipBounds());
            g.drawImage(this.image, 0, 0, null);
        }
    }

    class PseudoPrintable
    implements Printable {
        PseudoPrintable() {
        }

        @Override
        public int print(Graphics g, PageFormat fmt, int index) {
            if (index > 0) {
                return 1;
            }
            int n = PrintPreviewFrame.this.jcb.getSelectedIndex();
            try {
                return PrintPreviewFrame.this.pg.getPrintable(n).print(g, fmt, n);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return 0;
            }
        }
    }
}

