/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.ParseException;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.JTime;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidState;

public final class JDateTime
extends JPanel
implements ValueWrapper<Date> {
    private final JDate date;
    private final JTime time;
    private Date value;
    private final PropertyChangeSupport supp;

    public JDateTime() {
        this(false, false);
    }

    public JDateTime(boolean fillWithCurrentDate) {
        this(fillWithCurrentDate, fillWithCurrentDate);
    }

    public JDateTime(boolean fillWithCurrentDate, boolean fillWithCurrentHour) {
        this.setOpaque(false);
        this.date = new JDate(fillWithCurrentDate);
        this.time = new JTime(fillWithCurrentHour);
        this.supp = new PropertyChangeSupport(this);
        PropertyChangeListener l = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JDateTime.this.updateValue();
            }
        };
        this.date.addValueListener(l);
        this.time.addValueListener(l);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.weighty = 0.0;
        this.add((Component)this.date, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.time, c);
        this.resetValue();
    }

    protected void updateValue() {
        this.value = this.date.getValue() == null ? null : (this.time.getValue() == null ? new Date(this.date.getValue().getTime()) : new Date(this.date.getValue().getTime() + this.time.getTimeInMillis()));
        this.supp.firePropertyChange("value", null, this.value);
    }

    @Override
    public final void resetValue() {
        this.date.resetValue();
        this.time.resetValue();
    }

    @Override
    public final void setValue(Date val) {
        this.time.setValue(val);
        this.date.setValue(val == null ? null : new Date(val.getTime() - this.time.getTimeInMillis()));
    }

    @Override
    public final Date getValue() {
        return this.value;
    }

    @Override
    public final void addValueListener(PropertyChangeListener l) {
        this.supp.addPropertyChangeListener("value", l);
    }

    @Override
    public void rmValueListener(PropertyChangeListener l) {
        this.supp.removePropertyChangeListener("value", l);
    }

    public void commitEdit() throws ParseException {
        this.date.commitEdit();
        this.time.commitEdit();
    }

    @Override
    public JComponent getComp() {
        return this;
    }

    @Override
    public ValidState getValidState() {
        return ValidState.getTrueInstance();
    }

    @Override
    public void addValidListener(ValidListener l) {
    }

    @Override
    public void removeValidListener(ValidListener l) {
    }
}

