/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.io.File;
import java.io.IOException;
import org.openconcerto.ui.TM;
import org.openconcerto.ui.preferences.EmailProps;
import org.openconcerto.utils.EmailClient;
import org.openconcerto.utils.ExceptionHandler;

public class EmailComposer {
    private static EmailComposer instance = new EmailComposer();

    public static synchronized EmailComposer getInstance() {
        return instance;
    }

    public void compose(String to, String subject, String text, File ... attachedFile) throws IOException, InterruptedException {
        if (to == null) {
            to = "";
        }
        if (subject == null) {
            subject = "";
        }
        if (text == null) {
            text = "";
        }
        to = to.trim();
        subject = subject.trim();
        text = text.trim();
        EmailClient emailClient = null;
        int mode = EmailProps.getInstance().getMode();
        if (mode == 1) {
            String app = EmailProps.getInstance().getThunderbirdPath();
            emailClient = EmailClient.Thunderbird.createFromExe(new File(app));
        } else if (mode == 2) {
            emailClient = EmailClient.Outlook;
        }
        if (emailClient == null) {
            emailClient = EmailClient.getPreferred();
        }
        try {
            emailClient.compose(to, subject, text, attachedFile);
        }
        catch (Exception e) {
            if (emailClient == EmailClient.MailTo) {
                throw new IOException(e);
            }
            ExceptionHandler.handle(TM.tr("email.fallback", new Object[0]), e);
            EmailClient.MailTo.compose(to, subject, text, attachedFile);
        }
    }
}

