/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.SQLElementEditAction;
import org.openconcerto.sql.view.SQLElementListAction;
import org.openconcerto.utils.cc.IClosure;

public class SQLMenuItemHelper {
    protected void postProcessFrame(JFrame f) {
    }

    protected void menuItemCreated(SQLElement elem) {
    }

    protected void actionCreated(AbstractSQLMenuItemAction action) {
    }

    private final <F extends JFrame> F ppFrame(F f, IClosure<F> c) {
        if (c != null) {
            c.executeChecked(f);
        }
        this.postProcessFrame(f);
        return f;
    }

    protected EditFrame createEditFrame(SQLElement elem) {
        return null;
    }

    protected IListFrame createListFrame(SQLElement elem) {
        return null;
    }

    public final JMenuItem createEditMenuItem(SQLElement elem) {
        this.menuItemCreated(elem);
        return new JMenuItem(this.createEditAction(elem));
    }

    public final SQLElementEditAction createEditAction(SQLElement elem) {
        SQLElementEditAction menuItemAction = new SQLElementEditAction(elem){

            @Override
            protected EditFrame instantiateFrame() {
                EditFrame res = SQLMenuItemHelper.this.createEditFrame(this.getElem());
                if (res == null) {
                    return super.instantiateFrame();
                }
                return res;
            }

            @Override
            protected void initFrame(EditFrame f) {
                super.initFrame(f);
                SQLMenuItemHelper.this.ppFrame(f, null);
            }
        };
        this.actionCreated(menuItemAction);
        return menuItemAction;
    }

    public final JMenuItem createListMenuItem(SQLElement elem) {
        return this.createListMenuItem(elem, null);
    }

    public final JMenuItem createListMenuItem(SQLElement elem, IClosure<IListFrame> initFrame) {
        this.menuItemCreated(elem);
        return new JMenuItem(this.createListAction(elem, initFrame));
    }

    public final SQLElementListAction createListAction(SQLElement elem) {
        return this.createListAction(elem, null);
    }

    public final SQLElementListAction createListAction(SQLElement elem, final IClosure<IListFrame> initFrame) {
        SQLElementListAction menuItemAction = new SQLElementListAction(elem){

            @Override
            protected IListFrame instantiateFrame() {
                IListFrame res = SQLMenuItemHelper.this.createListFrame(this.getElem());
                if (res == null) {
                    return super.instantiateFrame();
                }
                return res;
            }

            @Override
            protected void initFrame(IListFrame f) {
                super.initFrame(f);
                SQLMenuItemHelper.this.ppFrame(f, initFrame);
            }
        };
        this.actionCreated(menuItemAction);
        return menuItemAction;
    }

    public final void addMenuItems(JMenu menu, SQLElement elem) {
        this.addMenuItems(menu, elem, true, true);
    }

    public final void addMenuItems(JMenu menu, SQLElement elem, boolean edit, boolean list) {
        this.addMenuItems(menu, elem, edit, list, null);
    }

    public final void addMenuItems(JMenu menu, SQLElement elem, boolean edit, boolean list, IClosure<IListFrame> listInit) {
        if (elem != null) {
            if (edit) {
                menu.add(this.createEditMenuItem(elem));
            }
            if (list) {
                menu.add(this.createListMenuItem(elem, listInit));
            }
        }
    }

    public static abstract class AbstractSQLMenuItemAction
    extends AbstractAction {
        private final SQLElement elem;
        private JFrame frame;
        private boolean cacheFrame;

        public AbstractSQLMenuItemAction(SQLElement elem, String name) {
            super(name);
            this.elem = elem;
            this.frame = null;
            this.cacheFrame = true;
            this.putValue("ActionCommandKey", String.valueOf(this.getClass().getName()) + " with " + this.getElem().getCode());
        }

        public final void setCacheFrame(boolean cacheFrame) {
            if (this.cacheFrame != cacheFrame) {
                this.cacheFrame = cacheFrame;
                this.frame = null;
            }
        }

        public final JFrame getFrame() {
            if (this.cacheFrame) {
                if (this.frame == null) {
                    this.frame = this.createFrame();
                }
                return this.frame;
            }
            return this.createFrame();
        }

        protected abstract JFrame createFrame();

        public final SQLElement getElem() {
            return this.elem;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.getFrame().setVisible(true);
        }
    }

    static abstract class GenericSQLElementAction<F extends JFrame>
    extends AbstractSQLMenuItemAction {
        public GenericSQLElementAction(SQLElement elem, String name) {
            super(elem, name);
        }

        protected abstract F instantiateFrame();

        protected void initFrame(F f) {
        }

        protected final F createFrame() {
            F res = this.instantiateFrame();
            this.initFrame(res);
            return res;
        }
    }
}

