/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.users.rights;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openconcerto.sql.element.GlobalMapper;
import org.openconcerto.sql.element.GroupSQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.sql.users.rights.RightEditor;
import org.openconcerto.sql.users.rights.RightEditorManager;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.group.Group;
import org.openconcerto.utils.CollectionUtils;

public class UserRightSQLComponent
extends GroupSQLComponent {
    public static String ID = "user.right";
    private JTextField objectField = new JTextField();
    private JPanel customEditorPanel = new JPanel(new GridBagLayout());
    private final ElementComboBox right = new ElementComboBox();
    private final GridBagConstraints cCustomPanel;
    private RightEditor currentRightEditor;
    private JComponent currentRightEditorComponent;

    public UserRightSQLComponent(SQLElement element) {
        super(element, (Group)GlobalMapper.getInstance().get(ID));
        this.customEditorPanel.setBorder(null);
        this.customEditorPanel.setOpaque(false);
        this.cCustomPanel = new DefaultGridBagConstraints();
        this.cCustomPanel.weightx = 1.0;
        this.currentRightEditor = RightEditorManager.getInstance().getDefaultRightEditor();
        this.objectField.setVisible(false);
    }

    @Override
    public JComponent createEditor(String id) {
        if (id.equals("ID_USER_COMMON")) {
            SQLRequestComboBox user = new SQLRequestComboBox();
            return user;
        }
        if (id.equals("OBJECT")) {
            return this.objectField;
        }
        if (id.equals("ID_RIGHT")) {
            this.right.setListIconVisible(false);
            return this.right;
        }
        if (id.equals("user.right.parameters.editor")) {
            this.currentRightEditor = RightEditorManager.getInstance().getDefaultRightEditor();
            this.currentRightEditorComponent = this.currentRightEditor.getComponentEditor("", this.objectField);
            this.customEditorPanel.add((Component)this.currentRightEditorComponent, this.cCustomPanel);
            return this.customEditorPanel;
        }
        return super.createEditor(id);
    }

    @Override
    public void select(SQLRowAccessor r) {
        super.select(r);
        if (this.currentRightEditorComponent != null && r != null) {
            this.currentRightEditor.setValueEditor(r.getString("OBJECT"), this.currentRightEditorComponent);
        }
    }

    @Override
    public JComponent getLabel(String id) {
        JComponent comp = super.getLabel(id);
        if (id.equals("OBJECT")) {
            comp.setVisible(false);
        }
        return comp;
    }

    @Override
    protected Set<String> createRequiredNames() {
        return CollectionUtils.createSet("ID_RIGHT", "HAVE_RIGHT");
    }

    @Override
    protected void addViews() {
        super.addViews();
        SQLRequestComboBox user = (SQLRequestComboBox)this.getEditor("ID_USER_COMMON");
        user.getRequest().setUndefLabel("Par d\u00e9faut");
        this.right.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                UserRightSQLComponent.this.customEditorPanel.removeAll();
                UserRightSQLComponent.this.objectField.setText("");
                String code = UserRightSQLComponent.this.right.getSelectedRow() == null ? "" : UserRightSQLComponent.this.right.getSelectedRow().getString("CODE");
                UserRightSQLComponent.this.currentRightEditor = RightEditorManager.getInstance().getRightEditor(code);
                UserRightSQLComponent.this.currentRightEditorComponent = UserRightSQLComponent.this.currentRightEditor.getComponentEditor(code, UserRightSQLComponent.this.objectField);
                UserRightSQLComponent.this.customEditorPanel.add((Component)UserRightSQLComponent.this.currentRightEditorComponent, UserRightSQLComponent.this.cCustomPanel);
                UserRightSQLComponent.this.customEditorPanel.revalidate();
                UserRightSQLComponent.this.customEditorPanel.repaint();
            }
        });
    }
}

