/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.users.rights;

import java.util.ArrayList;
import java.util.List;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.users.rights.MacroRight;
import org.openconcerto.sql.users.rights.UserRights;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.utils.CompareUtils;

public class TableAllRights
extends MacroRight {
    public static final String CODE = "TABLE_ALL_RIGHTS";
    public static final String CODE_MODIF = "TABLE_ALL_MODIF_RIGHTS";
    public static final String DELETE_ROW_TABLE = "DELETE_ROW";
    public static final String MODIFY_ROW_TABLE = "UPDATE_ROW";
    public static final String ADD_ROW_TABLE = "INSERT_ROW";
    public static final String VIEW_ROW_TABLE = "SELECT_ROW";
    public static final String SAVE_ROW_TABLE = "SAVE_ROW";

    public static UserRightsManager.RightTuple createRight(SQLTable t, boolean b) {
        return TableAllRights.createRight(CODE, t, b);
    }

    public static UserRightsManager.RightTuple createRight(String code, SQLTable t, boolean b) {
        return new UserRightsManager.RightTuple(code, TableAllRights.tableToString(t), b);
    }

    public static boolean currentUserHasRight(String code, SQLTable t) {
        return TableAllRights.hasRight(UserRightsManager.getCurrentUserRights(), code, t);
    }

    public static boolean hasRight(UserRights u, String code, SQLTable t) {
        return TableAllRights.hasRightOnTableName(u, code, TableAllRights.tableName(t, true));
    }

    static boolean hasRightOnTableName(UserRights u, String code, final SQLName tName) {
        int correctNameCount;
        int n = correctNameCount = tName == null ? -1 : tName.getItemCount();
        assert (tName == null || correctNameCount == 2) : "root.table";
        return u.haveRight(code, tName == null ? null : tName.quote(), (CompareUtils.Equalizer<? super String>)new CompareUtils.Equalizer<String>(){
            private SQLName[] names;

            public SQLName getName(int length) {
                if (this.names == null) {
                    this.names = new SQLName[correctNameCount];
                    SQLName current = tName;
                    int i = this.names.length - 1;
                    while (i >= 0) {
                        this.names[i] = current;
                        if (!$assertionsDisabled && current.getItemCount() - 1 != i) {
                            throw new AssertionError();
                        }
                        current = current.getRest();
                        --i;
                    }
                }
                return this.names[length - 1];
            }

            @Override
            public boolean equals(String o1, String o2) {
                if (o1.equals(o2)) {
                    return true;
                }
                SQLName rightTableName = SQLName.parse(o1);
                int rightNameCount = rightTableName.getItemCount();
                if (rightNameCount > correctNameCount) {
                    throw new IllegalArgumentException("names should not contain system root : " + rightTableName);
                }
                return rightTableName.equals(this.getName(rightNameCount));
            }
        });
    }

    private static SQLName tableName(SQLTable t, boolean exact) {
        if (t == null) {
            return null;
        }
        return exact ? t.getSQLName(t.getDBRoot()) : new SQLName(t.getName());
    }

    public static String tableToString(SQLTable t) {
        return TableAllRights.tableToString(t, true);
    }

    public static String tableToString(SQLTable t, boolean exact) {
        return t == null ? null : TableAllRights.tableName(t, exact).quote();
    }

    public TableAllRights() {
        this(true);
    }

    public TableAllRights(boolean includeView) {
        super(includeView ? CODE : CODE_MODIF);
    }

    public void load(UserRights userRights, Boolean b) {
        throw new IllegalStateException();
    }

    @Override
    public List<UserRightsManager.RightTuple> expand(UserRightsManager mngr, String rightCode, String object, boolean haveRight) {
        ArrayList<UserRightsManager.RightTuple> res = new ArrayList<UserRightsManager.RightTuple>();
        res.add(new UserRightsManager.RightTuple(DELETE_ROW_TABLE, object, haveRight));
        res.add(new UserRightsManager.RightTuple(MODIFY_ROW_TABLE, object, haveRight));
        res.add(new UserRightsManager.RightTuple(ADD_ROW_TABLE, object, haveRight));
        if (this.getCode() == CODE) {
            res.add(new UserRightsManager.RightTuple(VIEW_ROW_TABLE, object, haveRight));
        }
        return res;
    }
}

