/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.users.rights;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.users.rights.RightEditor;
import org.openconcerto.sql.users.rights.RightEditorManager;
import org.openconcerto.ui.component.combo.ISearchableCombo;
import org.openconcerto.utils.model.DefaultIMutableListModel;

public class SQLTableRightEditor
implements RightEditor {
    @Override
    public void setValueEditor(String object, JComponent editorComponent) {
        ((ISearchableCombo)editorComponent).setValue(new SQLTableComboItem(Configuration.getInstance().getDirectory().getElement(object)));
    }

    @Override
    public JComponent getComponentEditor(String right, final JTextField fieldObject) {
        final ISearchableCombo comboMenu = new ISearchableCombo();
        DefaultIMutableListModel comboItems = new DefaultIMutableListModel();
        Set<SQLTable> set = Configuration.getInstance().getRoot().getTables();
        ArrayList<SQLTableComboItem> result = new ArrayList<SQLTableComboItem>(set.size());
        SQLElementDirectory directory = Configuration.getInstance().getDirectory();
        for (SQLTable table : set) {
            SQLElement elt = directory.getElement(table);
            if (elt == null) continue;
            result.add(new SQLTableComboItem(elt));
        }
        comboItems.addAll(result);
        comboMenu.initCache(comboItems);
        comboMenu.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SQLTableComboItem selectedItem = (SQLTableComboItem)comboMenu.getSelectedItem();
                if (selectedItem != null) {
                    fieldObject.setText(selectedItem.getTable().getName());
                }
            }
        });
        return comboMenu;
    }

    public static void register() {
        SQLTableRightEditor editor = new SQLTableRightEditor();
        RightEditorManager.getInstance().register("UPDATE_ROW", editor);
        RightEditorManager.getInstance().register("DELETE_ROW", editor);
        RightEditorManager.getInstance().register("INSERT_ROW", editor);
    }

    public class SQLTableComboItem {
        private final SQLElement elt;

        public SQLTableComboItem(SQLElement elt) {
            this.elt = elt;
        }

        public SQLTable getTable() {
            return this.elt.getTable();
        }

        public String toString() {
            return this.elt.getName().getBase();
        }
    }
}

