/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.users.rights;

import java.util.HashMap;
import java.util.Map;
import org.openconcerto.sql.users.rights.DefaultRightEditor;
import org.openconcerto.sql.users.rights.RightEditor;

public class RightEditorManager {
    private static final RightEditorManager INSTANCE = new RightEditorManager();
    private final Map<String, RightEditor> editors = new HashMap<String, RightEditor>();
    private final RightEditor defaultEditor = new DefaultRightEditor();

    private RightEditorManager() {
    }

    public static RightEditorManager getInstance() {
        return INSTANCE;
    }

    public RightEditor getRightEditor(String right) {
        RightEditor e = this.editors.get(right);
        if (e == null) {
            return this.defaultEditor;
        }
        return e;
    }

    public void register(String right, RightEditor editor) {
        this.editors.put(right, editor);
    }

    public RightEditor getDefaultRightEditor() {
        return this.defaultEditor;
    }
}

