/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.ui.textmenu;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.text.JTextComponent;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.request.SQLRowItemView;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.itemview.RowItemViewComponent;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.component.text.TextComponent;
import org.openconcerto.ui.valuewrapper.ValueChangeSupport;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidState;
import org.openconcerto.utils.doc.Documented;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class TextFieldWithWebBrowsing
extends JPanel
implements RowItemViewComponent,
TextComponent,
ValueWrapper<String>,
Documented {
    private JTextField textField;
    private SQLField field;
    private final ValueChangeSupport<String> supp = new ValueChangeSupport<String>(this);
    protected boolean gained;
    protected boolean mousePressed;
    protected String initialText;

    public TextFieldWithWebBrowsing() {
        this.textField = new JTextField(30);
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.insets = new Insets(0, 0, 0, 0);
        c.weightx = 1.0;
        c.weighty = 0.0;
        if (System.getProperties().getProperty("os.name").toLowerCase().contains("linux")) {
            this.textField.setOpaque(false);
        }
        this.setOpaque(false);
        this.add((Component)this.textField, c);
        c.insets = new Insets(0, 4, 0, 4);
        ++c.gridx;
        c.weightx = 0.0;
        ImageIcon icon = new ImageIcon(ElementComboBox.class.getResource("loupe.png"));
        JButton b = new JButton();
        b.setIcon(icon);
        b.setBorder(BorderFactory.createEmptyBorder());
        b.setOpaque(false);
        b.setContentAreaFilled(false);
        b.setFocusPainted(false);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop desktop;
                Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
                if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
                    try {
                        List<String> l = StringUtils.fastSplit(TextFieldWithWebBrowsing.this.textField.getText(), ' ');
                        for (String string : l) {
                            if (string.trim().length() <= 0) continue;
                            desktop.browse(URI.create(string));
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "Le support du navigateur internet n'est pas pris en charge sur votre syst\u00e8me!");
                }
            }
        });
        b.setOpaque(false);
        this.add((Component)b, c);
        this.textField.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                TextFieldWithWebBrowsing.this.supp.fireValidChange();
            }
        });
        this.setPreferredSize(new Dimension(this.getPreferredSize()));
    }

    @Override
    public void init(SQLRowItemView v) {
        this.field = v.getField();
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                TextFieldWithWebBrowsing.this.gained = true;
                TextFieldWithWebBrowsing.this.initialText = TextFieldWithWebBrowsing.this.textField.getText();
                if (!TextFieldWithWebBrowsing.this.mousePressed) {
                    TextFieldWithWebBrowsing.this.textField.selectAll();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TextFieldWithWebBrowsing.this.mousePressed = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (TextFieldWithWebBrowsing.this.gained && TextFieldWithWebBrowsing.this.textField.getSelectedText() == null) {
                    TextFieldWithWebBrowsing.this.textField.selectAll();
                }
                TextFieldWithWebBrowsing.this.gained = false;
                TextFieldWithWebBrowsing.this.mousePressed = false;
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\u001b') {
                    TextFieldWithWebBrowsing.this.setValue(TextFieldWithWebBrowsing.this.initialText);
                    TextFieldWithWebBrowsing.this.textField.selectAll();
                }
            }
        });
    }

    public SQLField getField() {
        return this.field;
    }

    @Override
    public void setValue(String val) {
        if (!this.textField.getText().equals(val)) {
            this.textField.setText(val);
        }
    }

    @Override
    public void resetValue() {
        this.setValue("");
    }

    public SQLTable getTable() {
        if (this.field == null) {
            return null;
        }
        return this.field.getTable();
    }

    @Override
    public String toString() {
        return "TextFieldWithMenu on " + this.field;
    }

    public void setEditable(boolean b) {
        this.textField.setEditable(b);
    }

    @Override
    public String getValue() throws IllegalStateException {
        return this.textField.getText();
    }

    @Override
    public void addValueListener(PropertyChangeListener l) {
        this.supp.addValueListener(l);
    }

    @Override
    public ValidState getValidState() {
        return ValidState.getTrueInstance();
    }

    public void setText(String s) {
        this.textField.setText(s);
    }

    public String getText() {
        return this.textField.getText();
    }

    public JTextField getTextField() {
        return this.textField;
    }

    @Override
    public String getDocId() {
        return "TFWM_" + this.field.getFullName();
    }

    @Override
    public String getGenericDoc() {
        return "";
    }

    @Override
    public boolean onScreen() {
        return true;
    }

    @Override
    public boolean isDocTransversable() {
        return false;
    }

    @Override
    public JTextComponent getTextComp() {
        return this.textField;
    }

    @Override
    public JComponent getComp() {
        return this;
    }

    @Override
    public void addValidListener(ValidListener l) {
        this.supp.addValidListener(l);
    }

    @Override
    public void removeValidListener(ValidListener l) {
        this.supp.removeValidListener(l);
    }

    @Override
    public void rmValueListener(PropertyChangeListener l) {
        this.supp.rmValueListener(l);
    }
}

