/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.ui.light;

import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.PropsConfiguration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.sqlobject.ElementComboBoxUtils;
import org.openconcerto.sql.ui.StringWithId;
import org.openconcerto.ui.light.LightUIDescriptor;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.ui.light.LightUILine;

public class LightUIDescriptorFiller {
    private final LightUIDescriptor desc;

    public LightUIDescriptorFiller(LightUIDescriptor desc) {
        this.desc = desc;
    }

    public void fillWithDefaultValues() {
        int lineCount = this.desc.getSize();
        int i = 0;
        while (i < lineCount) {
            LightUILine l = this.desc.getLine(i);
            int elementCount = l.getSize();
            int j = 0;
            while (j < elementCount) {
                LightUIElement element = l.getElement(j);
                if (element.getType() == 2) {
                    element.setValue(String.valueOf(System.currentTimeMillis()));
                }
                ++j;
            }
            ++i;
        }
    }

    public void fillFromId(PropsConfiguration configuration, SQLTable table, long id) {
        System.err.println("LightUIDescriptorFiller.fillFromId() " + id);
        SQLRow row = table.getRow((int)id);
        int lineCount = this.desc.getSize();
        int i = 0;
        while (i < lineCount) {
            LightUILine l = this.desc.getLine(i);
            int elementCount = l.getSize();
            int j = 0;
            while (j < elementCount) {
                Calendar date;
                LightUIElement element = l.getElement(j);
                SQLField field = configuration.getFieldMapper().getSQLFieldForItem(element.getId());
                int type = element.getType();
                if (type == 1) {
                    if (field == null) {
                        Log.get().severe("No field found for text field : " + element.getId());
                    } else {
                        element.setValue(row.getString(field.getName()));
                    }
                } else if (type == 7) {
                    Where where;
                    Collection fieldsToFetch;
                    SQLTable foreignTable = field.getForeignTable();
                    List<SQLRowValues> fetchedRows = ElementComboBoxUtils.fetchRows(configuration, foreignTable, (List<SQLField>)(fieldsToFetch = configuration.getDirectory().getElement(foreignTable).getComboRequest().getFields()), where = new Where((FieldRef)foreignTable.getKey(), "=", (Object)row.getLong(field.getName())));
                    if (fetchedRows.size() > 1) {
                        throw new IllegalStateException("multiple rows fetched for id " + id + " on table " + table.getName());
                    }
                    for (SQLRowValues vals : fetchedRows) {
                        StringWithId s = ElementComboBoxUtils.createItem(configuration, foreignTable, vals, (List<SQLField>)fieldsToFetch);
                        element.setValue(s.toCondensedString());
                    }
                } else if (type == 5) {
                    if (row.getBoolean(field.getName()).booleanValue()) {
                        element.setValue("true");
                    } else {
                        element.setValue("false");
                    }
                } else if (type == 2 && (date = row.getDate(field.getName())) != null) {
                    element.setValue(String.valueOf(row.getDate(field.getName()).getTimeInMillis()));
                }
                ++j;
            }
            ++i;
        }
    }
}

