/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.ui;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class StringWithId
implements Externalizable {
    private long id;
    private String value;

    public StringWithId() {
    }

    public StringWithId(long id, String value) {
        this.id = id;
        this.value = value.trim();
    }

    public StringWithId(String condensedValue) {
        int index = condensedValue.indexOf(44);
        if (index <= 0) {
            throw new IllegalArgumentException("invalid condensed value " + condensedValue);
        }
        this.id = Long.parseLong(condensedValue.substring(0, index));
        this.value = condensedValue.substring(index + 1).trim();
    }

    public long getId() {
        return this.id;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.id);
        out.writeUTF(this.value);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readLong();
        this.value = in.readUTF().trim();
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object obj) {
        StringWithId o = (StringWithId)obj;
        return o.getId() == this.getId() && o.getValue().endsWith(this.getValue());
    }

    public int hashCode() {
        return (int)this.id + this.value.hashCode();
    }

    public String toCondensedString() {
        return String.valueOf(this.id) + "," + this.value;
    }
}

