/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.request;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.openconcerto.sql.FieldExpander;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSearchMode;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.request.BaseSQLRequest;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.ITransformer;

public abstract class BaseFillSQLRequest
extends BaseSQLRequest
implements Cloneable {
    private static final Pattern QUERY_SPLIT_PATTERN = Pattern.compile("\\s+");
    private static boolean DEFAULT_SELECT_LOCK = true;
    private final SQLTable primaryTable;
    private Where where;
    private Map<SQLField, SQLSearchMode> searchFields;
    private List<String> searchQuery;
    private ITransformer<SQLSelect, SQLSelect> selTransf;
    private boolean lockSelect;
    private SQLRowValues graph;
    private SQLRowValues graphToFetch;
    private SQLRowValuesListFetcher frozen = null;
    private final PropertyChangeSupport supp = new PropertyChangeSupport(this);

    public static final boolean getDefaultLockSelect() {
        return DEFAULT_SELECT_LOCK;
    }

    public static final void setDefaultLockSelect(boolean b) {
        DEFAULT_SELECT_LOCK = b;
    }

    public static void setupForeign(SQLRowValuesListFetcher fetcher) {
        fetcher.setFullOnly(false);
        fetcher.setIncludeForeignUndef(false);
        fetcher.setReferentsOrdered(true, true);
    }

    public static final void addToFetch(SQLRowValues input, Path p, Collection<String> fields) {
        SQLRowValues r = p == null ? input : input.followPathToOne(p, SQLRowValues.CreateMode.CREATE_ONE, false);
        for (String f : fields) {
            if (r.getFields().contains(f)) continue;
            r.put(f, null);
        }
    }

    public BaseFillSQLRequest(SQLTable primaryTable, Where w) {
        if (primaryTable == null) {
            throw new NullPointerException();
        }
        this.primaryTable = primaryTable;
        this.where = w;
        this.searchFields = Collections.emptyMap();
        this.searchQuery = Collections.emptyList();
        this.selTransf = null;
        this.lockSelect = BaseFillSQLRequest.getDefaultLockSelect();
        this.graph = null;
        this.graphToFetch = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseFillSQLRequest(BaseFillSQLRequest req) {
        this.primaryTable = req.getPrimaryTable();
        BaseFillSQLRequest baseFillSQLRequest = req;
        synchronized (baseFillSQLRequest) {
            this.where = req.where;
            this.searchFields = req.searchFields;
            this.searchQuery = req.searchQuery;
            this.selTransf = req.selTransf;
            this.lockSelect = req.lockSelect;
            this.graph = req.getGraph();
            this.graphToFetch = req.getGraphToFetch();
        }
    }

    public final synchronized boolean isFrozen() {
        return this.frozen != null;
    }

    public final void freeze() {
        this.freeze(this);
    }

    private final synchronized void freeze(BaseFillSQLRequest from) {
        if (!this.isFrozen()) {
            this.frozen = from.getFetcher();
            assert (this.frozen.isFrozen());
            this.wasFrozen();
        }
    }

    protected void wasFrozen() {
    }

    protected final void checkFrozen() {
        if (this.isFrozen()) {
            throw new IllegalStateException("this has been frozen: " + this);
        }
    }

    public BaseFillSQLRequest toUnmodifiable() {
        return this.toUnmodifiableP(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final <T extends BaseFillSQLRequest> T toUnmodifiableP(Class<T> clazz) {
        BaseFillSQLRequest res;
        Class<?> thisClass = this.getClass();
        if (!(clazz == thisClass || thisClass.isAnonymousClass() && clazz == thisClass.getSuperclass())) {
            throw new IllegalArgumentException("Passed class isn't our class : " + clazz + " != " + thisClass);
        }
        BaseFillSQLRequest baseFillSQLRequest = this;
        synchronized (baseFillSQLRequest) {
            if (this.isFrozen()) {
                res = this;
            } else {
                res = this.clone(true);
                if (res.getClass() != clazz) {
                    throw new IllegalStateException("Clone class mismatch : " + res.getClass() + " != " + clazz);
                }
                res.freeze(this);
            }
        }
        assert (res.getClass() == clazz || res.getClass().getSuperclass() == clazz);
        BaseFillSQLRequest casted = res;
        return (T)casted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseFillSQLRequest clone() {
        BaseFillSQLRequest baseFillSQLRequest = this;
        synchronized (baseFillSQLRequest) {
            return this.clone(false);
        }
    }

    protected abstract BaseFillSQLRequest clone(boolean var1);

    private final SQLRowValues computeGraph() {
        if (this.getFields() == null) {
            return null;
        }
        SQLRowValues vals = new SQLRowValues(this.getPrimaryTable());
        for (SQLField f : this.getFields()) {
            vals.put(f.getName(), null);
        }
        this.getShowAs().expand(vals);
        return vals.toImmutable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SQLRowValues getGraph() {
        BaseFillSQLRequest baseFillSQLRequest = this;
        synchronized (baseFillSQLRequest) {
            if (this.graph == null) {
                assert (!this.isFrozen()) : "no computation should take place after frozen()";
                this.graph = this.computeGraph();
            }
            return this.graph;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void clearGraph() {
        BaseFillSQLRequest baseFillSQLRequest = this;
        synchronized (baseFillSQLRequest) {
            this.checkFrozen();
            this.graph = null;
            this.graphToFetch = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SQLRowValues getGraphToFetch() {
        BaseFillSQLRequest baseFillSQLRequest = this;
        synchronized (baseFillSQLRequest) {
            if (this.graphToFetch == null && this.getGraph() != null) {
                assert (!this.isFrozen()) : "no computation should take place after frozen()";
                SQLRowValues tmp = this.getGraph().deepCopy();
                this.customizeToFetch(tmp);
                for (Path orderP : this.getOrder()) {
                    SQLRowValues orderVals = tmp.followPath(orderP);
                    if (orderVals == null || !orderVals.getTable().isOrdered()) continue;
                    orderVals.put(orderVals.getTable().getOrderField().getName(), null);
                }
                this.graphToFetch = tmp.toImmutable();
            }
            return this.graphToFetch;
        }
    }

    public final void addToGraphToFetch(Collection<String> fields) {
        this.addToGraphToFetch(null, fields);
    }

    public final void addToGraphToFetch(final Path p, final Collection<String> fields) {
        this.changeGraphToFetch(new IClosure<SQLRowValues>(){

            @Override
            public void executeChecked(SQLRowValues input) {
                BaseFillSQLRequest.addToFetch(input, p, fields);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void changeGraphToFetch(IClosure<SQLRowValues> cl) {
        BaseFillSQLRequest baseFillSQLRequest = this;
        synchronized (baseFillSQLRequest) {
            this.checkFrozen();
            SQLRowValues tmp = this.getGraphToFetch().deepCopy();
            cl.executeChecked(tmp);
            this.graphToFetch = tmp.toImmutable();
        }
    }

    protected void customizeToFetch(SQLRowValues graphToFetch) {
    }

    protected final synchronized SQLRowValuesListFetcher getFetcher() {
        if (this.isFrozen()) {
            return this.frozen;
        }
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(this.getGraphToFetch(), false);
        return this.setupFetcher(fetcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final SQLRowValuesListFetcher setupFetcher(SQLRowValuesListFetcher fetcher) {
        final String tableName = this.getPrimaryTable().getName();
        BaseFillSQLRequest.setupForeign(fetcher);
        BaseFillSQLRequest baseFillSQLRequest = this;
        synchronized (baseFillSQLRequest) {
            fetcher.setOrder(this.getOrder());
            fetcher.setReturnedRowsUnmodifiable(true);
            final ITransformer<SQLSelect, SQLSelect> origSelTransf = fetcher.getSelTransf();
            fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

                @Override
                public SQLSelect transformChecked(SQLSelect sel) {
                    if (origSelTransf != null) {
                        sel = (SQLSelect)origSelTransf.transformChecked(sel);
                    }
                    sel = BaseFillSQLRequest.this.transformSelect(sel);
                    if (BaseFillSQLRequest.this.isLockSelect()) {
                        sel.addWaitPreviousWriteTXTable(tableName);
                    }
                    return sel.andWhere(BaseFillSQLRequest.this.getWhere());
                }
            });
            fetcher.freeze();
        }
        return fetcher;
    }

    protected List<Path> getOrder() {
        return Collections.singletonList(Path.get(this.getPrimaryTable()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setWhere(Where w) {
        BaseFillSQLRequest baseFillSQLRequest = this;
        synchronized (baseFillSQLRequest) {
            this.checkFrozen();
            this.where = w;
        }
        this.fireWhereChange();
    }

    public final synchronized Where getWhere() {
        return this.where;
    }

    public final void setSearchable(boolean b) {
        this.setSearchFields(b ? this.getFields() : Collections.emptyList());
    }

    public final void setSearchFields(Collection<SQLField> searchFields) {
        this.setSearchFields(CollectionUtils.createMap(searchFields));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSearchFields(Map<SQLField, SQLSearchMode> searchFields) {
        this.checkFrozen();
        searchFields = new HashMap<SQLField, SQLSearchMode>(searchFields);
        Iterator<Map.Entry<SQLField, SQLSearchMode>> iter = searchFields.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<SQLField, SQLSearchMode> e = iter.next();
            if (!String.class.isAssignableFrom(e.getKey().getType().getJavaType())) {
                iter.remove();
                continue;
            }
            if (e.getValue() != null) continue;
            e.setValue(SQLSearchMode.CONTAINS);
        }
        searchFields = Collections.unmodifiableMap(searchFields);
        BaseFillSQLRequest baseFillSQLRequest = this;
        synchronized (baseFillSQLRequest) {
            this.searchFields = searchFields;
        }
        this.fireWhereChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<SQLField, SQLSearchMode> getSearchFields() {
        BaseFillSQLRequest baseFillSQLRequest = this;
        synchronized (baseFillSQLRequest) {
            return this.searchFields;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setSearch(String s) {
        List<String> split = Arrays.asList(QUERY_SPLIT_PATTERN.split(s));
        boolean res = false;
        BaseFillSQLRequest baseFillSQLRequest = this;
        synchronized (baseFillSQLRequest) {
            this.checkFrozen();
            if (!split.equals(this.searchQuery)) {
                this.searchQuery = split;
                if (!this.getSearchFields().isEmpty()) {
                    res = true;
                }
            }
        }
        if (res) {
            this.fireWhereChange();
        }
        return res;
    }

    public final synchronized void setLockSelect(boolean lockSelect) {
        this.checkFrozen();
        this.lockSelect = lockSelect;
    }

    public final synchronized boolean isLockSelect() {
        return this.lockSelect;
    }

    @Override
    public final Collection<SQLField> getAllFields() {
        return this.getFetcher().getReq().getFields();
    }

    protected abstract Collection<SQLField> getFields();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SQLSelect transformSelect(SQLSelect sel) {
        ITransformer<SQLSelect, SQLSelect> transf;
        Where w;
        List<String> searchQuery;
        Map<SQLField, SQLSearchMode> searchFields;
        BaseFillSQLRequest baseFillSQLRequest = this;
        synchronized (baseFillSQLRequest) {
            searchFields = this.getSearchFields();
            searchQuery = this.searchQuery;
        }
        HashSet<String> matchScore = new HashSet<String>();
        if (!searchFields.isEmpty()) {
            Where where = null;
            for (String searchTerm : searchQuery) {
                Where termWhere = null;
                for (FieldRef selF : sel.getSelectFields()) {
                    SQLSearchMode mode = searchFields.get(selF.getField());
                    if (mode == null) continue;
                    termWhere = Where.createRaw(this.createWhere(selF, mode, searchTerm), new FieldRef[0]).or(termWhere);
                    if (mode.equals(SQLSearchMode.EQUALS)) continue;
                    matchScore.add("case when " + this.createWhere(selF, SQLSearchMode.EQUALS, searchTerm) + " then 1 else 0 end");
                }
                where = Where.and(termWhere, where);
            }
            w = where;
        } else {
            w = null;
        }
        sel.andWhere(w);
        if (!matchScore.isEmpty()) {
            sel.getOrder().add(0, String.valueOf(CollectionUtils.join(matchScore, " + ")) + " DESC");
        }
        return (transf = this.getSelectTransf()) == null ? sel : transf.transformChecked(sel);
    }

    protected String createWhere(FieldRef selF, SQLSearchMode mode, String searchQuery) {
        return "lower(" + selF.getFieldRef() + ") " + mode.generateSQL(selF.getField().getDBRoot(), searchQuery.toLowerCase());
    }

    public final synchronized ITransformer<SQLSelect, SQLSelect> getSelectTransf() {
        return this.selTransf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSelectTransf(ITransformer<SQLSelect, SQLSelect> transf) {
        BaseFillSQLRequest baseFillSQLRequest = this;
        synchronized (baseFillSQLRequest) {
            this.checkFrozen();
            this.selTransf = transf;
        }
        this.fireWhereChange();
    }

    protected abstract FieldExpander getShowAs();

    public final SQLTable getPrimaryTable() {
        return this.primaryTable;
    }

    protected final void fireWhereChange() {
        assert (!Thread.holdsLock(this));
        this.supp.firePropertyChange("where", null, null);
    }

    public final void addWhereListener(PropertyChangeListener l) {
        this.supp.addPropertyChangeListener("where", l);
    }

    public final void rmWhereListener(PropertyChangeListener l) {
        this.supp.removePropertyChangeListener("where", l);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " on " + this.getPrimaryTable();
    }
}

