/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.navigator;

import java.util.List;
import java.util.Set;
import org.apache.commons.dbutils.ResultSetHandler;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.model.SQLTableModifiedListener;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.navigator.SQLListModel;

public class RowsSQLListModel
extends SQLListModel<SQLRow>
implements SQLTableModifiedListener {
    private final SQLElement element;
    private final ResultSetHandler handler;

    public RowsSQLListModel(SQLElement element) {
        this.element = element;
        this.handler = new SQLRowListRSH(this.getElement().getTable(), true);
        this.getElement().getTable().addTableModifiedListener(this);
    }

    @Override
    protected void reload(final boolean noCache) {
        Set<Number> ids = this.getIds();
        SQLField key = this.getElement().getParentForeignField();
        SQLSelect sel = new SQLSelect();
        sel.addSelectStar(this.getElement().getTable());
        sel.addOrderSilent(this.getElement().getTable().getName());
        if (ids != null && key != null) {
            sel.setWhere(new Where(key, ids));
        }
        SQLDataSource source = this.getElement().getTable().getBase().getDataSource();
        List rows = (List)source.execute(sel.asString(), new IResultSetHandler(this.handler){

            @Override
            public boolean readCache() {
                return !noCache;
            }

            @Override
            public boolean writeCache() {
                return true;
            }
        });
        this.setAll(rows);
    }

    public int indexFromID(int id) {
        int i = 0;
        while (i < this.getDisplayedItems().size()) {
            SQLRow row = (SQLRow)this.getDisplayedItems().get(i);
            if (row != this.getALLValue() && row.getID() == id) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    protected String toString(SQLRow item) {
        return this.getElement().getDescription(item);
    }

    public final SQLElement getElement() {
        return this.element;
    }

    @Override
    public void tableModified(SQLTableEvent evt) {
        this.reload();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " on " + this.getElement();
    }

    protected void die() {
        this.getElement().getTable().removeTableModifiedListener(this);
    }

    @Override
    protected void idsChanged() {
        this.reload();
    }

    @Override
    protected boolean hasALLValue() {
        return true;
    }
}

