/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.CompareUtils;

public class SQLKey {
    public static final String PREFIX = "ID_";
    private final List<String> fields;
    private final Link link;

    private static boolean isKey(String fieldName) {
        return fieldName.toUpperCase().startsWith(PREFIX);
    }

    public static Set<String> foreignKeys(SQLTable table) {
        String pkeyName = CollectionUtils.getSole(table.getPKsNames());
        HashSet<String> result = new HashSet<String>();
        Iterator<SQLField> i = table.getFields().iterator();
        while (i.hasNext()) {
            String fieldName = i.next().getName();
            if (!SQLKey.isKey(fieldName) || fieldName.equals(pkeyName)) continue;
            result.add(fieldName);
        }
        return result;
    }

    public static SQLTable keyToTable(SQLField key) {
        SQLTable table = key.getTable();
        String keyName = key.getName();
        if (SQLKey.isKey(keyName)) {
            String rest = keyName.substring(PREFIX.length());
            SQLTable res = null;
            while (res == null && rest.length() > 0) {
                res = table.getDBRoot().findTable(rest);
                if (res != null) continue;
                int last_ = rest.lastIndexOf(95);
                rest = last_ > -1 ? rest.substring(0, last_) : "";
            }
            if (res == null) {
                throw new IllegalStateException("unable to find the table that " + key.getSQLName() + " points to.");
            }
            if (res.getPrimaryKeys().size() != 1) {
                throw new IllegalStateException(key + " points to " + res + " which doesn't have 1 primary key.");
            }
            return res;
        }
        throw new IllegalArgumentException("passed string is not a key");
    }

    public static SQLKey createPrimaryKey(SQLTable t) {
        List<String> pk = t.getPKsNames();
        if (pk.isEmpty()) {
            return null;
        }
        return new SQLKey(pk, null);
    }

    public static SQLKey createForeignKey(Link link) {
        return new SQLKey(link.getCols(), link);
    }

    private SQLKey(List<String> fields, Link link) {
        if (fields.isEmpty()) {
            throw new IllegalArgumentException("Empty fields");
        }
        this.fields = Collections.unmodifiableList(new ArrayList<String>(fields));
        this.link = link;
    }

    public final List<String> getFields() {
        return this.fields;
    }

    public final Type getType() {
        return this.link == null ? Type.PRIMARY_KEY : Type.FOREIGN_KEY;
    }

    public final Link getForeignLink() {
        return this.link;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fields.hashCode();
        result = 31 * result + (this.link == null ? 0 : this.link.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLKey other = (SQLKey)obj;
        return this.fields.equals(other.fields) && CompareUtils.equals(this.link, other.link);
    }

    public String toString() {
        return (Object)((Object)this.getType()) + " " + this.getFields();
    }

    public static enum Type {
        PRIMARY_KEY,
        FOREIGN_KEY;

    }
}

