/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.AbstractPath;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.model.graph.PathBuilder;
import org.openconcerto.sql.model.graph.Step;
import org.openconcerto.utils.CollectionUtils;

public final class Path
extends AbstractPath<Path> {
    private final List<SQLTable> tables;
    private final List<Step> steps;
    private final List<SQLField> singleFields;

    public static Path createFromTables(DBRoot root, List<String> path) {
        SQLTable first = root.getTable(path.get(0));
        return ((PathBuilder)new PathBuilder(first).addTables((List)path.subList(1, path.size()))).build();
    }

    public static Path get(SQLTable first) {
        return new Path(first);
    }

    public static Path create(SQLTable first, List<Link> links) {
        if (links == null) {
            return null;
        }
        PathBuilder builder = new PathBuilder(first);
        for (Link l : links) {
            builder.add(l);
        }
        return builder.build();
    }

    private static final <T> List<T> copy(List<T> l) {
        return Collections.unmodifiableList(new ArrayList<T>(l));
    }

    static Path create(List<SQLTable> tables, List<Step> steps, List<SQLField> singleFields) {
        return new Path(Path.copy(tables), Path.copy(steps), Path.copy(singleFields));
    }

    public Path(SQLTable start) {
        this.tables = Collections.singletonList(start);
        this.steps = Collections.emptyList();
        this.singleFields = Collections.emptyList();
    }

    public Path(Step step) {
        this.tables = Arrays.asList(step.getFrom(), step.getTo());
        this.steps = Collections.singletonList(step);
        this.singleFields = Collections.singletonList(step.getSingleField());
    }

    private Path(List<SQLTable> tables, List<Step> steps, List<SQLField> singleFields) {
        this.tables = tables;
        this.steps = steps;
        this.singleFields = singleFields;
    }

    public final PathBuilder toBuilder() {
        return new PathBuilder(this);
    }

    public final Path reverse() {
        int stepsCount = this.steps.size();
        if (stepsCount == 0) {
            return this;
        }
        ArrayList<SQLTable> tables = new ArrayList<SQLTable>(stepsCount + 1);
        ArrayList<Step> steps = new ArrayList<Step>(stepsCount);
        ArrayList<SQLField> singleFields = new ArrayList<SQLField>(stepsCount);
        int i = stepsCount - 1;
        while (i >= 0) {
            Step reversedStep = this.steps.get(i).reverse();
            tables.add(reversedStep.getFrom());
            steps.add(reversedStep);
            singleFields.add(reversedStep.getSingleField());
            --i;
        }
        tables.add(this.getFirst());
        return new Path(Collections.unmodifiableList(tables), Collections.unmodifiableList(steps), Collections.unmodifiableList(singleFields));
    }

    public Path minusFirst() {
        return this.subPath(1);
    }

    public Path minusLast() {
        return this.minusLast(1);
    }

    public Path minusLast(int count) {
        return this.subPath(0, -count);
    }

    public Path subPath(int fromIndex) {
        return this.subPath(fromIndex, this.length());
    }

    public Path subPath(int fromIndex, int toIndex) {
        fromIndex = CollectionUtils.getValidIndex(this.steps, fromIndex, true);
        toIndex = CollectionUtils.getValidIndex(this.steps, toIndex, true);
        if (fromIndex == 0 && toIndex == this.length()) {
            return this;
        }
        return new Path(this.tables.subList(fromIndex, toIndex + 1), this.steps.subList(fromIndex, toIndex), this.singleFields.subList(fromIndex, toIndex));
    }

    public Path justFirst() {
        return this.subPath(0, 1);
    }

    @Override
    public List<SQLTable> getTables() {
        return this.tables;
    }

    @Override
    protected final Path _append(Path p) {
        int thisLength = this.length();
        int oLength = p.length();
        if (thisLength == 0) {
            return p;
        }
        if (oLength == 0) {
            return this;
        }
        int stepsCount = thisLength + oLength;
        ArrayList<SQLTable> tables = new ArrayList<SQLTable>(stepsCount + 1);
        ArrayList<Step> steps = new ArrayList<Step>(stepsCount);
        ArrayList<SQLField> singleFields = new ArrayList<SQLField>(stepsCount);
        tables.addAll(this.tables.subList(0, thisLength));
        tables.addAll(p.tables);
        steps.addAll(this.steps);
        steps.addAll(p.steps);
        singleFields.addAll(this.singleFields);
        singleFields.addAll(p.singleFields);
        return new Path(Collections.unmodifiableList(tables), Collections.unmodifiableList(steps), Collections.unmodifiableList(singleFields));
    }

    @Override
    public final Path add(Step step) {
        return (Path)this.append(new Path(step));
    }

    @Override
    public final List<Step> getSteps() {
        return this.steps;
    }

    @Override
    public Path addTables(List<String> names) {
        return ((PathBuilder)this.toBuilder().addTables((List)names)).build();
    }

    @Override
    public final Path addForeignFields(String ... fieldsNames) {
        return this.toBuilder().addForeignFields(fieldsNames).build();
    }

    public final Step getStep(int i) {
        return this.steps.get(CollectionUtils.getValidIndex(this.steps, i, true));
    }

    public final Set<SQLField> getStepFields(int i) {
        return this.getStep(i).getFields();
    }

    public SQLField getSingleField(int i) {
        return this.singleFields.get(i);
    }

    public final List<SQLField> getSingleFields() {
        return this.singleFields;
    }

    public boolean isSingleField() {
        for (SQLField step : this.singleFields) {
            if (step != null) continue;
            return false;
        }
        return true;
    }

    public boolean isSingleLink() {
        for (Step step : this.steps) {
            if (step.isSingleLink()) continue;
            return false;
        }
        return true;
    }

    public final Set<Path> getSingleLinkPaths() {
        if (this.isSingleLink()) {
            return Collections.singleton(this);
        }
        HashSet<Path> res = new HashSet<Path>();
        for (Path p : this.subPath(1).getSingleLinkPaths()) {
            for (Step s : this.getStep(0).getSingleLinkSteps()) {
                res.add(((PathBuilder)new PathBuilder(s).append(p)).build());
            }
        }
        return res;
    }

    public final Boolean isBackwards(int i) {
        Boolean foreign = this.getStep(i).isForeign();
        return foreign == null ? null : Boolean.valueOf(foreign == false);
    }

    public final Link.Direction getDirection() {
        HashSet<Link.Direction> directions = new HashSet<Link.Direction>(this.steps.size());
        for (Step s : this.steps) {
            directions.add(s.getDirection());
        }
        return (Link.Direction)((Object)CollectionUtils.getSole(directions));
    }

    public final boolean isDirection(Link.Direction dir) {
        if (dir == null) {
            throw new NullPointerException("Null direction");
        }
        return this.length() == 0 || this.getDirection() == dir;
    }

    final Boolean isSingleDirection() {
        return this.isSingleDirection(null);
    }

    final Boolean isSingleDirection(boolean foreign) {
        return this.isSingleDirection((Boolean)foreign);
    }

    private final Boolean isSingleDirection(Boolean foreign) {
        Boolean dir = foreign;
        for (Step s : this.steps) {
            Boolean stepIsForeign = s.isForeign();
            if (stepIsForeign == null) {
                return null;
            }
            if (dir == null) {
                dir = stepIsForeign;
                continue;
            }
            if (dir.equals(stepIsForeign)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeClassName) {
        StringBuilder sb = new StringBuilder(128);
        if (includeClassName) {
            sb.append(this.getClass().getSimpleName());
            sb.append(" ");
        }
        sb.append(this.getFirst());
        for (Step step : this.steps) {
            sb.append(" ");
            step.linksToString(sb);
            sb.append(" ");
            sb.append(step.getTo());
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Path) {
            Path o = (Path)obj;
            return this.getFirst().equals(o.getFirst()) && this.steps.equals(o.steps);
        }
        return false;
    }

    public int hashCode() {
        return this.steps.hashCode();
    }

    public boolean startsWith(Path other) {
        return this.length() >= other.length() && this.subPath(0, other.length()).equals(other);
    }
}

