/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.LinkedList;
import java.util.List;
import org.openconcerto.sql.model.ConnectionHandler;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.TransactionPoint;
import org.openconcerto.sql.request.SQLCache;

class HandlersStack {
    private final SQLDataSource ds;
    private Connection conn;
    private final LinkedList<ConnectionHandler<?, ?>> stack;
    private boolean changeAllowed;
    private final LinkedList<TransactionPoint> txPoints;
    private final LinkedList<SQLCache<List<?>, Object>> caches;

    HandlersStack(SQLDataSource ds, Connection conn, ConnectionHandler<?, ?> handler) {
        if (conn == null) {
            throw new NullPointerException("null connection");
        }
        this.ds = ds;
        this.changeAllowed = false;
        this.conn = conn;
        this.stack = new LinkedList();
        this.push(handler);
        this.txPoints = new LinkedList();
        this.caches = new LinkedList();
    }

    public final Connection getConnection() throws IllegalStateException {
        if (this.conn == null) {
            throw new IllegalStateException("connection was invalidated");
        }
        return this.conn;
    }

    final void invalidConnection() {
        this.conn = null;
    }

    final HandlersStack push(ConnectionHandler<?, ?> handler) {
        this.stack.addFirst(handler);
        return this;
    }

    final boolean pop() {
        this.stack.removeFirst();
        return this.stack.isEmpty();
    }

    final void addTxPoint(TransactionPoint txPoint) {
        if (txPoint.getConn() != this.conn) {
            throw new IllegalArgumentException("Different connections");
        }
        assert (this.stack.size() > 0 || txPoint.getSavePoint() == null);
        this.addCache();
        this.txPoints.add(txPoint);
    }

    private void addCache() {
        SQLCache<List<?>, Object> previous = this.getCache();
        SQLCache<List<?>, Object> current = this.ds.createCache(this);
        this.caches.add(current);
        if (current != null && previous != null) {
            current.setParent(previous);
        }
    }

    private final void removeLastCache() {
        SQLCache<List<?>, Object> last = this.caches.removeLast();
        if (last != null) {
            last.clear();
        }
    }

    void updateCache() {
        int size = this.txPoints.size();
        if (size > 0) {
            this.clearCache();
            int i = 0;
            while (i < size - 1) {
                this.caches.add(null);
                ++i;
            }
            this.addCache();
        }
        assert (size == this.caches.size());
    }

    private final void clearCache() {
        while (!this.caches.isEmpty()) {
            this.removeLastCache();
        }
    }

    final TransactionPoint getLastTxPoint() {
        return this.txPoints.peekLast();
    }

    final SQLCache<List<?>, Object> getCache() {
        return this.caches.peekLast();
    }

    private final TransactionPoint removeFirstTxPoint() {
        return this.txPoints.pollFirst();
    }

    private final TransactionPoint removeLastTxPoint() {
        return this.txPoints.pollLast();
    }

    void commit() throws SQLException {
        TransactionPoint txPoint = this.removeFirstTxPoint();
        while (txPoint != null) {
            txPoint.fire(true);
            txPoint = this.removeFirstTxPoint();
        }
        this.clearCache();
    }

    void rollback() throws SQLException {
        TransactionPoint txPoint = this.removeLastTxPoint();
        while (txPoint != null) {
            txPoint.fire(false);
            txPoint = this.removeLastTxPoint();
        }
        this.clearCache();
    }

    void rollback(Savepoint savepoint) throws SQLException {
        TransactionPoint txPoint = this.removeLastTxPoint();
        while (txPoint.getSavePoint() != savepoint) {
            txPoint.fire(false);
            this.removeLastCache();
            txPoint = this.removeLastTxPoint();
        }
        txPoint.fire(false);
        this.removeLastCache();
        assert (this.txPoints.size() == this.caches.size());
    }

    public final boolean isChangeAllowed() {
        return this.changeAllowed;
    }

    final void setChangeAllowed(boolean b) {
        this.changeAllowed = b;
    }
}

