/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.sql.SQLException;
import java.util.Set;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.SetMap;

public final class UpdateScript {
    private final SQLRowValues updateRow;
    private final SetMap<SQLElement, SQLRowAccessor> toArchive;

    UpdateScript(SQLTable t) {
        this.updateRow = new SQLRowValues(t);
        this.toArchive = new SetMap();
    }

    final SQLRowValues getUpdateRow() {
        return this.updateRow;
    }

    final void addToArchive(SQLElement elem, SQLRowAccessor r) {
        this.toArchive.add(elem, r);
    }

    final void put(String field, UpdateScript s) {
        this.getUpdateRow().put(field, (Object)s.getUpdateRow());
        this.toArchive.merge(s.toArchive);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.getUpdateRow() + " toArchive: " + this.toArchive;
    }

    public final SQLRow exec() throws SQLException {
        SQLRow res = this.getUpdateRow().commit();
        for (SQLElement elem : this.toArchive.keySet()) {
            for (SQLRowAccessor v : (Set)this.toArchive.getNonNull(elem)) {
                elem.archive(v.getID());
            }
        }
        return res;
    }
}

