/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.TM;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowMode;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesCluster;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.SetMap;
import org.openconcerto.utils.Tuple3;
import org.openconcerto.utils.cc.ITransformer;

public final class TreesOfSQLRows {
    private final SQLElement elem;
    private final Map<SQLRow, SQLRowValues> trees;
    private final Set<SQLRow> mainRows;
    private SetMap<SQLField, SQLRow> externReferences;

    public static final TreesOfSQLRows createFromIDs(SQLElement elem, Collection<? extends Number> ids) {
        ArrayList<SQLRow> rows = new ArrayList<SQLRow>(ids.size());
        for (Number number : ids) {
            rows.add(elem.getTable().getRow(number.intValue()));
        }
        return new TreesOfSQLRows(elem, rows);
    }

    private static String createRestrictDesc(SQLElement refElem, SQLRowAccessor refVals, Link fk) {
        String rowDesc = refElem != null ? refElem.getDescription(refVals.asRow()) : refVals.asRow().toString();
        String fieldLabel = Configuration.getTranslator((SQLTable)fk.getSource()).getLabelFor(fk.getLabel());
        String fieldS = fieldLabel != null ? fieldLabel : fk.getLabel().getName();
        return TM.getTM().trM("sqlElement.linkCantBeCut", CollectionUtils.createMap("row", refVals.asRow(), "rowDesc", rowDesc, "fieldLabel", fieldS));
    }

    public TreesOfSQLRows(SQLElement elem, SQLRow row) {
        this(elem, Collections.singleton(row));
    }

    public TreesOfSQLRows(SQLElement elem, Collection<? extends SQLRowAccessor> rows) {
        this.elem = elem;
        this.trees = new HashMap<SQLRow, SQLRowValues>(rows.size());
        for (SQLRowAccessor sQLRowAccessor : rows) {
            this.elem.check(sQLRowAccessor);
            this.trees.put(sQLRowAccessor.asRow(), null);
        }
        this.mainRows = new HashSet<SQLRow>();
        this.externReferences = null;
    }

    public final SQLElement getElem() {
        return this.elem;
    }

    public final Set<SQLRow> getRows() {
        return this.trees.keySet();
    }

    public final Map<SQLRow, SQLRowValues> getTrees() throws SQLException {
        if (this.externReferences == null) {
            Tuple3<Rows, Rows, SetMap<SQLField, SQLRow>> expand = this.expand();
            assert (((Rows)expand.get0()).vals.keySet().equals(this.trees.keySet()));
            this.trees.putAll(((Rows)expand.get0()).vals);
            this.mainRows.addAll(((Rows)expand.get1()).vals.keySet());
            this.externReferences = expand.get2();
        }
        return Collections.unmodifiableMap(this.trees);
    }

    public final Set<SQLRowValuesCluster> getClusters() throws SQLException {
        Set<SQLRowValuesCluster> res = Collections.newSetFromMap(new IdentityHashMap());
        for (SQLRowValues r : this.getTrees().values()) {
            res.add(r.getGraph());
        }
        return res;
    }

    private final Tuple3<Rows, Rows, SetMap<SQLField, SQLRow>> expand() throws SQLException {
        Privates privates;
        HashMap<Integer, SQLRowValues> valsMap = new HashMap<Integer, SQLRowValues>();
        Rows hasBeen = new Rows();
        SetMap<SQLField, SQLRow> toCut = new SetMap<SQLField, SQLRow>();
        final SQLRowValues privateGraph = this.getElem().getPrivateGraph(EnumSet.of(SQLTable.VirtualFields.FOREIGN_KEYS));
        if (privateGraph.getGraph().size() > 1) {
            privates = new Privates(hasBeen, toCut);
            final HashSet<Number> ids = new HashSet<Number>();
            for (SQLRow r : this.getRows()) {
                ids.add(r.getIDNumber());
            }
            SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(privateGraph);
            fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

                @Override
                public SQLSelect transformChecked(SQLSelect input) {
                    return input.andWhere(new Where(privateGraph.getTable().getKey(), ids));
                }
            });
            HashSet<SQLRow> rowsFetched = new HashSet<SQLRow>();
            for (SQLRowValues newVals : fetcher.fetch()) {
                valsMap.put(newVals.getID(), newVals);
                rowsFetched.add(newVals.asRow());
                privates.collect(newVals);
            }
            if (!rowsFetched.equals(this.getRows())) {
                throw new IllegalStateException("Some rows are missing : " + rowsFetched + "\n" + this.getRows());
            }
        } else {
            privates = null;
        }
        Rows res = new Rows();
        for (SQLRow r : this.getRows()) {
            SQLRowValues vals = (SQLRowValues)valsMap.get(r.getID());
            if (vals == null) {
                assert (privates == null);
                vals = r.createUpdateRow();
                valsMap.put(r.getID(), vals);
            }
            hasBeen.put(r, vals);
            res.put(r, vals);
        }
        this.expand(this.getElem().getTable(), valsMap, hasBeen, toCut, false);
        if (privates != null) {
            privates.expand();
        }
        return Tuple3.create(res, hasBeen, toCut);
    }

    private final void expand(SQLTable t, final Map<Integer, SQLRowValues> valsMap, Rows hasBeen, SetMap<SQLField, SQLRow> toCut, boolean ignorePrivateParentRF) throws SQLException {
        if (valsMap.size() == 0) {
            return;
        }
        Privates privates = new Privates(hasBeen, toCut);
        Set<SQLField> privateParentRF = ignorePrivateParentRF ? this.getElem().getElement(t).getPrivateParentReferentFields() : null;
        for (final Link link : t.getDBSystemRoot().getGraph().getReferentLinks(t)) {
            SQLRowValues graphToFetch;
            SQLElement.ReferenceAction action;
            if (ignorePrivateParentRF && privateParentRF.contains(link.getLabel())) continue;
            String ffName = link.getLabel().getName();
            SQLElement refElem = this.elem.getElementLenient((SQLTable)link.getSource());
            SQLElement.ReferenceAction referenceAction = action = refElem != null ? refElem.getActions().get(link) : SQLElement.ReferenceAction.RESTRICT;
            if (action == null) {
                throw new IllegalStateException("Null action for " + refElem + " " + ffName);
            }
            HashMap<Integer, SQLRowValues> next = new HashMap<Integer, SQLRowValues>();
            if (action == SQLElement.ReferenceAction.CASCADE) {
                if (refElem.getPrivateParentReferentFields().size() > 0) {
                    throw new UnsupportedOperationException("Cannot cascade to private element " + refElem + " from " + link);
                }
                graphToFetch = refElem.getPrivateGraph(EnumSet.of(SQLTable.VirtualFields.FOREIGN_KEYS));
            } else {
                graphToFetch = new SQLRowValues((SQLTable)link.getSource()).putNulls(link.getCols());
            }
            SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(graphToFetch);
            fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

                @Override
                public SQLSelect transformChecked(SQLSelect input) {
                    return input.andWhere(new Where(link.getLabel(), valsMap.keySet()));
                }
            });
            for (SQLRowValues newVals : fetcher.fetch()) {
                SQLRow r = newVals.asRow();
                boolean already = hasBeen.contains(r);
                switch (action) {
                    case RESTRICT: {
                        throw new SQLException(TreesOfSQLRows.createRestrictDesc(refElem, newVals, link));
                    }
                    case CASCADE: {
                        if (already) break;
                        privates.collect(newVals);
                        newVals.put(ffName, (Object)valsMap.get(newVals.getInt(ffName)));
                        hasBeen.put(r, newVals);
                        next.put(newVals.getID(), newVals);
                        break;
                    }
                    case SET_EMPTY: {
                        if (already) break;
                        toCut.add(link.getLabel(), r);
                    }
                }
                if (!already) continue;
                hasBeen.getValues(r).put(ffName, (Object)valsMap.get(newVals.getInt(ffName)));
            }
            this.expand(fetcher.getGraph().getTable(), next, hasBeen, toCut, false);
        }
        privates.expand();
        Iterator iter = toCut.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry e = iter.next();
            String fieldName = ((SQLField)e.getKey()).getName();
            Iterator iter2 = ((Set)e.getValue()).iterator();
            while (iter2.hasNext()) {
                SQLRow rowToCut = (SQLRow)iter2.next();
                SQLRowValues inGraphRowToCut = hasBeen.getValues(rowToCut);
                if (inGraphRowToCut == null) continue;
                iter2.remove();
                SQLRowValues dest = hasBeen.getValues(rowToCut.getForeignRow(fieldName, SQLRowMode.NO_CHECK));
                if (dest == null) {
                    throw new IllegalStateException("destination of link to cut " + fieldName + " not found for " + rowToCut);
                }
                inGraphRowToCut.put(fieldName, (Object)dest);
            }
            if (!((Set)e.getValue()).isEmpty()) continue;
            iter.remove();
        }
    }

    public final Map<SQLTable, List<SQLRowAccessor>> getDescendantsByTable() throws SQLException {
        ListMap<SQLTable, SQLRowAccessor> res = new ListMap<SQLTable, SQLRowAccessor>();
        Set<SQLRow> roots = this.getRows();
        for (SQLRowValuesCluster c : this.getClusters()) {
            for (SQLRowValues v : c.getItems()) {
                SQLRow r = v.asRow();
                if (roots.contains(r) || !this.mainRows.contains(r)) continue;
                res.add(v.getTable(), v);
            }
        }
        return res;
    }

    public final Map<SQLField, Set<SQLRow>> getExternReferences() throws SQLException {
        this.getTrees();
        return this.externReferences;
    }

    public final SortedMap<SQLField, Integer> getExternReferencesCount() throws SQLException {
        TreeMap<SQLField, Integer> res = new TreeMap<SQLField, Integer>(new Comparator<SQLField>(){

            @Override
            public int compare(SQLField o1, SQLField o2) {
                return o1.getSQLName().toString().compareTo(o2.getSQLName().toString());
            }
        });
        for (Map.Entry<SQLField, Set<SQLRow>> e : this.getExternReferences().entrySet()) {
            res.put(e.getKey(), e.getValue().size());
        }
        return res;
    }

    private final class Privates {
        private final Rows hasBeen;
        private final SetMap<SQLField, SQLRow> toCut;
        private final Map<SQLTable, Map<Integer, SQLRowValues>> privateRows;

        public Privates(Rows hasBeen, SetMap<SQLField, SQLRow> toCut) {
            this.hasBeen = hasBeen;
            this.toCut = toCut;
            this.privateRows = new HashMap<SQLTable, Map<Integer, SQLRowValues>>();
        }

        private void collect(SQLRowValues mainRow) {
            for (SQLRowValues privateVals : mainRow.getGraph().getItems()) {
                if (privateVals == mainRow) continue;
                assert (!this.hasBeen.contains(privateVals.asRow()));
                Map<Integer, SQLRowValues> map = this.privateRows.get(privateVals.getTable());
                if (map == null) {
                    map = new HashMap<Integer, SQLRowValues>();
                    this.privateRows.put(privateVals.getTable(), map);
                }
                map.put(privateVals.getID(), privateVals);
            }
        }

        private void expand() throws SQLException {
            for (Map.Entry<SQLTable, Map<Integer, SQLRowValues>> e : this.privateRows.entrySet()) {
                TreesOfSQLRows.this.expand(e.getKey(), e.getValue(), this.hasBeen, this.toCut, true);
            }
        }
    }

    private static final class Rows {
        private final Map<SQLRow, SQLRowValues> vals = new HashMap<SQLRow, SQLRowValues>();

        private Rows() {
        }

        private boolean contains(SQLRow r) {
            return this.vals.containsKey(r);
        }

        private SQLRowValues getValues(SQLRow r) {
            return this.vals.get(r);
        }

        private void put(SQLRow r, SQLRowValues newVals) {
            assert (newVals.asRow().equals(r));
            if (this.vals.put(r, newVals) != null) {
                throw new IllegalStateException("Row already in : " + newVals);
            }
        }
    }
}

