/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.awt.Component;
import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.text.JTextComponent;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.TM;
import org.openconcerto.sql.element.ArchivedGraph;
import org.openconcerto.sql.element.RowBacked;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.element.SQLElementRowR;
import org.openconcerto.sql.element.TreesOfSQLRows;
import org.openconcerto.sql.element.UpdateScript;
import org.openconcerto.sql.model.DBStructureItemNotFound;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLFieldsSet;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowMode;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesCluster;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.DatabaseGraph;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.request.SQLCache;
import org.openconcerto.sql.sqlobject.SQLTextCombo;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelColumnPath;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.group.Group;
import org.openconcerto.utils.CollectionMap;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.ExceptionUtils;
import org.openconcerto.utils.LinkedListMap;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.NumberUtils;
import org.openconcerto.utils.RecursionType;
import org.openconcerto.utils.SetMap;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cache.CacheResult;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.change.ListChangeIndex;
import org.openconcerto.utils.change.ListChangeRecorder;
import org.openconcerto.utils.i18n.Grammar;
import org.openconcerto.utils.i18n.Grammar_fr;
import org.openconcerto.utils.i18n.NounClass;
import org.openconcerto.utils.i18n.Phrase;

public abstract class SQLElement {
    private static final Set<String> computingFF = Collections.unmodifiableSet(new HashSet());
    private static final Set<SQLField> computingRF = Collections.unmodifiableSet(new HashSet());
    public static final String DEFAULT_COMP_ID = "default component code";
    public static final String DEFERRED_CODE = new String("deferred code");
    private SQLElementDirectory directory;
    private String l18nPkgName;
    private Class<?> l18nClass;
    private Phrase name;
    private final SQLTable primaryTable;
    private String code;
    private ComboSQLRequest combo;
    private ListSQLRequest list;
    private SQLTableModelSourceOnline tableSrc;
    private final ListChangeRecorder<IListeAction> rowActions;
    private final LinkedListMap<String, ITransformer<Tuple2<SQLElement, String>, SQLComponent>> components;
    private Set<String> normalFF;
    private String parentFF;
    private Set<String> sharedFF;
    private Map<String, SQLElement> privateFF;
    private final Map<Link, ReferenceAction> actions;
    private Set<SQLField> childRF;
    private Set<SQLField> privateParentRF;
    private Set<SQLField> otherRF;
    private SQLCache<SQLRowAccessor, Object> modelCache;
    private final Map<String, JComponent> additionalFields;
    private final List<SQLTableModelColumn> additionalListCols;
    private List<String> mdPath;
    private Group defaultGroup;

    private static Phrase createPhrase(String singular, String plural) {
        String base;
        NounClass nounClass;
        if (singular.startsWith("une ")) {
            nounClass = NounClass.FEMININE;
            base = singular.substring(4);
        } else if (singular.startsWith("un ")) {
            nounClass = NounClass.MASCULINE;
            base = singular.substring(3);
        } else {
            nounClass = null;
            base = singular;
        }
        Phrase res = new Phrase(Grammar_fr.getInstance(), base, nounClass);
        if (nounClass != null) {
            res.putVariant(Grammar.INDEFINITE_ARTICLE_SINGULAR, singular);
        }
        res.putVariant(Grammar.PLURAL, plural);
        return res;
    }

    @Deprecated
    public SQLElement(String singular, String plural, SQLTable primaryTable) {
        this(primaryTable, SQLElement.createPhrase(singular, plural));
    }

    public SQLElement(SQLTable primaryTable) {
        this(primaryTable, null);
    }

    public SQLElement(SQLTable primaryTable, Phrase name) {
        this(primaryTable, name, null);
    }

    public SQLElement(SQLTable primaryTable, Phrase name, String code) {
        if (primaryTable == null) {
            throw new DBStructureItemNotFound("table is null for " + this.getClass());
        }
        this.primaryTable = primaryTable;
        this.setL18nPackageName(null);
        this.setDefaultName(name);
        this.code = code == null ? this.createCode() : code;
        this.combo = null;
        this.list = null;
        this.rowActions = new ListChangeRecorder(new ArrayList());
        this.actions = new HashMap<Link, ReferenceAction>();
        this.resetRelationships();
        this.components = new LinkedListMap();
        this.modelCache = null;
        this.additionalFields = new LinkedHashMap<String, JComponent>();
        this.additionalListCols = new ArrayList<SQLTableModelColumn>();
        this.mdPath = Collections.emptyList();
    }

    protected String createCode() {
        return String.valueOf(this.getClass().getName()) + "-" + this.getTable().getName();
    }

    public Group getDefaultGroup() {
        return this.defaultGroup;
    }

    public void setDefaultGroup(Group defaultGroup) {
        this.defaultGroup = defaultGroup;
    }

    public synchronized void resetRelationships() {
        this.privateFF = null;
        this.parentFF = null;
        this.normalFF = null;
        this.sharedFF = null;
        this.actions.clear();
        this.childRF = null;
        this.privateParentRF = null;
        this.otherRF = null;
    }

    protected final synchronized boolean areRelationshipsInited() {
        return this.sharedFF != null;
    }

    private void checkSelfCall(boolean check, String methodName) {
        assert (check) : this + " " + methodName + "() is calling itself, and thus the caller will only see a partial state";
    }

    private synchronized void initFF() {
        this.checkSelfCall(this.sharedFF != computingFF, "initFF");
        if (this.areRelationshipsInited()) {
            return;
        }
        this.sharedFF = computingFF;
        HashSet<String> privates = new HashSet<String>(this.getPrivateFields());
        this.privateFF = new HashMap<String, SQLElement>(privates.size());
        HashSet<String> parents = new HashSet<String>();
        this.normalFF = new HashSet<String>();
        HashSet<String> tmpSharedFF = new HashSet<String>();
        for (SQLField ff : this.getTable().getForeignKeys()) {
            String fieldName = ff.getName();
            SQLElement foreignElement = this.getForeignElement(fieldName);
            if (privates.contains(fieldName)) {
                privates.remove(fieldName);
                this.privateFF.put(fieldName, foreignElement);
                continue;
            }
            if (foreignElement.isShared()) {
                tmpSharedFF.add(fieldName);
                continue;
            }
            if (foreignElement.getChildrenReferentFields().contains(ff)) {
                parents.add(fieldName);
                continue;
            }
            this.normalFF.add(fieldName);
        }
        if (parents.size() > 1) {
            throw new IllegalStateException("for " + this + " more than one parent :" + parents);
        }
        String string = this.parentFF = parents.size() == 0 ? null : (String)parents.iterator().next();
        if (privates.size() > 0) {
            throw new IllegalStateException("for " + this + " these private foreign fields are not valid :" + privates);
        }
        assert (this.assertPrivateDefaultValues());
        this.sharedFF = tmpSharedFF;
        if (this.parentFF != null) {
            this.actions.put(this.getLinkFromFieldName(this.parentFF), ReferenceAction.CASCADE);
        }
        for (String s : this.privateFF.keySet()) {
            this.actions.put(this.getLinkFromFieldName(s), ReferenceAction.SET_EMPTY);
        }
        for (String s : this.normalFF) {
            this.actions.put(this.getLinkFromFieldName(s), ReferenceAction.SET_EMPTY);
        }
        for (String s : this.sharedFF) {
            this.actions.put(this.getLinkFromFieldName(s), ReferenceAction.RESTRICT);
        }
        this.ffInited();
    }

    private final boolean assertPrivateDefaultValues() {
        for (Map.Entry<String, SQLElement> e : this.privateFF.entrySet()) {
            String fieldName = e.getKey();
            Number privateDefault = (Number)this.getTable().getField(fieldName).getParsedDefaultValue().getValue();
            Number foreignUndef = e.getValue().getTable().getUndefinedIDNumber();
            assert (NumberUtils.areNumericallyEqual(privateDefault, foreignUndef)) : String.valueOf(fieldName) + " not empty : " + privateDefault;
        }
        return true;
    }

    protected void ffInited() {
    }

    private synchronized Set<SQLField> computeChildrenRF() {
        HashSet<SQLField> res = new HashSet<SQLField>();
        for (String child : this.getChildren()) {
            SQLField childField;
            int comma = child.indexOf(44);
            String tableName = comma < 0 ? child : child.substring(0, comma);
            SQLTable childTable = this.getTable().getTable(tableName);
            if (comma < 0) {
                Set<SQLField> keys = childTable.getForeignKeys(this.getTable());
                if (keys.size() != 1) {
                    throw new IllegalArgumentException("cannot find a foreign from " + child + " to " + this.getTable());
                }
                childField = keys.iterator().next();
            } else {
                childField = childTable.getField(child.substring(comma + 1));
                SQLTable foreignTable = childField.getDBSystemRoot().getGraph().getForeignTable(childField);
                if (!foreignTable.equals(this.getTable())) {
                    throw new IllegalArgumentException(childField + " doesn't point to " + this.getTable());
                }
            }
            res.add(childField);
        }
        return res;
    }

    private synchronized void initRF() {
        this.checkSelfCall(this.otherRF != computingRF, "initRF");
        if (this.otherRF != null) {
            return;
        }
        this.otherRF = computingRF;
        this.privateParentRF = new HashSet<SQLField>();
        HashSet<SQLField> tmpOtherRF = new HashSet<SQLField>();
        for (SQLField refField : this.getTable().getBase().getGraph().getReferentKeys(this.getTable())) {
            SQLElement refElem = this.getElementLenient(refField.getTable());
            if (refElem != null && refElem.getPrivateForeignFields().contains(refField.getName())) {
                this.privateParentRF.add(refField);
                continue;
            }
            if (this.getChildrenReferentFields().contains(refField)) continue;
            tmpOtherRF.add(refField);
        }
        this.otherRF = tmpOtherRF;
    }

    private synchronized void initChildRF() {
        this.checkSelfCall(this.childRF != computingRF, "initFF");
        if (this.childRF != null) {
            return;
        }
        this.childRF = computingRF;
        Set<SQLField> children = this.computeChildrenRF();
        HashSet<SQLField> tmpChildRF = new HashSet<SQLField>();
        for (SQLField refField : this.getTable().getBase().getGraph().getReferentKeys(this.getTable())) {
            SQLField refParentFF;
            SQLElement refElem = this.getElementLenient(refField.getTable());
            SQLField sQLField = refParentFF = refElem == null ? null : refElem.getParentFF();
            if (refParentFF != null && children.contains(refField)) {
                throw new IllegalStateException(refElem + " specifies this as its parent: " + refParentFF + " and is also mentioned as our (" + this + ") child: " + refField);
            }
            if (!children.contains(refField) && refParentFF != refField) continue;
            tmpChildRF.add(refField);
        }
        this.childRF = tmpChildRF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setDirectory(SQLElementDirectory directory) {
        assert (directory == null || directory.getElement(this.getTable()) == this);
        SQLElement sQLElement = this;
        synchronized (sQLElement) {
            if (this.directory != directory) {
                if (this.areRelationshipsInited()) {
                    this.resetRelationships();
                }
                this.directory = directory;
            }
        }
    }

    public final synchronized SQLElementDirectory getDirectory() {
        return this.directory;
    }

    final SQLElement getElement(SQLTable table) {
        SQLElement res = this.getElementLenient(table);
        if (res == null) {
            throw new IllegalStateException("no element for " + table.getSQLName());
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final SQLElement getElementLenient(SQLTable table) {
        SQLElement sQLElement = this;
        synchronized (sQLElement) {
            return this.getDirectory().getElement(table);
        }
    }

    public final SQLElement getForeignElement(String foreignField) {
        try {
            return this.getElement(this.getForeignTable(foreignField));
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("no element for " + foreignField + " in " + this, e);
        }
    }

    private final SQLTable getForeignTable(String foreignField) {
        return this.getTable().getBase().getGraph().getForeignTable(this.getTable().getField(foreignField));
    }

    public final synchronized String getL18nPackageName() {
        return this.l18nPkgName;
    }

    public final synchronized Class<?> getL18nClass() {
        return this.l18nClass;
    }

    public final void setL18nLocation(Class<?> clazz) {
        this.setL18nLocation(clazz.getPackage().getName(), clazz);
    }

    public final void setL18nPackageName(String name) {
        this.setL18nLocation(name, null);
    }

    public final synchronized void setL18nLocation(String name, Class<?> ctxt) {
        this.l18nPkgName = name;
        this.l18nClass = ctxt == null ? this.getClass() : ctxt;
    }

    public final synchronized void setDefaultName(Phrase name) {
        this.name = name != null ? name : Phrase.getInvariant(this.getTable().getName());
    }

    public final synchronized Phrase getDefaultName() {
        return this.name;
    }

    public final Phrase getName() {
        SQLElementDirectory dir = this.getDirectory();
        Phrase res = dir == null ? null : dir.getName(this);
        return res == null ? this.getDefaultName() : res;
    }

    public String getPluralName() {
        return this.getName().getVariant(Grammar.PLURAL);
    }

    public String getSingularName() {
        return this.getName().getVariant(Grammar.INDEFINITE_ARTICLE_SINGULAR);
    }

    public CollectionMap<String, String> getShowAs() {
        return null;
    }

    public Set<String> getReadOnlyFields() {
        return Collections.emptySet();
    }

    public Set<String> getInsertOnlyFields() {
        return Collections.emptySet();
    }

    private final SQLCache<SQLRowAccessor, Object> getModelCache() {
        if (this.modelCache == null) {
            this.modelCache = new SQLCache(60, -1, "modelObjects of " + this.getCode());
        }
        return this.modelCache;
    }

    public final UpdateScript update(SQLRowValues from, SQLRowValues to) {
        this.check(from);
        this.check(to);
        if (!from.hasID()) {
            throw new IllegalArgumentException("missing id in " + from);
        }
        if (from.getID() != to.getID()) {
            throw new IllegalArgumentException("not the same row: " + from + " != " + to);
        }
        Set<SQLField> fks = this.getTable().getForeignKeys();
        UpdateScript res = new UpdateScript(this.getTable());
        for (String field : to.getFields()) {
            if (!fks.contains(this.getTable().getField(field))) {
                res.getUpdateRow().put(field, to.getObject(field));
                continue;
            }
            Object fromPrivate = from.getObject(field);
            Object toPrivate = to.getObject(field);
            SQLElement privateElem = this.getPrivateElement(field);
            if (privateElem != null) {
                boolean toIsEmpty;
                assert (!from.isDefault(field)) : "A row in the DB cannot have DEFAULT";
                boolean fromIsEmpty = from.isForeignEmpty(field);
                boolean bl = toIsEmpty = to.isDefault(field) || to.isForeignEmpty(field);
                if (fromIsEmpty && toIsEmpty) continue;
                if (fromIsEmpty) {
                    SQLRowValues toPR = (SQLRowValues)toPrivate;
                    res.getUpdateRow().put(field, (Object)toPR.deepCopy().clearReferents());
                    continue;
                }
                if (toIsEmpty) {
                    res.addToArchive(privateElem, from.getForeign(field));
                    continue;
                }
                if (!CompareUtils.equals(from.getForeignID(field), to.getForeignID(field))) {
                    throw new IllegalArgumentException("private have changed for " + field + " : " + fromPrivate + " != " + toPrivate);
                }
                if (!(toPrivate instanceof SQLRowValues)) continue;
                SQLRowValues fromPR = (SQLRowValues)fromPrivate;
                SQLRowValues toPR = (SQLRowValues)toPrivate;
                res.put(field, privateElem.update(fromPR, toPR));
                continue;
            }
            if (to.isDefault(field)) {
                res.getUpdateRow().putDefault(field);
                continue;
            }
            res.getUpdateRow().put(field, to.getForeignIDNumber(field));
        }
        return res;
    }

    public void unarchiveNonRec(int id) throws SQLException {
        this.unarchive(this.getTable().getRow(id), false);
    }

    public final void unarchive(int id) throws SQLException {
        this.unarchive(this.getTable().getRow(id));
    }

    public void unarchive(SQLRow row) throws SQLException {
        this.unarchive(row, true);
    }

    public void unarchive(SQLRow row, boolean desc) throws SQLException {
        this.checkUndefined(row);
        SQLRowValues descsAndMe = desc ? this.getTree(row, true) : row.asRowValues();
        final SQLRowValues connectedRows = new ArchivedGraph(this.getDirectory(), descsAndMe).expand();
        SQLUtils.executeAtomic(this.getTable().getBase().getDataSource(), new SQLUtils.SQLFactory<Object>(){

            @Override
            public Object create() throws SQLException {
                SQLElement.setArchive(Collections.singletonList(connectedRows.getGraph()), false);
                return null;
            }
        });
    }

    public final void archive(int id) throws SQLException {
        this.archive(this.getTable().getRow(id));
    }

    public final void archive(Collection<? extends SQLRowAccessor> rows) throws SQLException {
        this.archive(new TreesOfSQLRows(this, rows), true);
    }

    public final void archive(SQLRow row) throws SQLException {
        this.archive(row, true);
    }

    public final void archiveNoCut(int id) throws SQLException {
        this.archive(this.getTable().getRow(id), false);
    }

    protected void archive(SQLRow row, boolean cutLinks) throws SQLException {
        this.archive(new TreesOfSQLRows(this, row), cutLinks);
    }

    protected void archive(final TreesOfSQLRows trees, final boolean cutLinks) throws SQLException {
        if (trees.getElem() != this) {
            throw new IllegalArgumentException(this + " != " + trees.getElem());
        }
        for (SQLRow row : trees.getRows()) {
            this.checkUndefined(row);
        }
        SQLUtils.executeAtomic(this.getTable().getBase().getDataSource(), new SQLUtils.SQLFactory<Object>(){

            @Override
            public Object create() throws SQLException {
                if (cutLinks) {
                    Map<SQLField, Set<SQLRow>> externReferences = trees.getExternReferences();
                    if (Log.get().isLoggable(Level.FINEST)) {
                        Log.get().finest("will cut : " + externReferences);
                    }
                    for (Map.Entry<SQLField, Set<SQLRow>> e : externReferences.entrySet()) {
                        SQLField refKey = e.getKey();
                        for (SQLRow ref : e.getValue()) {
                            ref.createEmptyUpdateRow().putEmptyLink(refKey.getName()).update();
                        }
                    }
                    Log.get().finest("done cutting links");
                }
                SQLElement.setArchive(trees.getClusters(), true);
                return null;
            }
        });
    }

    private static final SQLRowValues setArchive(SQLRowValues r, boolean archive) throws SQLException {
        SQLField archiveField = r.getTable().getArchiveField();
        Comparable<Boolean> newVal = Boolean.class.equals(archiveField.getType().getJavaType()) ? (Comparable<Boolean>)Boolean.valueOf(archive) : (Comparable<Boolean>)Integer.valueOf(archive ? 1 : 0);
        r.put(archiveField.getName(), newVal);
        return r;
    }

    private static void setArchive(Collection<SQLRowValuesCluster> clustersToArchive, final boolean archive) throws SQLException {
        Set toArchive = Collections.newSetFromMap(new IdentityHashMap());
        for (SQLRowValuesCluster c : clustersToArchive) {
            toArchive.addAll(c.getItems());
        }
        HashMap<SQLRow, SQLRowValues> linksCut = new HashMap<SQLRow, SQLRowValues>();
        while (!toArchive.isEmpty()) {
            int archivedCount = -1;
            while (archivedCount != 0) {
                archivedCount = 0;
                Iterator iter = toArchive.iterator();
                while (iter.hasNext()) {
                    SQLRowValues desc = (SQLRowValues)iter.next();
                    if ((!archive || desc.hasReferents()) && (archive || desc.hasForeigns())) continue;
                    SQLRowValues updateVals = (SQLRowValues)linksCut.remove(desc.asRow());
                    if (updateVals == null) {
                        updateVals = new SQLRowValues(desc.getTable());
                    }
                    SQLElement.setArchive(updateVals, archive).setID(desc.getIDNumber());
                    assert (updateVals.getGraph().size() == 1) : "Archiving a graph : " + updateVals.printGraph();
                    updateVals.getGraph().store(SQLRowValuesCluster.StoreMode.COMMIT, false);
                    desc.clear();
                    desc.clearReferents();
                    assert (desc.getGraph().size() == 1) : "Next loop won't progress : " + desc.printGraph();
                    ++archivedCount;
                    iter.remove();
                }
            }
            if (toArchive.isEmpty()) continue;
            SQLRowValues first = (SQLRowValues)toArchive.iterator().next();
            final AtomicReference<Object> cutLinksRef = new AtomicReference<Object>(null);
            first.getGraph().walk(first, null, new ITransformer<SQLRowValuesCluster.State<Object>, Object>(){

                @Override
                public Object transformChecked(SQLRowValuesCluster.State<Object> input) {
                    SQLRowValues last = input.getCurrent();
                    boolean cycleFound = false;
                    int minLinksCount = -1;
                    SQLRowValues leastLinks = null;
                    Iterator<SQLRowValues> iter = input.getValsPath().iterator();
                    while (iter.hasNext()) {
                        int linksCount;
                        SQLRowValues v = iter.next();
                        if (!cycleFound) {
                            boolean bl = cycleFound = iter.hasNext() && v == last;
                        }
                        if (!cycleFound) continue;
                        int n = linksCount = archive ? v.getReferentsMap().allValues().size() : v.getForeigns().size();
                        if (!$assertionsDisabled && linksCount <= 0) {
                            throw new AssertionError();
                        }
                        if (leastLinks != null && linksCount >= minLinksCount) continue;
                        leastLinks = v;
                        minLinksCount = linksCount;
                    }
                    if (cycleFound) {
                        cutLinksRef.set(leastLinks);
                        throw new SQLRowValuesCluster.StopRecurseException();
                    }
                    return null;
                }
            }, new SQLRowValuesCluster.WalkOptions(Link.Direction.REFERENT).setRecursionType(RecursionType.BREADTH_FIRST).setStartIncluded(false).setCycleAllowed(true));
            SQLRowValues cutLinks = cutLinksRef.get();
            assert (cutLinks != null);
            if (archive) {
                for (Map.Entry e : new SetMap(cutLinks.getReferentsMap()).entrySet()) {
                    String fieldName = ((SQLField)e.getKey()).getName();
                    for (SQLRowValues v : (Set)e.getValue()) {
                        SQLRowValues cutVals = (SQLRowValues)linksCut.get(v.asRow());
                        if (cutVals == null) {
                            cutVals = new SQLRowValues(v.getTable());
                            linksCut.put(v.asRow(), cutVals);
                        }
                        assert (!cutVals.getFields().contains(fieldName)) : String.valueOf(fieldName) + " already cut for " + v;
                        assert (!v.isForeignEmpty(fieldName)) : "Nothing to cut";
                        cutVals.put(fieldName, v.getForeignIDNumber(fieldName));
                        v.putEmptyLink(fieldName);
                        new SQLRowValues(v.getTable()).putEmptyLink(fieldName).update(v.getID());
                    }
                }
            } else {
                HashSet<String> foreigns = new HashSet<String>(cutLinks.getForeigns().keySet());
                SQLRowValues oldVal = linksCut.put(cutLinks.asRow(), new SQLRowValues(cutLinks, SQLRowValues.ForeignCopyMode.COPY_ID_OR_RM));
                assert (oldVal == null) : "Already cut";
                cutLinks.removeAll(foreigns);
                SQLRowValues updateVals = new SQLRowValues(cutLinks.getTable());
                for (String fieldName : foreigns) {
                    updateVals.putEmptyLink(fieldName);
                }
                updateVals.update(cutLinks.getID());
            }
            assert (archive && !cutLinks.hasReferents() || !archive && !cutLinks.hasForeigns());
        }
        assert (!archive || linksCut.isEmpty()) : "Some links weren't restored : " + linksCut;
        if (!archive) {
            for (Map.Entry e : linksCut.entrySet()) {
                ((SQLRowValues)e.getValue()).update(((SQLRow)e.getKey()).getID());
            }
        }
    }

    public void delete(SQLRowAccessor r) throws SQLException {
        this.check(r);
        throw new UnsupportedOperationException("not yet implemented.");
    }

    public final SQLTable getTable() {
        return this.primaryTable;
    }

    public final synchronized String getCode() {
        if (this.code == DEFERRED_CODE) {
            String createCode = this.createCode();
            if (createCode == DEFERRED_CODE) {
                throw new IllegalStateException("createCode() returned DEFERRED_CODE");
            }
            this.code = createCode;
        }
        return this.code;
    }

    public boolean isShared() {
        return false;
    }

    public boolean dontDeepCopy() {
        return false;
    }

    public final synchronized Set<SQLField> getOtherReferentFields() {
        this.initRF();
        return this.otherRF;
    }

    public final synchronized Set<SQLField> getChildrenReferentFields() {
        this.initChildRF();
        return this.childRF;
    }

    public final synchronized Set<SQLField> getPrivateParentReferentFields() {
        this.initRF();
        return this.privateParentRF;
    }

    protected Set<String> getChildren() {
        return Collections.emptySet();
    }

    public final synchronized Set<String> getNormalForeignFields() {
        this.initFF();
        return this.normalFF;
    }

    public final synchronized Set<String> getSharedForeignFields() {
        this.initFF();
        return this.sharedFF;
    }

    public final SQLField getParentForeignField() {
        return this.getOptionalField(this.getParentForeignFieldName());
    }

    public final synchronized String getParentForeignFieldName() {
        this.initFF();
        return this.parentFF;
    }

    private final SQLField getParentFF() {
        return this.getOptionalField(this.getParentFFName());
    }

    private final SQLField getOptionalField(String name) {
        return name == null ? null : this.getTable().getField(name);
    }

    protected String getParentFFName() {
        return null;
    }

    public final SQLElement getParentElement() {
        if (this.getParentForeignFieldName() == null) {
            return null;
        }
        return this.getForeignElement(this.getParentForeignFieldName());
    }

    private final synchronized Map<String, SQLElement> getPrivateFF() {
        this.initFF();
        return this.privateFF;
    }

    public final Set<String> getPrivateForeignFields() {
        return Collections.unmodifiableSet(this.getPrivateFF().keySet());
    }

    public final SQLElement getPrivateElement(String foreignField) {
        return this.getPrivateFF().get(foreignField);
    }

    public final SQLRowValues getPrivateGraph() {
        return this.getPrivateGraph(null);
    }

    public final SQLRowValues getPrivateGraph(Set<SQLTable.VirtualFields> fields) {
        SQLRowValues res = new SQLRowValues(this.getTable());
        if (fields == null) {
            res.setAllToNull();
        } else {
            for (SQLTable.VirtualFields virtualFields : fields) {
                for (SQLField f : this.getTable().getFields(virtualFields)) {
                    res.put(f.getName(), null);
                }
            }
        }
        for (Map.Entry entry : this.getPrivateFF().entrySet()) {
            res.put((String)entry.getKey(), (Object)((SQLElement)entry.getValue()).getPrivateGraph(fields));
        }
        return res;
    }

    protected List<String> getPrivateFields() {
        return Collections.emptyList();
    }

    public final void clearPrivateFields(SQLRowValues rowVals) {
        for (String s : this.getPrivateFF().keySet()) {
            rowVals.remove(s);
        }
    }

    final Map<Link, ReferenceAction> getActions() {
        this.initFF();
        return this.actions;
    }

    public final void setAction(String ff, ReferenceAction action) throws IllegalArgumentException {
        if (action.compareTo(ReferenceAction.RESTRICT) < 0 && !this.getNormalForeignFields().contains(ff)) {
            throw new IllegalArgumentException(this.getTable().getField(ff).getSQLName() + " is not a normal foreign field : " + this.getNormalForeignFields());
        }
        this.getActions().put(this.getLinkFromFieldName(ff), action);
    }

    private final Link getLinkFromFieldName(String ff) {
        return this.getTable().getDBSystemRoot().getGraph().getForeignLink(this.getTable(), Arrays.asList(ff));
    }

    public final Set<Link> getParentsLinks() {
        Set<SQLField> refFields = this.getPrivateParentReferentFields();
        HashSet<Link> res = new HashSet<Link>(refFields.size());
        DatabaseGraph graph = this.getTable().getDBSystemRoot().getGraph();
        for (SQLField refField : refFields) {
            res.add(graph.getForeignLink(refField));
        }
        SQLField parentFF = this.getParentForeignField();
        if (parentFF != null) {
            res.add(graph.getForeignLink(parentFF));
        }
        return res;
    }

    public final Set<SQLElement> getChildrenElements() {
        HashSet<SQLElement> res = new HashSet<SQLElement>();
        res.addAll(this.getPrivateFF().values());
        for (SQLTable child : new SQLFieldsSet(this.getChildrenReferentFields()).getTables()) {
            res.add(this.getElement(child));
        }
        return res;
    }

    public final SQLElement getChildElement(String tableName) {
        SQLField field = CollectionUtils.getSole(new SQLFieldsSet(this.getChildrenReferentFields()).getFields(tableName));
        if (field == null) {
            throw new IllegalStateException("no child table named " + tableName);
        }
        return this.getElement(field.getTable());
    }

    public final Set<SQLTable> getDescendantTables() {
        HashSet<SQLTable> res = new HashSet<SQLTable>();
        this.getDescendantTables(res);
        return res;
    }

    private final void getDescendantTables(Set<SQLTable> res) {
        res.add(this.getTable());
        for (SQLElement elem : this.getChildrenElements()) {
            res.addAll(elem.getDescendantTables());
        }
    }

    public final ComboSQLRequest getComboRequest() {
        return this.getComboRequest(false);
    }

    public final ComboSQLRequest getComboRequest(boolean create) {
        if (!create) {
            if (this.combo == null) {
                this.combo = this.createComboRequest();
            }
            return this.combo;
        }
        return this.createComboRequest();
    }

    protected ComboSQLRequest createComboRequest() {
        return new ComboSQLRequest(this.getTable(), this.getComboFields());
    }

    protected List<String> getComboFields() {
        return this.getListFields();
    }

    public final synchronized ListSQLRequest getListRequest() {
        if (this.list == null) {
            this.list = this.createListRequest();
        }
        return this.list;
    }

    protected ListSQLRequest createListRequest() {
        return new ListSQLRequest(this.getTable(), this.getListFields());
    }

    public final SQLTableModelSourceOnline getTableSource() {
        return this.getTableSource(!this.cacheTableSource());
    }

    public final synchronized SQLTableModelSourceOnline getTableSource(boolean create) {
        if (!create) {
            if (this.tableSrc == null) {
                this.tableSrc = this.createAndInitTableSource();
            }
            return this.tableSrc;
        }
        return this.createAndInitTableSource();
    }

    public final SQLTableModelSourceOnline createTableSource(List<String> fields) {
        return this.initTableSource(new SQLTableModelSourceOnline(new ListSQLRequest(this.getTable(), fields)));
    }

    public final SQLTableModelSourceOnline createTableSource(Where w) {
        SQLTableModelSourceOnline res = this.getTableSource(true);
        res.getReq().setWhere(w);
        return res;
    }

    private final SQLTableModelSourceOnline createAndInitTableSource() {
        SQLTableModelSourceOnline res = this.createTableSource();
        res.getColumns().addAll(this.additionalListCols);
        return this.initTableSource(res);
    }

    protected synchronized void _initTableSource(SQLTableModelSourceOnline res) {
    }

    public final synchronized SQLTableModelSourceOnline initTableSource(SQLTableModelSourceOnline res) {
        this._initTableSource(res);
        Set<String> dontModif = CollectionUtils.union(this.getReadOnlyFields(), this.getInsertOnlyFields());
        for (String f : dontModif) {
            for (SQLTableModelColumn col : res.getColumns(this.getTable().getField(f))) {
                if (!(col instanceof SQLTableModelColumnPath)) continue;
                ((SQLTableModelColumnPath)col).setEditable(false);
            }
        }
        return res;
    }

    protected SQLTableModelSourceOnline createTableSource() {
        return new SQLTableModelSourceOnline(this.createListRequest());
    }

    protected boolean cacheTableSource() {
        return true;
    }

    protected abstract List<String> getListFields();

    public final void addListFields(List<String> fields) {
        for (String f : fields) {
            this.addListColumn(new SQLTableModelColumnPath(this.getTable().getField(f)));
        }
    }

    public final void addListColumn(SQLTableModelColumn col) {
        this.additionalListCols.add(col);
    }

    public final Collection<IListeAction> getRowActions() {
        return this.rowActions;
    }

    public final void addRowActionsListener(IClosure<ListChangeIndex<IListeAction>> listener) {
        this.rowActions.getRecipe().addListener(listener);
    }

    public final void removeRowActionsListener(IClosure<ListChangeIndex<IListeAction>> listener) {
        this.rowActions.getRecipe().rmListener(listener);
    }

    public String getDescription(SQLRow fromRow) {
        return fromRow.toString();
    }

    private <R extends SQLRowAccessor> void forChildrenDo(R row, ChildProcessor<? super R> c, boolean deep, boolean archived) throws SQLException {
        for (SQLField childField : this.getChildrenReferentFields()) {
            if (!deep && this.getElement(childField.getTable()).dontDeepCopy()) continue;
            List<SQLRow> children = row.asRow().getReferentRows(childField, archived ? SQLSelect.ARCHIVED : SQLSelect.UNARCHIVED);
            for (SQLRow child : children) {
                c.process(row, childField, this.convert(child, row));
            }
        }
    }

    private <R extends SQLRowAccessor> R convert(SQLRow toConv, R row) {
        SQLRowAccessor ch;
        if (row instanceof SQLRow) {
            ch = toConv;
        } else if (row instanceof SQLRowValues) {
            ch = toConv.createUpdateRow();
        } else {
            throw new IllegalStateException("SQLRowAccessor is neither SQLRow nor SQLRowValues: " + toConv);
        }
        return (R)ch;
    }

    private void forDescendantsDo(SQLRow row, ChildProcessor<SQLRow> c, boolean deep) throws SQLException {
        this.forDescendantsDo(row, c, deep, true, false);
    }

    <R extends SQLRowAccessor> void forDescendantsDo(R row, final ChildProcessor<R> c, final boolean deep, final boolean leavesFirst, final boolean archived) throws SQLException {
        this.check(row);
        this.forChildrenDo(row, new ChildProcessor<R>(){

            @Override
            public void process(R parent, SQLField joint, R child) throws SQLException {
                if (!leavesFirst) {
                    c.process(parent, joint, child);
                }
                SQLElement.this.getElement(((SQLRowAccessor)child).getTable()).forDescendantsDo(child, c, deep, leavesFirst, archived);
                if (leavesFirst) {
                    c.process(parent, joint, child);
                }
            }
        }, deep, archived);
    }

    void check(SQLRowAccessor row) {
        if (!row.getTable().equals(this.getTable())) {
            throw new IllegalArgumentException("row must of table " + this.getTable() + " : " + row);
        }
    }

    private void checkUndefined(SQLRow row) {
        this.check(row);
        if (row.isUndefined()) {
            throw new IllegalArgumentException("row is undefined: " + row);
        }
    }

    public final SQLRow copyRecursive(int id) throws SQLException {
        return this.copyRecursive(this.getTable().getRow(id));
    }

    public final SQLRow copyRecursive(SQLRow row) throws SQLException {
        return this.copyRecursive(row, null);
    }

    public SQLRow copyRecursive(SQLRow row, SQLRow parent) throws SQLException {
        return this.copyRecursive(row, parent, null);
    }

    public SQLRow copyRecursive(SQLRow row, SQLRow parent, IClosure<SQLRowValues> c) throws SQLException {
        return this.copyRecursive(row, false, parent, c);
    }

    public SQLRow copyRecursive(final SQLRow row, final boolean full, final SQLRow parent, final IClosure<SQLRowValues> c) throws SQLException {
        this.check(row);
        if (row.isUndefined()) {
            return row;
        }
        final HashMap copies = new HashMap();
        return SQLUtils.executeAtomic(this.getTable().getBase().getDataSource(), new SQLUtils.SQLFactory<SQLRow>(){

            @Override
            public SQLRow create() throws SQLException {
                SQLRowValues copy = SQLElement.this.createTransformedCopy(row, full, parent, c);
                copies.put(row, copy);
                SQLElement.this.forDescendantsDo(row, new ChildProcessor<SQLRow>(){

                    @Override
                    public void process(SQLRow parent, SQLField joint, SQLRow desc) throws SQLException {
                        SQLRowValues parentCopy = (SQLRowValues)copies.get(parent);
                        if (parentCopy == null) {
                            throw new IllegalStateException("null copy of " + parent);
                        }
                        SQLRowValues descCopy = SQLElement.this.createTransformedCopy(desc, full, null, c);
                        descCopy.put(joint.getName(), (Object)parentCopy);
                        copies.put(desc, descCopy);
                    }
                }, full, false, false);
                SQLElement.this.forDescendantsDo(row, new ChildProcessor<SQLRow>(){

                    @Override
                    public void process(SQLRow parent, SQLField joint, SQLRow desc) throws SQLException {
                        Map<SQLField, List<SQLRow>> normalReferents = SQLElement.this.getElement(desc.getTable()).getNonChildrenReferents(desc);
                        for (Map.Entry<SQLField, List<SQLRow>> e : normalReferents.entrySet()) {
                            SQLField refField = e.getKey();
                            for (SQLRow ref : e.getValue()) {
                                SQLRowValues refCopy = (SQLRowValues)copies.get(ref);
                                if (refCopy == null) continue;
                                SQLRowValues referencedCopy = (SQLRowValues)copies.get(desc);
                                refCopy.put(refField.getName(), (Object)referencedCopy);
                            }
                        }
                    }
                }, full);
                return copy.insert();
            }
        });
    }

    private final SQLRowValues createTransformedCopy(SQLRow desc, boolean full, SQLRow parent, IClosure<SQLRowValues> c) throws SQLException {
        SQLRowValues copiedVals = this.getElement(desc.getTable()).createCopy(desc, full, parent);
        assert (copiedVals != null) : "failed to copy " + desc;
        if (c != null) {
            c.executeChecked(copiedVals);
        }
        return copiedVals;
    }

    public final SQLRow copy(int id) throws SQLException {
        return this.copy(this.getTable().getRow(id));
    }

    public final SQLRow copy(SQLRow row) throws SQLException {
        return this.copy(row, null);
    }

    public final SQLRow copy(SQLRow row, SQLRow parent) throws SQLException {
        SQLRowValues copy = this.createCopy(row, parent);
        return copy == null ? row : copy.insert();
    }

    public final SQLRowValues createCopy(int id) {
        SQLRow row = this.getTable().getRow(id);
        return this.createCopy(row, null);
    }

    public SQLRowValues createCopy(SQLRowAccessor row, SQLRowAccessor parent) {
        return this.createCopy(row, false, parent);
    }

    public SQLRowValues createCopy(SQLRowAccessor row, boolean full, SQLRowAccessor parent) {
        if (row == null || row.isUndefined()) {
            return null;
        }
        this.check(row);
        SQLRowValues copy = new SQLRowValues(this.getTable());
        this.loadAllSafe(copy, row.asRow());
        for (String privateName : this.getPrivateForeignFields()) {
            boolean deepCopy;
            SQLElement privateElement = this.getPrivateElement(privateName);
            boolean bl = deepCopy = full || !privateElement.dontDeepCopy();
            if (deepCopy && !row.isForeignEmpty(privateName)) {
                SQLRowValues child = privateElement.createCopy(row.getForeign(privateName), full, null);
                copy.put(privateName, (Object)child);
                continue;
            }
            copy.putEmptyLink(privateName);
        }
        if (parent != null) {
            SQLTable foreignTable = this.getParentForeignField().getForeignTable();
            if (!parent.getTable().equals(foreignTable)) {
                throw new IllegalArgumentException(parent + " is not a parent of " + row);
            }
            copy.put(this.getParentForeignFieldName(), parent instanceof SQLRowValues ? parent : parent.getIDNumber());
        }
        return copy;
    }

    public final void loadAllSafe(SQLRowValues vals, SQLRow row) {
        this.check(vals);
        this.check(row);
        vals.setAll(row.getAllValues());
        vals.load(row, this.getNormalForeignFields());
        if (this.getParentForeignFieldName() != null) {
            vals.put(this.getParentForeignFieldName(), row.getObject(this.getParentForeignFieldName()));
        }
        vals.load(row, this.getSharedForeignFields());
    }

    public final ListMap<SQLTable, SQLRow> getDescendants(SQLRow row) {
        this.check(row);
        final ListMap<SQLTable, SQLRow> mm = new ListMap<SQLTable, SQLRow>();
        try {
            this.forDescendantsDo(row, new ChildProcessor<SQLRow>(){

                @Override
                public void process(SQLRow parent, SQLField joint, SQLRow child) throws SQLException {
                    mm.add(joint.getTable(), child);
                }
            }, true);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return mm;
    }

    private SQLRowValues getTree(SQLRow row, boolean archived) {
        this.check(row);
        SQLRowValues res = row.asRowValues();
        try {
            this.forDescendantsDo(res, new ChildProcessor<SQLRowValues>(){

                @Override
                public void process(SQLRowValues parent, SQLField joint, SQLRowValues desc) throws SQLException {
                    desc.put(joint.getName(), (Object)parent);
                }
            }, true, false, archived);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return res;
    }

    public ListMap<SQLTable, SQLRow> getChildrenRows(SQLRow row) {
        this.check(row);
        final ListMap<SQLTable, SQLRow> mm = new ListMap<SQLTable, SQLRow>();
        try {
            this.forChildrenDo(row, new ChildProcessor<SQLRow>(){

                @Override
                public void process(SQLRow parent, SQLField joint, SQLRow child) throws SQLException {
                    mm.add(child.getTable(), child);
                }
            }, true, false);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return mm;
    }

    public SQLRowAccessor getParent(SQLRowAccessor row) {
        this.check(row);
        ArrayList<? extends SQLRowAccessor> parents = new ArrayList<SQLRowAccessor>();
        for (Link l : this.getParentsLinks()) {
            parents.addAll(row.followLink(l));
        }
        if (parents.size() > 1) {
            throw new IllegalStateException("More than one parent for " + row + " : " + parents);
        }
        return parents.size() == 0 ? null : (SQLRowAccessor)parents.get(0);
    }

    public SQLRow getForeignParent(SQLRow row) {
        return this.getForeignParent(row, SQLRowMode.VALID);
    }

    private SQLRow getForeignParent(SQLRow row, SQLRowMode mode) {
        this.check(row);
        return this.getParentForeignFieldName() == null ? null : row.getForeignRow(this.getParentForeignFieldName(), mode);
    }

    public final SQLRowValues getPrivateParent(SQLRowAccessor row, boolean modifyParameter) {
        return this.getPrivateParent(row, modifyParameter, SQLSelect.ArchiveMode.UNARCHIVED);
    }

    public final SQLRowValues getPrivateParent(SQLRowAccessor row, boolean modifyParameter, SQLSelect.ArchiveMode archiveMode) {
        this.check(row);
        ArrayList<SQLField> refFields = new ArrayList<SQLField>(this.getPrivateParentReferentFields());
        if (row.isUndefined() || refFields.size() == 0) {
            return null;
        }
        ListIterator listIter = refFields.listIterator();
        ArrayList<String> selects = new ArrayList<String>(refFields.size());
        while (listIter.hasNext()) {
            SQLField refField = (SQLField)listIter.next();
            SQLSelect sel = new SQLSelect(true).addSelect(refField.getTable().getKey()).addRawSelect(String.valueOf(listIter.previousIndex()), "fieldIndex");
            sel.setArchivedPolicy(archiveMode);
            sel.setWhere(new Where((FieldRef)refField, "=", (Object)row.getIDNumber()));
            selects.add(sel.asString());
        }
        List parentIDs = this.getTable().getDBSystemRoot().getDataSource().executeA(CollectionUtils.join(selects, "\nUNION ALL "));
        if (parentIDs.size() > 1) {
            throw new IllegalStateException("More than one parent for " + row + " : " + parentIDs);
        }
        if (parentIDs.size() == 0) {
            return null;
        }
        Object[] idAndIndex = (Object[])parentIDs.get(0);
        SQLField refField = (SQLField)refFields.get(((Number)idAndIndex[1]).intValue());
        SQLRowValues res = new SQLRowValues(refField.getTable()).setID((Number)idAndIndex[0]);
        res.put(refField.getName(), (Object)(modifyParameter ? row : row.asRow()).asRowValues());
        return res;
    }

    public final SQLRowValues getPrivateRoot(SQLRowAccessor row, SQLSelect.ArchiveMode archiveMode) {
        SQLRowValues prev = null;
        SQLRowValues res = this.getPrivateParent(row, true, archiveMode);
        while (res != null) {
            prev = res;
            res = this.getElement(res.getTable()).getPrivateParent(res, true, archiveMode);
        }
        return prev;
    }

    Map<SQLField, List<SQLRow>> getNonChildrenReferents(SQLRow row) {
        this.check(row);
        HashMap<SQLField, List<SQLRow>> mm = new HashMap<SQLField, List<SQLRow>>();
        HashSet<SQLField> nonChildren = new HashSet<SQLField>(row.getTable().getDBSystemRoot().getGraph().getReferentKeys(row.getTable()));
        nonChildren.removeAll(this.getChildrenReferentFields());
        for (SQLField refField : nonChildren) {
            mm.put(refField, (List<SQLRow>)row.getReferentRows(refField));
        }
        return mm;
    }

    public Map<String, SQLRow> getNormalForeigns(SQLRow row) {
        return this.getNormalForeigns(row, SQLRowMode.DEFINED);
    }

    private Map<String, SQLRow> getNormalForeigns(SQLRow row, SQLRowMode mode) {
        this.check(row);
        HashMap<String, SQLRow> mm = new HashMap<String, SQLRow>();
        for (String ff : this.getNormalForeignFields()) {
            SQLRow foreignRow = row.getForeignRow(ff, mode);
            if (foreignRow == null) continue;
            mm.put(ff, foreignRow);
        }
        return mm;
    }

    public Object getModelObject(SQLRowAccessor row) {
        Object res;
        this.check(row);
        if (this.getModelClass() == null) {
            return null;
        }
        if (row instanceof SQLRow) {
            CacheResult cached = this.getModelCache().check(row);
            if (cached.getState() == CacheResult.State.NOT_IN_CACHE) {
                res = this.createModelObject(row);
                this.getModelCache().put(row, res, Collections.singleton(row));
            } else {
                res = cached.getRes();
            }
        } else {
            res = this.createModelObject(row);
        }
        return res;
    }

    private final Object createModelObject(SQLRowAccessor row) {
        Constructor<? extends RowBacked> ctor;
        if (!RowBacked.class.isAssignableFrom(this.getModelClass())) {
            throw new IllegalStateException("modelClass must inherit from RowBacked: " + this.getModelClass());
        }
        try {
            ctor = this.getModelClass().getConstructor(SQLRowAccessor.class);
        }
        catch (Exception e) {
            throw ExceptionUtils.createExn(IllegalStateException.class, "no SQLRowAccessor constructor", e);
        }
        try {
            return ctor.newInstance(row);
        }
        catch (Exception e) {
            throw ExceptionUtils.createExn(RuntimeException.class, "pb creating instance", e);
        }
    }

    protected Class<? extends RowBacked> getModelClass() {
        return null;
    }

    public boolean equals(SQLRow row, SQLRow row2) {
        return this.equals(row, row2, false);
    }

    public boolean equals(SQLRow row, SQLRow row2, boolean ignoreNotDeepCopied) {
        this.check(row);
        if (!row2.getTable().equals(this.getTable())) {
            return false;
        }
        if (row.equals(row2)) {
            return true;
        }
        if (!row.getAllValues().equals(row2.getAllValues())) {
            return false;
        }
        for (String shared : this.getSharedForeignFields()) {
            if (row.getInt(shared) == row2.getInt(shared)) continue;
            return false;
        }
        for (String prvt : this.getPrivateForeignFields()) {
            SQLElement foreignElement = this.getForeignElement(prvt);
            if (ignoreNotDeepCopied && foreignElement.dontDeepCopy() || foreignElement.equals(row.getForeignRow(prvt), row2.getForeignRow(prvt), ignoreNotDeepCopied)) continue;
            return false;
        }
        return true;
    }

    public boolean equalsRecursive(SQLRow row, SQLRow row2) throws SQLException {
        return this.equalsRecursive(row, row2, false);
    }

    public boolean equalsRecursive(SQLRow row, SQLRow row2, boolean ignoreNotDeepCopied) throws SQLException {
        return new SQLElementRowR(this, row).equals(new SQLElementRowR(this, row2), ignoreNotDeepCopied);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " " + this.getTable().getSQLName();
    }

    public final void addComponentFactory(String id, ITransformer<Tuple2<SQLElement, String>, SQLComponent> t) {
        if (t == null) {
            throw new NullPointerException();
        }
        this.components.add(id, t);
    }

    public final void removeComponentFactory(String id, ITransformer<Tuple2<SQLElement, String>, SQLComponent> t) {
        if (t == null) {
            throw new NullPointerException();
        }
        this.components.remove(id, t);
    }

    private final SQLComponent createComponentFromFactory(String id, boolean defaultItem) {
        String actualID = defaultItem ? DEFAULT_COMP_ID : id;
        Tuple2<SQLElement, String> t = Tuple2.create(this, id);
        Iterator iter = ((LinkedList)this.components.getNonNull(actualID)).descendingIterator();
        while (iter.hasNext()) {
            SQLComponent res = (SQLComponent)((ITransformer)iter.next()).transformChecked(t);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public final SQLComponent createDefaultComponent() {
        return this.createComponent(DEFAULT_COMP_ID);
    }

    public final SQLComponent createComponent(String id) throws IllegalStateException {
        return this.createComponent(id, true);
    }

    public final SQLComponent createComponent(String id, boolean required) throws IllegalStateException {
        SQLComponent res = this.createComponentFromFactory(id, false);
        if (res == null) {
            res = CompareUtils.equals(id, DEFAULT_COMP_ID) ? this.createComponent() : this.createComponentFromFactory(id, true);
        }
        if (res != null) {
            res.setCode(id);
        } else if (required) {
            throw new IllegalStateException("No component for " + id);
        }
        return res;
    }

    protected abstract SQLComponent createComponent();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addToMDPath(String mdVariant) {
        if (mdVariant == null) {
            throw new NullPointerException();
        }
        SQLElement sQLElement = this;
        synchronized (sQLElement) {
            LinkedList<String> newL = new LinkedList<String>(this.mdPath);
            newL.addFirst(mdVariant);
            this.mdPath = Collections.unmodifiableList(newL);
        }
    }

    public final synchronized void removeFromMDPath(String mdVariant) {
        LinkedList<String> newL = new LinkedList<String>(this.mdPath);
        if (newL.remove(mdVariant)) {
            this.mdPath = Collections.unmodifiableList(newL);
        }
    }

    public final synchronized List<String> getMDPath() {
        return this.mdPath;
    }

    public final boolean putAdditionalField(String field) {
        return this.putAdditionalField(field, (JComponent)null);
    }

    public final boolean putAdditionalField(String field, JTextComponent comp) {
        return this.putAdditionalField(field, (JComponent)comp);
    }

    public final boolean putAdditionalField(String field, SQLTextCombo comp) {
        return this.putAdditionalField(field, (JComponent)comp);
    }

    private final boolean putAdditionalField(String field, JComponent comp) {
        if (this.additionalFields.containsKey(field)) {
            return false;
        }
        this.additionalFields.put(field, comp);
        return true;
    }

    public final Map<String, JComponent> getAdditionalFields() {
        return Collections.unmodifiableMap(this.additionalFields);
    }

    public final void removeAdditionalField(String field) {
        this.additionalFields.remove(field);
    }

    public final boolean askArchive(Component comp, Number ids) {
        return this.askArchive(comp, Collections.singleton(ids));
    }

    public boolean askArchive(Component comp, Collection<? extends Number> ids) {
        boolean shouldArchive = false;
        int rowCount = ids.size();
        if (rowCount == 0) {
            return true;
        }
        try {
            if (!UserRightsManager.getCurrentUserRights().canDelete(this.getTable())) {
                throw new SQLException("forbidden");
            }
            TreesOfSQLRows trees = TreesOfSQLRows.createFromIDs(this, ids);
            Map<SQLTable, List<SQLRowAccessor>> descs = trees.getDescendantsByTable();
            SortedMap<SQLField, Integer> externRefs = trees.getExternReferencesCount();
            String confirmDelete = TM.getTM().trA("sqlElement.confirmDelete", new Object[0]);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("rowCount", rowCount);
            int descsSize = descs.size();
            int externsSize = externRefs.size();
            if (descsSize + externsSize > 0) {
                String descsS = descsSize > 0 ? this.toString(descs) : null;
                String externsS = externsSize > 0 ? this.toStringExtern(externRefs) : null;
                map.put("descsSize", descsSize);
                map.put("descs", descsS);
                map.put("externsSize", externsSize);
                map.put("externs", externsS);
                map.put("times", "once");
                int i = this.askSerious(comp, String.valueOf(TM.getTM().trM("sqlElement.deleteRef.details", map)) + TM.getTM().trM("sqlElement.deleteRef", map), confirmDelete);
                if (i == 0) {
                    map.put("times", "twice");
                    String msg = externsSize > 0 ? TM.getTM().trM("sqlElement.deleteRef.details2", map) : "";
                    i = this.askSerious(comp, String.valueOf(msg) + TM.getTM().trM("sqlElement.deleteRef", map), confirmDelete);
                    if (i == 0) {
                        shouldArchive = true;
                    } else {
                        JOptionPane.showMessageDialog(comp, TM.getTM().trA("sqlElement.noLinesDeleted", new Object[0]), TM.getTM().trA("sqlElement.noLinesDeletedTitle", new Object[0]), 1);
                    }
                }
            } else {
                int i = this.askSerious(comp, TM.getTM().trM("sqlElement.deleteNoRef", map), confirmDelete);
                if (i == 0) {
                    shouldArchive = true;
                }
            }
            if (shouldArchive) {
                this.archive(trees, true);
                return true;
            }
            return false;
        }
        catch (SQLException e) {
            ExceptionHandler.handle(comp, TM.tr("sqlElement.archiveError", this, ids), e);
            return false;
        }
    }

    private final String toString(Map<SQLTable, List<SQLRowAccessor>> descs) {
        ArrayList<String> l = new ArrayList<String>(descs.size());
        for (Map.Entry<SQLTable, List<SQLRowAccessor>> e : descs.entrySet()) {
            SQLTable t = e.getKey();
            SQLElement elem = this.getElement(t);
            l.add(SQLElement.elemToString(e.getValue().size(), elem));
        }
        return CollectionUtils.join(l, "\n");
    }

    private static final String elemToString(int count, SQLElement elem) {
        return "- " + elem.getName().getNumeralVariant(count, Grammar.INDEFINITE_NUMERAL);
    }

    private final String toStringExtern(SortedMap<SQLField, Integer> externRef) {
        ArrayList<String> l = new ArrayList<String>();
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        for (Map.Entry<SQLField, Integer> entry : externRef.entrySet()) {
            SQLField foreignKey = entry.getKey();
            int count = entry.getValue();
            String label = Configuration.getTranslator(foreignKey.getTable()).getLabelFor(foreignKey);
            SQLElement elem = this.getElement(foreignKey.getTable());
            map.put("elementName", elem.getName());
            map.put("count", count);
            map.put("linkName", label);
            l.add(TM.getTM().trM("sqlElement.linksWillBeCut", map));
        }
        return CollectionUtils.join(l, "\n");
    }

    private final int askSerious(Component comp, String msg, String title) {
        return JOptionPane.showConfirmDialog(comp, msg, String.valueOf(title) + " (" + this.getPluralName() + ")", 0, 2);
    }

    static interface ChildProcessor<R extends SQLRowAccessor> {
        public void process(R var1, SQLField var2, R var3) throws SQLException;
    }

    public static enum ReferenceAction {
        SET_EMPTY,
        CASCADE,
        RESTRICT;

    }
}

