/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.changer.correct;

import java.sql.SQLException;
import java.util.List;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.changer.Changer;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.utils.SQLUtils;

public class FixSharedPrivate
extends Changer<SQLTable> {
    private final SQLElementDirectory dir;

    public FixSharedPrivate(DBSystemRoot b) {
        this(b, null);
    }

    public FixSharedPrivate(DBSystemRoot b, SQLElementDirectory dir) {
        super(b);
        if (dir == null) {
            if (Configuration.getInstance() == null) {
                throw new IllegalStateException("no conf");
            }
            this.dir = Configuration.getInstance().getDirectory();
            if (this.dir == null) {
                throw new IllegalStateException("no directory in conf");
            }
        } else {
            this.dir = dir;
        }
        assert (this.dir != null);
    }

    public final SQLElementDirectory getDir() {
        return this.dir;
    }

    @Override
    protected void changeImpl(final SQLTable t) throws SQLException {
        this.getStream().print(t);
        SQLElement elem = this.getDir().getElement(t);
        if (elem == null) {
            this.getStream().println(" : no element");
            return;
        }
        this.getStream().println("... ");
        for (final String pff : elem.getPrivateForeignFields()) {
            final SQLElement privateElement = elem.getPrivateElement(pff);
            SQLTable privateTable = privateElement.getTable();
            SQLSelect sel = new SQLSelect();
            sel.setArchivedPolicy(SQLSelect.ArchiveMode.BOTH);
            sel.addSelect(privateTable.getKey());
            sel.addBackwardJoin("INNER", "m", t.getField(pff), null);
            String req = String.valueOf(sel.asString()) + " GROUP BY " + privateTable.getKey().getFieldRef() + " HAVING count(" + privateTable.getKey().getFieldRef() + ")>1";
            final List privateIDs = t.getDBSystemRoot().getDataSource().executeCol(req);
            if (privateIDs.size() <= 0) continue;
            this.getStream().println("\t" + pff + " fixing " + privateIDs.size() + " ... ");
            final SQLField archF = t.getArchiveField();
            final SQLField privateArchF = privateTable.getArchiveField();
            if (archF == null != (privateArchF == null)) {
                throw new IllegalStateException("Incoherent archive field : " + archF + " / " + privateArchF);
            }
            SQLUtils.executeAtomic(t.getDBSystemRoot().getDataSource(), new SQLUtils.SQLFactory<Object>(){

                @Override
                public Object create() throws SQLException {
                    for (Number privateID : privateIDs) {
                        SQLSelect fixSel = new SQLSelect();
                        fixSel.setArchivedPolicy(SQLSelect.ArchiveMode.BOTH);
                        fixSel.addSelect(t.getKey());
                        if (archF != null) {
                            fixSel.addSelect(archF);
                        }
                        fixSel.setWhere(new Where((FieldRef)t.getField(pff), "=", (Object)privateID));
                        List<SQLRow> tIDs = SQLRowListRSH.execute(fixSel);
                        for (SQLRow tID : tIDs) {
                            SQLRowValues reallyPrivate = tID == tIDs.get(0) ? new SQLRowValues(privateElement.getTable()).setID(privateID) : privateElement.createCopy(privateID.intValue());
                            if (archF != null) {
                                reallyPrivate.put(privateArchF.getName(), tID.getObject(archF.getName()));
                            }
                            new SQLRowValues(t).setID(tID.getIDNumber()).put(pff, (Object)reallyPrivate).update();
                        }
                    }
                    return null;
                }
            });
        }
        this.getStream().println(t + " done");
    }
}

