/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.changer.correct;

import java.sql.SQLException;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.changer.Changer;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;

public class DeleteOrphans
extends Changer<SQLTable> {
    public DeleteOrphans(DBSystemRoot b) {
        super(b);
    }

    @Override
    protected void changeImpl(SQLTable t) throws SQLException {
        if (Configuration.getInstance() == null || Configuration.getInstance().getDirectory() == null) {
            throw new IllegalStateException("no directory");
        }
        this.getStream().print(t);
        SQLElement elem = Configuration.getInstance().getDirectory().getElement(t);
        if (elem == null) {
            this.getStream().println(" : no element");
            return;
        }
        SQLField parentF = elem.getParentForeignField();
        if (parentF != null) {
            SQLTable elemT = elem.getTable();
            Where undefParent = new Where((FieldRef)parentF, "=", parentF.getForeignTable().getUndefinedID());
            Where undefW = new Where((FieldRef)elemT.getKey(), "!=", elemT.getUndefinedID());
            this.getDS().execute("DELETE from " + elemT.getSQLName().quote() + " where " + undefParent.and(undefW));
            this.getStream().println(" done");
        } else {
            this.getStream().println(" no parent");
        }
    }
}

