/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.changer.convert;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openconcerto.sql.changer.Changer;
import org.openconcerto.sql.model.AliasedTable;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBStructureItem;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSchema;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.DatabaseGraph;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.model.graph.TablesMap;
import org.openconcerto.sql.request.UpdateBuilder;
import org.openconcerto.sql.utils.AlterTable;
import org.openconcerto.sql.utils.ChangeTable;
import org.openconcerto.sql.utils.SQLCreateTable;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.cc.ITransformer;

public class MergeTable
extends Changer<SQLTable> {
    public static final String MERGE_DEST_TABLE = "merge.destTable";
    private SQLTable destTable = null;
    private final Set<List<String>> forceFF = new HashSet<List<String>>();

    public MergeTable(DBSystemRoot b) {
        super(b);
    }

    public final void setDestTable(SQLTable destTable) {
        this.destTable = destTable;
    }

    public final void forceFF(String ff) {
        this.forceFF(Collections.singletonList(ff));
    }

    public final void forceFF(List<String> cols) {
        this.forceFF.add(cols);
    }

    @Override
    protected Class<? extends DBStructureItem<?>> getMaxLevel() {
        return SQLTable.class;
    }

    @Override
    public void setUpFromSystemProperties() {
        super.setUpFromSystemProperties();
        String prop = System.getProperty(MERGE_DEST_TABLE);
        if (prop == null) {
            throw new IllegalStateException("the system property merge.destTable is not defined");
        }
        this.setDestTable(this.getSystemRoot().getDesc(prop, SQLTable.class));
    }

    @Override
    protected void changeImpl(final SQLTable t) throws SQLException {
        this.getStream().println("merging " + t.getSQLName() + " into " + this.destTable.getSQLName() + "... ");
        if (!this.destTable.getChildrenNames().containsAll(t.getChildrenNames())) {
            throw new IllegalArgumentException(this.destTable.getSQLName() + " lacks " + CollectionUtils.substract(t.getChildrenNames(), this.destTable.getChildrenNames()));
        }
        String noLink = t.equalsChildrenNoLink(this.destTable, null);
        if (noLink != null) {
            throw new IllegalArgumentException(noLink);
        }
        ArrayList<SQLField> fieldsNoPKNoOrder = new ArrayList<SQLField>(t.getFields());
        fieldsNoPKNoOrder.remove(t.getKey());
        SQLField orderF = t.getOrderField();
        fieldsNoPKNoOrder.remove(orderF);
        fieldsNoPKNoOrder.add(orderF);
        final String fields = "(" + CollectionUtils.join(fieldsNoPKNoOrder, ",", new ITransformer<SQLField, String>(){

            @Override
            public String transformChecked(SQLField input) {
                return SQLBase.quoteIdentifier(input.getName());
            }
        }) + ")";
        final SQLSelect sel = this.createSelect(t);
        fieldsNoPKNoOrder.remove(fieldsNoPKNoOrder.size() - 1);
        sel.addAllSelect(fieldsNoPKNoOrder);
        sel.addRawSelect(t.getBase().quote("%n + ( SELECT MAX(%n)+100 FROM %f ) ", orderF, this.destTable.getOrderField(), this.destTable), null);
        SQLSelect selOldIDs = this.createSelect(t);
        selOldIDs.addSelect(t.getKey());
        final List oldIDs = this.getDS().executeCol(selOldIDs.asString());
        boolean noRowsToMerge = oldIDs.size() == 0;
        final DatabaseGraph graph = t.getDBSystemRoot().getGraph();
        final HashSet<Link> selfRefLinks = new HashSet<Link>();
        for (Link l : graph.getForeignLinks(t)) {
            Link destLink = graph.getForeignLink(this.destTable, l.getCols());
            if (destLink == null) {
                throw new IllegalStateException("No link for " + l.getCols() + " in " + this.destTable.getSQL());
            }
            SQLTable destTableTarget = (SQLTable)destLink.getTarget();
            if (destTableTarget == destLink.getSource()) {
                selfRefLinks.add(destLink);
                continue;
            }
            if (destTableTarget == l.getTarget()) continue;
            String s = "Not pointing to the same table for " + l + " " + destTableTarget.getSQL() + " != " + ((SQLTable)l.getTarget()).getSQL();
            ArrayList<String> reasonsToContinue = new ArrayList<String>();
            if (noRowsToMerge) {
                reasonsToContinue.add("but source table is empty");
            }
            if (((SQLTable)l.getTarget()).getRowCount(false) == 0) {
                reasonsToContinue.add("but the link target is empty");
            }
            if (this.forceFF.contains(l.getCols())) {
                reasonsToContinue.add("but link is forced");
            }
            if (reasonsToContinue.size() == 0) {
                throw new IllegalStateException(s);
            }
            this.getStream().println("WARNING: " + s);
            this.getStream().println(CollectionUtils.join(reasonsToContinue, ";\n"));
        }
        final SQLSyntax syntax = t.getServer().getSQLSystem().getSyntax();
        final HashSet toRefresh = new HashSet();
        SQLUtils.executeAtomic(t.getDBSystemRoot().getDataSource(), new ConnectionHandlerNoSetup<Object, SQLException>(){

            @Override
            public Object handle(SQLDataSource ds) throws SQLException {
                AlterTable dropSelfFK = new AlterTable(MergeTable.this.destTable);
                for (Link selfRef : selfRefLinks) {
                    dropSelfFK.dropForeignConstraint(selfRef.getName());
                }
                if (!dropSelfFK.isEmpty()) {
                    ds.execute(dropSelfFK.asString());
                }
                List<Number> insertedIDs = SQLRowValues.insertIDs(MergeTable.this.destTable, String.valueOf(fields) + " " + sel.asString());
                insertedIDs.add(0, MergeTable.this.destTable.getUndefinedIDNumber());
                oldIDs.add(0, t.getUndefinedIDNumber());
                int size = insertedIDs.size();
                if (size != oldIDs.size()) {
                    throw new IllegalStateException("size mismatch: " + size + " != " + oldIDs.size());
                }
                SQLName mapName = new SQLName(t.getDBRoot().getName(), "MAP_" + MergeTable.class.getSimpleName() + System.currentTimeMillis());
                SQLCreateTable createTable = new SQLCreateTable(t.getDBRoot(), mapName.getName());
                createTable.setPlain(true);
                createTable.addColumn("OLD_ID", syntax.getIDType());
                createTable.addColumn("NEW_ID", syntax.getIDType());
                ds.execute(createTable.asString());
                SQLTable mapT = t.getDBRoot().refetchTable(mapName.getName());
                StringBuilder sb = new StringBuilder();
                int i = 0;
                while (i < size) {
                    sb.append("(" + oldIDs.get(i) + ", " + insertedIDs.get(i) + ")");
                    if (i < size - 1) {
                        sb.append(",");
                    }
                    ++i;
                }
                ds.execute(t.getBase().quote("INSERT INTO %i(%i, %i) VALUES" + sb, mapName, "OLD_ID", "NEW_ID"));
                for (Link selfRef : selfRefLinks) {
                    toRefresh.add(this.updateLink(selfRef, mapT));
                }
                for (Link refLink : graph.getReferentLinks(t)) {
                    if (refLink.getSource() == t) continue;
                    toRefresh.add(this.updateLink(refLink, mapT));
                }
                ds.execute(t.getBase().quote("DROP TABLE %f", t));
                ds.execute("DROP TABLE " + mapName.quote());
                toRefresh.add(t);
                toRefresh.add(mapT);
                return null;
            }

            public SQLTable updateLink(Link refLink, SQLTable mapT) {
                boolean selfLink;
                SQLField refKey = refLink.getLabel();
                SQLTable refTable = refKey.getTable();
                SQLDataSource ds = refTable.getDBSystemRoot().getDataSource();
                boolean bl = selfLink = refLink.getSource() == refLink.getTarget();
                if (!$assertionsDisabled && refTable == t) {
                    throw new AssertionError();
                }
                if (!selfLink && refLink.getName() != null) {
                    AlterTable dropFK = new AlterTable(refTable);
                    dropFK.dropForeignConstraint(refLink.getName());
                    ds.execute(dropFK.asString());
                }
                UpdateBuilder update = new UpdateBuilder(refTable);
                AliasedTable alias1 = new AliasedTable(mapT, "m");
                update.addTable(alias1);
                update.set(refKey.getName(), alias1.getField("NEW_ID").getFieldRef());
                update.setWhere(new Where((FieldRef)refKey, Where.NULL_IS_DATA_EQ, alias1.getField("OLD_ID")));
                if (selfLink) {
                    AliasedTable onlyNew = new AliasedTable(mapT, "onlyNew");
                    update.addTable(onlyNew);
                    Where w = new Where((FieldRef)refTable.getKey(), Where.NULL_IS_DATA_EQ, onlyNew.getField("NEW_ID")).and(new Where((FieldRef)refTable.getKey(), Where.NULL_IS_DATA_NEQ, (Object)refTable.getUndefinedIDNumber()));
                    update.setWhere(update.getWhere().and(w));
                }
                ds.execute(update.asString());
                AlterTable addFK = new AlterTable(refTable);
                addFK.addForeignConstraint(ChangeTable.FCSpec.createFromLink(refLink, MergeTable.this.destTable), false);
                ds.execute(addFK.asString());
                return refTable;
            }
        });
        TablesMap tables = new TablesMap();
        HashSet<SQLSchema> schemas = new HashSet<SQLSchema>();
        for (SQLTable table : toRefresh) {
            tables.add(table.getDBRoot().getName(), table.getName());
            schemas.add(table.getSchema());
        }
        t.getDBSystemRoot().refresh(tables, false);
        for (SQLSchema schema : schemas) {
            schema.updateVersion();
        }
    }

    private final SQLSelect createSelect(SQLTable t) {
        SQLSelect sel = new SQLSelect(true);
        sel.setExcludeUndefined(true);
        sel.addFieldOrder(t.getOrderField());
        return sel;
    }
}

