/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openconcerto.sql.FieldExpander;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBStructureItemNotFound;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.CollectionUtils;

public class ShowAs
extends FieldExpander {
    private DBRoot root;
    private final Map<SQLTable, List<SQLField>> byTables = new HashMap<SQLTable, List<SQLField>>();
    private final Map<SQLField, List<SQLField>> byFields = new HashMap<SQLField, List<SQLField>>();

    public ShowAs(DBRoot root) {
        this.setRoot(root);
    }

    public ShowAs(ShowAs src) {
        this(src.getRoot());
        this.putAll(src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void putAll(ShowAs s) {
        ShowAs showAs = this;
        synchronized (showAs) {
            ShowAs showAs2 = s;
            synchronized (showAs2) {
                CollectionUtils.addIfNotPresent(this.byFields, s.byFields);
                CollectionUtils.addIfNotPresent(this.byTables, s.byTables);
            }
            this.clearCache();
        }
    }

    public synchronized List<SQLField> getFieldExpand(SQLTable table) {
        return this.byTables.get(table);
    }

    public final synchronized void setRoot(DBRoot root) {
        this.root = root;
    }

    public final synchronized DBRoot getRoot() {
        return this.root;
    }

    private synchronized SQLField getField(String fieldName) {
        return this.root.getDesc(SQLName.parse(fieldName), SQLField.class);
    }

    private synchronized SQLTable getTable(String tableName) {
        try {
            return this.root.getDesc(SQLName.parse(tableName), SQLTable.class);
        }
        catch (DBStructureItemNotFound e) {
            return null;
        }
    }

    private static final List<SQLField> namesToFields(List<String> names, SQLTable table) {
        ArrayList<SQLField> res = new ArrayList<SQLField>(names.size());
        for (String fieldName : names) {
            res.add(table.getField(fieldName));
        }
        return res;
    }

    public final synchronized void removeTable(SQLTable t) {
        this.byTables.remove(t);
        Iterator<Map.Entry<SQLField, List<SQLField>>> iterator = this.byFields.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<SQLField, List<SQLField>> e = iterator.next();
            if (e.getKey().getTable().equals(t)) {
                iterator.remove();
                continue;
            }
            SQLField f = CollectionUtils.getFirst(e.getValue());
            if (f == null || !f.getTable().equals(t)) continue;
            iterator.remove();
        }
        this.clearCache();
    }

    public final synchronized void clear() {
        this.setRoot(null);
        this.byTables.clear();
        this.byFields.clear();
        this.clearCache();
    }

    public void show(String tableName, String ... fields) {
        this.show(tableName, Arrays.asList(fields));
    }

    public synchronized void show(String tableName, List<String> fields) {
        SQLTable table = this.getTable(tableName);
        if (table != null) {
            this.show(table, fields);
        } else {
            Log.get().warning(this.root + " does not contain the table:" + tableName);
        }
    }

    public void show(SQLTable table, String ... fields) {
        this.show(table, Arrays.asList(fields));
    }

    public synchronized void show(SQLTable table, List<String> fields) {
        this.byTables.put(table, ShowAs.namesToFields(fields, table));
        this.clearCache();
    }

    public void showField(String fieldName, String ... fields) {
        this.showField(fieldName, Arrays.asList(fields));
    }

    public synchronized void showField(String fieldName, List<String> fields) {
        this.show(this.getField(fieldName), fields);
    }

    public final synchronized void show(SQLField field, List<String> fields) {
        this.byFields.put(field, ShowAs.namesToFields(fields, field.getTable().getBase().getGraph().getForeignTable(field)));
        this.clearCache();
    }

    @Override
    protected synchronized List<SQLField> expandOnce(SQLField field) {
        List<SQLField> res;
        SQLTable foreignTable = field.getTable().getBase().getGraph().getForeignTable(field);
        if (this.byFields.containsKey(field)) {
            res = this.byFields.get(field);
        } else if (this.byTables.containsKey(foreignTable)) {
            res = this.byTables.get(foreignTable);
        } else {
            throw new IllegalStateException(field + " cannot be expanded by " + this + "\nforeign table of " + field.getSQLName() + ":" + foreignTable.getSQLName());
        }
        return res;
    }

    public synchronized List<SQLField> simpleExpand(String fieldName) {
        return this.simpleExpand(this.getField(fieldName));
    }

    public synchronized String toString() {
        return String.valueOf(super.toString()) + " byTables: " + this.byTables + " byFields: " + this.byFields;
    }
}

