/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.State;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.ExceptionUtils;

public final class RemoteShell
extends Thread {
    public static final String START_DEFAULT_SERVER = "org.openconcerto.sql.RemoteShell";
    public static final int PORT = 1394;
    private static RemoteShell INSTANCE = null;
    private PrintWriter out;
    private Thread thread;
    private final ScriptEngine engine;
    private final Bindings ognlCtxt;

    public static final synchronized boolean startDefaultInstance() {
        if (INSTANCE == null && Boolean.getBoolean(START_DEFAULT_SERVER)) {
            RemoteShell.setDefaultInstance(new RemoteShell());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setDefaultInstance(RemoteShell i) {
        if (i.getState() == Thread.State.TERMINATED) {
            throw new IllegalArgumentException("Dead shell : " + i);
        }
        Class<RemoteShell> clazz = RemoteShell.class;
        synchronized (RemoteShell.class) {
            INSTANCE = i;
            if (i.getState() == Thread.State.NEW) {
                i.start();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static final synchronized RemoteShell getDefaultInstance() {
        return INSTANCE;
    }

    public RemoteShell() {
        super(String.valueOf(RemoteShell.class.getSimpleName()) + " (not started)");
        this.setDaemon(true);
        this.engine = new ScriptEngineManager().getEngineByName("javascript");
        this.ognlCtxt = new SimpleBindings();
    }

    private Bindings getContext() {
        this.ognlCtxt.put("base", (Object)this.getBase());
        this.ognlCtxt.put("dir", (Object)Configuration.getInstance().getDirectory());
        return this.ognlCtxt;
    }

    private ServerSocket createSocket() {
        ServerSocket serverSocket = null;
        int port = 1394;
        while (serverSocket == null) {
            try {
                serverSocket = new ServerSocket(port);
                Log.get().info("listening on " + port);
                this.setName(String.valueOf(RemoteShell.class.getSimpleName()) + " on port " + port);
            }
            catch (BindException e) {
                Log.get().config("port " + port + " already in use");
                ++port;
            }
            catch (IOException e) {
                Log.get().warning("cannot create a socket");
                e.printStackTrace();
                return null;
            }
        }
        return serverSocket;
    }

    @Override
    public void run() {
        ServerSocket serverSocket = this.createSocket();
        if (serverSocket == null) {
            return;
        }
        while (true) {
            try {
                while (true) {
                    String inputLine;
                    Socket clientSocket = serverSocket.accept();
                    Log.get().info("accepted");
                    BufferedReader in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
                    this.out = new PrintWriter(clientSocket.getOutputStream(), true);
                    this.out.println("Console d'administration: " + clientSocket.getLocalSocketAddress() + " <-> " + clientSocket.getRemoteSocketAddress());
                    this.out.println("help (ou h) pour l'aide");
                    this.out.println("quit (ou q) pour quitter");
                    this.out.flush();
                    while ((inputLine = in.readLine()) != null) {
                        if (inputLine.equals("q") || inputLine.startsWith("quit")) break;
                        if (inputLine.equals("h") || inputLine.startsWith("help")) {
                            this.printHelp();
                        }
                        try {
                            this.out.println(this.getAnswer(inputLine));
                        }
                        catch (Exception exn) {
                            exn.printStackTrace();
                            exn.printStackTrace(this.out);
                        }
                        this.out.print(">");
                        this.out.flush();
                    }
                    in.close();
                    if (this.thread != null) {
                        this.thread.interrupt();
                    }
                    this.out.close();
                    clientSocket.close();
                    Log.get().info("closed");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void printHelp() {
        this.out.println("Commandes possibles:");
        this.out.println("req     : affiche la liste des requ\u00eates en cours");
        this.out.println("all     : affiche les stats du logiciels");
        this.out.println("gc      : lance le garbage collector");
        this.out.println("log LEVEL [loggerName] : d\u00e9finit un niveau de log");
        this.out.println("unarchive TABLE ID     : d\u00e9sarchive un \u00e9l\u00e9ment d'une table (et propage le desarchivage)");
        this.out.println("\t ex: unarchive SITE 125 va d\u00e9sarchiver BATIMENTs etc...");
        this.out.println("set    : d\u00e9finit une variable OGNL ou affiche la liste");
        this.out.println("\t ex: set siteT base.getTable('SITE')");
        this.out.println("eval   : evalue une expression OGNL");
        this.out.println("\t ex: #siteT.getRow(123).getReferentRows()");
        this.out.println();
        this.out.flush();
    }

    private String getAnswer(String question) throws SQLException {
        if ((question = question.trim()).equals("req")) {
            return State.INSTANCE.getRequests().toString();
        }
        if (question.equals("all")) {
            return State.INSTANCE.getFull();
        }
        if (question.equals("gc")) {
            System.gc();
            return "System.gc() called.";
        }
        if (question.startsWith("log")) {
            Level l;
            String[] args = question.split(" ");
            String level = args[1];
            try {
                Field f = Level.class.getField(level);
                l = (Level)f.get(null);
            }
            catch (Exception e) {
                return "cannot get field '" + level + "' of Level";
            }
            String name = args.length > 2 ? args[2] : "";
            Logger.getLogger(name).setLevel(l);
            return "logger '" + name + "' level set to " + l.getName();
        }
        if (question.equals("allc")) {
            this.thread = new Thread(){

                @Override
                public void run() {
                    int i = 0;
                    while (true) {
                        RemoteShell.this.out.println("--------------");
                        RemoteShell.this.out.println("Iteration: " + i++);
                        RemoteShell.this.out.println("--------------");
                        RemoteShell.this.out.println(State.INSTANCE.getFull());
                        RemoteShell.this.out.println("\n");
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                }
            };
            this.thread.start();
            return "beginning";
        }
        if (question.startsWith("unarchive")) {
            return this.archive(question, false);
        }
        if (question.startsWith("archive")) {
            return this.archive(question, true);
        }
        if (question.startsWith("eval")) {
            try {
                return this.ognlResult(this.eval(question.substring("eval".length())));
            }
            catch (ScriptException e) {
                return ExceptionUtils.getStackTrace(e);
            }
        }
        if (question.startsWith("set")) {
            String[] args = question.split(" ", 3);
            if (args.length == 1) {
                return CollectionUtils.join(this.ognlCtxt.entrySet(), "\n");
            }
            try {
                Object res = this.eval(args[2]);
                this.ognlCtxt.put(args[1], res);
                return this.ognlResult(res);
            }
            catch (ScriptException e) {
                return ExceptionUtils.getStackTrace(e);
            }
        }
        return "commande non connue.";
    }

    private String archive(String question, boolean arch) throws SQLException {
        String s;
        String[] args = question.split(" ");
        String tableName = args[1];
        int id = Integer.parseInt(args[2]);
        if (arch) {
            this.getElement(tableName).archive(id);
            s = "archived";
        } else {
            this.getElement(tableName).unarchive(id);
            s = "unarchived";
        }
        return String.valueOf(s) + " " + this.getBase().getTable(tableName).getRow(id);
    }

    public final Object eval(String s) throws ScriptException {
        return this.engine.eval(s, this.getContext());
    }

    private String ognlResult(Object res) {
        return res == null ? "<no result>" : res.toString();
    }

    private final SQLBase getBase() {
        return Configuration.getInstance().getBase();
    }

    private final SQLElement getElement(String tableName) {
        return Configuration.getInstance().getDirectory().getElement(tableName);
    }

    public void put(String s, Object val) {
        this.ognlCtxt.put(s, val);
    }
}

