/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.rights;

import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openconcerto.erp.rights.GroupItemUIComboItem;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.users.rights.RightEditor;
import org.openconcerto.sql.users.rights.RightEditorManager;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.component.ComboLockedMode;
import org.openconcerto.ui.component.combo.ISearchableCombo;
import org.openconcerto.ui.group.Group;
import org.openconcerto.ui.list.DefaultMutableListModel;
import org.openconcerto.utils.model.DefaultIMutableListModel;

public class GroupUIComboRightEditor
implements RightEditor {
    public static final String ID_RIGHT = "GROUP_ITEM_SHOW";

    @Override
    public void setValueEditor(String object, JComponent editorComponent) {
        SQLField f = Configuration.getInstance().getFieldMapper().getSQLFieldForItem(object);
        if (f != null) {
            ((PanelGroupUIChooser)editorComponent).getBoxTable().setValue(new SQLElementComboItem(Configuration.getInstance().getDirectory().getElement(f.getTable().getName())));
            ((PanelGroupUIChooser)editorComponent).getComboMenu().setValue(new GroupItemUIComboItem(object, Configuration.getInstance().getDirectory().getElement(f.getTable().getName())));
        } else if (object != null && object.trim().length() > 0 && object.contains(".")) {
            String tableName = object.substring(0, object.indexOf(46));
            if (Configuration.getInstance().getRoot().findTable(tableName) != null) {
                String fieldName = object.substring(object.indexOf(46) + 1, object.length());
                SQLElement element = Configuration.getInstance().getDirectory().getElement(tableName);
                ((PanelGroupUIChooser)editorComponent).getBoxTable().setValue(new SQLElementComboItem(element));
                ((PanelGroupUIChooser)editorComponent).getComboMenu().setValue(new GroupItemUIComboItem(fieldName, element));
            }
        }
    }

    @Override
    public JComponent getComponentEditor(String right, JTextField fieldObject) {
        return new PanelGroupUIChooser(fieldObject);
    }

    public static void register() {
        RightEditorManager.getInstance().register(ID_RIGHT, new GroupUIComboRightEditor());
    }

    private class PanelGroupUIChooser
    extends JPanel {
        final ISearchableCombo<SQLElementComboItem> boxTable;
        final ISearchableCombo<GroupItemUIComboItem> comboMenu;

        public PanelGroupUIChooser(final JTextField fieldObject) {
            super(new GridBagLayout());
            DefaultGridBagConstraints c = new DefaultGridBagConstraints();
            c.gridx = -1;
            c.weightx = 1.0;
            this.boxTable = new ISearchableCombo(ComboLockedMode.UNLOCKED, 0, 20);
            DefaultIMutableListModel<SQLElementComboItem> comboItems = new DefaultIMutableListModel<SQLElementComboItem>();
            Collection<SQLElement> elts = Configuration.getInstance().getDirectory().getElements();
            for (SQLElement sqlElement : elts) {
                if (sqlElement.getDefaultGroup() == null) continue;
                comboItems.addElement(new SQLElementComboItem(sqlElement));
            }
            this.boxTable.initCache(comboItems);
            this.add(this.boxTable);
            this.comboMenu = new ISearchableCombo(ComboLockedMode.UNLOCKED, 0, 20);
            final DefaultMutableListModel cache = new DefaultMutableListModel();
            this.comboMenu.initCache(cache);
            this.boxTable.addValueListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Group g;
                    SQLElement element;
                    cache.removeAllElements();
                    SQLElementComboItem selectedItem = PanelGroupUIChooser.this.boxTable.getSelectedItem();
                    if (selectedItem != null && (element = selectedItem.getSQLElement()) != null && (g = element.getDefaultGroup()) != null) {
                        cache.addAll(GroupItemUIComboItem.getComboMenu(g, element));
                    }
                }
            });
            this.comboMenu.addValueListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    SQLElementComboItem selectedElement;
                    GroupItemUIComboItem selectedItem = PanelGroupUIChooser.this.comboMenu.getSelectedItem();
                    if (selectedItem != null && (selectedElement = PanelGroupUIChooser.this.boxTable.getSelectedItem()) != null) {
                        SQLTable table = selectedElement.getSQLElement().getTable();
                        if (table.contains(selectedItem.getId())) {
                            fieldObject.setText(String.valueOf(table.getName()) + "." + table.getField(selectedItem.getId()).getName());
                        } else {
                            fieldObject.setText(selectedItem.getId());
                        }
                    }
                }
            });
            this.add(this.comboMenu);
        }

        public ISearchableCombo<GroupItemUIComboItem> getComboMenu() {
            return this.comboMenu;
        }

        public ISearchableCombo<SQLElementComboItem> getBoxTable() {
            return this.boxTable;
        }
    }

    private class SQLElementComboItem {
        private final SQLElement elt;

        public SQLElementComboItem(SQLElement elt) {
            this.elt = elt;
        }

        public SQLElement getSQLElement() {
            return this.elt;
        }

        public String toString() {
            return this.elt.getPluralName();
        }
    }
}

