/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.erp.modules.FactoriesByID;
import org.openconcerto.erp.modules.ModuleFactory;
import org.openconcerto.erp.modules.ModuleManager;
import org.openconcerto.erp.modules.ModuleReference;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.Tuple2;

final class InstallationState {
    public static final InstallationState NOTHING = new InstallationState();
    private final Set<ModuleReference> installedLocally;
    private final Set<ModuleReference> installedRemotely;
    private final Set<ModuleReference> localAndRemote;
    private final Set<ModuleReference> localOrRemote;
    private final boolean missingFactories;
    private final Map<String, ModuleFactory> installedFactories;

    private static <T> Set<T> copySet(Collection<T> s) {
        return Collections.unmodifiableSet(new LinkedHashSet<T>(s));
    }

    private InstallationState() {
        this(Collections.emptySet(), Collections.emptySet(), null);
    }

    public InstallationState(ModuleManager mngr) throws SQLException, IOException {
        this(InstallationState.copySet(mngr.getModulesInstalledLocally()), InstallationState.copySet(mngr.getModulesInstalledRemotely()), mngr.copyFactories());
    }

    private InstallationState(Set<ModuleReference> installedLocally, Set<ModuleReference> installedRemotely, FactoriesByID pool) {
        this.installedLocally = installedLocally;
        this.installedRemotely = installedRemotely;
        HashSet<ModuleReference> tmp = new HashSet<ModuleReference>(this.installedLocally);
        tmp.retainAll(this.installedRemotely);
        this.localAndRemote = Collections.unmodifiableSet(tmp);
        tmp = new HashSet<ModuleReference>(this.installedLocally);
        tmp.addAll(this.installedRemotely);
        this.localOrRemote = Collections.unmodifiableSet(tmp);
        Tuple2<Boolean, Map<String, ModuleFactory>> computed = this.computeInstalledFactories(pool);
        this.missingFactories = computed.get0();
        this.installedFactories = computed.get1();
    }

    public Set<ModuleReference> getLocal() {
        return this.installedLocally;
    }

    public Set<ModuleReference> getRemote() {
        return this.installedRemotely;
    }

    public final Set<ModuleReference> getLocalAndRemote() {
        return this.localAndRemote;
    }

    public final Set<ModuleReference> getLocalOrRemote() {
        return this.localOrRemote;
    }

    public final boolean isMissingFactories() {
        return this.missingFactories;
    }

    public final Map<String, ModuleFactory> getInstalledFactories() {
        return this.installedFactories;
    }

    public final Collection<ModuleFactory> getAllInstalledFactories() {
        if (this.isMissingFactories()) {
            return null;
        }
        return this.getInstalledFactories().values();
    }

    private final Tuple2<Boolean, Map<String, ModuleFactory>> computeInstalledFactories(FactoriesByID pool) {
        boolean missing = false;
        Set<ModuleReference> localOrRemote = this.getLocalOrRemote();
        HashMap<String, ModuleFactory> res = new HashMap<String, ModuleFactory>(localOrRemote.size());
        for (ModuleReference ref : localOrRemote) {
            if (ref.getVersion() == null) {
                throw new IllegalStateException("Installed module missing version : " + ref);
            }
            List<ModuleFactory> factories = pool.getFactories(ref);
            if (factories.size() == 0) {
                missing = true;
                continue;
            }
            assert (factories.size() == 1) : "Despite a non-null version, more than one match";
            res.put(ref.getID(), CollectionUtils.getSole(factories));
        }
        return Tuple2.create(missing, Collections.unmodifiableMap(res));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.installedLocally.hashCode();
        result = 31 * result + this.installedRemotely.hashCode();
        result = 31 * result + (this.installedFactories == null ? 0 : this.installedFactories.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InstallationState other = (InstallationState)obj;
        return this.installedLocally.equals(other.installedLocally) && this.installedRemotely.equals(other.installedRemotely) && CompareUtils.equals(this.installedFactories, other.installedFactories);
    }
}

