/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.openconcerto.erp.modules.ModuleFactory;
import org.openconcerto.erp.modules.ModuleReference;
import org.openconcerto.erp.modules.ModuleVersion;
import org.openconcerto.utils.CollectionUtils;

final class FactoriesByID {
    private static final SortedMap<ModuleVersion, ModuleFactory> EMPTY_MAP = Collections.unmodifiableSortedMap(FactoriesByID.createSortedMap());
    private Map<String, SortedMap<ModuleVersion, ModuleFactory>> map;

    private static final SortedMap<ModuleVersion, ModuleFactory> createSortedMap() {
        return new TreeMap<ModuleVersion, ModuleFactory>(Collections.reverseOrder());
    }

    public FactoriesByID() {
        this.map = Collections.emptyMap();
    }

    public FactoriesByID(FactoriesByID f) {
        this.map = f.getMap();
    }

    private final synchronized void setMap(Map<String, SortedMap<ModuleVersion, ModuleFactory>> copy) {
        for (Map.Entry<String, SortedMap<ModuleVersion, ModuleFactory>> e : copy.entrySet()) {
            e.setValue(Collections.unmodifiableSortedMap(e.getValue()));
        }
        this.map = Collections.unmodifiableMap(copy);
    }

    public final synchronized Map<String, SortedMap<ModuleVersion, ModuleFactory>> getMap() {
        return this.map;
    }

    private final Map<String, SortedMap<ModuleVersion, ModuleFactory>> copy() {
        return this.copy(Collections.<String>emptySet());
    }

    private final Map<String, SortedMap<ModuleVersion, ModuleFactory>> copy(Set<String> idExcludes) {
        Map<String, SortedMap<ModuleVersion, ModuleFactory>> m = this.getMap();
        HashMap<String, SortedMap<ModuleVersion, ModuleFactory>> res = new HashMap<String, SortedMap<ModuleVersion, ModuleFactory>>(m.size());
        for (Map.Entry<String, SortedMap<ModuleVersion, ModuleFactory>> e : m.entrySet()) {
            String id = e.getKey();
            if (idExcludes.contains(id)) continue;
            res.put(id, new TreeMap<ModuleVersion, ModuleFactory>(e.getValue()));
        }
        return res;
    }

    final synchronized ModuleFactory add(ModuleFactory f) {
        Map<String, SortedMap<ModuleVersion, ModuleFactory>> copy = this.copy();
        ModuleFactory res = FactoriesByID.add(f, copy);
        this.setMap(copy);
        return res;
    }

    private static final ModuleFactory add(ModuleFactory f, Map<String, SortedMap<ModuleVersion, ModuleFactory>> map) {
        SortedMap<ModuleVersion, ModuleFactory> m = map.get(f.getID());
        if (m == null) {
            m = FactoriesByID.createSortedMap();
            map.put(f.getID(), m);
        }
        return m.put(f.getVersion(), f);
    }

    final synchronized void addAll(Set<ModuleFactory> toAdd) {
        Map<String, SortedMap<ModuleVersion, ModuleFactory>> copy = this.copy();
        for (ModuleFactory f : toAdd) {
            FactoriesByID.add(f, copy);
        }
        this.setMap(copy);
    }

    final boolean contains(ModuleFactory factory) {
        return ((ModuleFactory)this.getVersions(factory.getID()).get(factory.getVersion())).equals(factory);
    }

    final SortedMap<ModuleVersion, ModuleFactory> getVersions(String moduleID) {
        SortedMap<ModuleVersion, ModuleFactory> res = this.getMap().get(moduleID);
        return res == null ? EMPTY_MAP : res;
    }

    final ModuleFactory getFactory(String id) {
        return this.getFactory(new ModuleReference(id, null));
    }

    final ModuleFactory getFactory(ModuleReference ref) {
        return CollectionUtils.getSole(this.getFactories(ref));
    }

    final List<ModuleFactory> getFactories(ModuleReference ref) {
        return this.getFactories(ref, false);
    }

    final List<ModuleFactory> getFactories(ModuleReference ref, boolean mostRecentIfNoVersion) {
        SortedMap<ModuleVersion, ModuleFactory> map = this.getVersions(ref.getID());
        if (map.isEmpty()) {
            return Collections.emptyList();
        }
        ModuleVersion version = ref.getVersion();
        if (version == null && mostRecentIfNoVersion) {
            version = map.firstKey();
        }
        if (version == null) {
            return new ArrayList<ModuleFactory>(map.values());
        }
        ModuleFactory val = (ModuleFactory)map.get(version);
        if (val == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(val);
    }

    final Collection<ModuleFactory> getFactories() {
        Map<String, SortedMap<ModuleVersion, ModuleFactory>> map = this.getMap();
        ArrayList<ModuleFactory> res = new ArrayList<ModuleFactory>(map.size() * 3);
        for (SortedMap<ModuleVersion, ModuleFactory> e : map.values()) {
            res.addAll(e.values());
        }
        return res;
    }

    final Set<ModuleFactory> getConflicts(Collection<ModuleFactory> factories) {
        Map<String, SortedMap<ModuleVersion, ModuleFactory>> m = this.getMap();
        HashSet<ModuleFactory> res = new HashSet<ModuleFactory>();
        for (SortedMap<ModuleVersion, ModuleFactory> id : m.values()) {
            for (ModuleFactory mf : id.values()) {
                if (!mf.conflictsWith(factories)) continue;
                res.add(mf);
            }
        }
        return res;
    }

    final synchronized SortedMap<ModuleVersion, ModuleFactory> remove(String id) {
        SortedMap<ModuleVersion, ModuleFactory> res = this.getVersions(id);
        this.setMap(this.copy(Collections.singleton(id)));
        return res;
    }

    final synchronized void removeAll(Set<ModuleFactory> toRemove) {
        Map<String, SortedMap<ModuleVersion, ModuleFactory>> copy = this.copy();
        for (ModuleFactory f : toRemove) {
            SortedMap<ModuleVersion, ModuleFactory> m = copy.get(f.getID());
            if (m == null) continue;
            m.remove(f.getVersion());
        }
        this.setMap(copy);
    }

    public String toString() {
        Map<String, SortedMap<ModuleVersion, ModuleFactory>> m = this.getMap();
        int size = m.size();
        StringBuilder sb = new StringBuilder(size * 32);
        sb.append(this.getClass().getSimpleName());
        if (size == 0) {
            sb.append(" empty");
        } else {
            sb.append(" {");
            for (Map.Entry<String, SortedMap<ModuleVersion, ModuleFactory>> e : m.entrySet()) {
                sb.append(e.getKey());
                sb.append(" : ");
                sb.append(e.getValue().keySet());
                sb.append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append("}");
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.map.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FactoriesByID other = (FactoriesByID)obj;
        return this.map.equals(other.map);
    }
}

