/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openconcerto.erp.modules.DepSolverGraph;
import org.openconcerto.erp.modules.DepSolverResult;
import org.openconcerto.erp.modules.InstallationState;
import org.openconcerto.erp.modules.ModuleFactory;
import org.openconcerto.erp.modules.ModuleManager;
import org.openconcerto.erp.modules.ModuleReference;
import org.openconcerto.erp.modules.ModulesStateChange;
import org.openconcerto.utils.cc.IPredicate;

public class DepSolverResultMM
extends DepSolverResult
implements ModulesStateChange {
    static final IPredicate<DepSolverResult> VALID_PRED = new IPredicate<DepSolverResult>(){

        @Override
        public boolean evaluateChecked(DepSolverResult input) {
            DepSolverResultMM res = (DepSolverResultMM)input;
            return res.getReferencesToInstall() != null && res.getReferencesToRemove() != null;
        }
    };
    private ModuleManager mngr;
    private InstallationState installState = null;
    private ModuleManager.NoChoicePredicate noChoice = null;
    private Set<ModuleReference> refs;
    private Set<ModuleReference> toAdd;
    private Set<ModuleReference> toRemove;
    private boolean toAddComputed = false;
    private boolean toRemoveComputed = false;

    public DepSolverResultMM(DepSolverResultMM parent, int tryCount, String error, DepSolverGraph graph) {
        super(parent, tryCount, error, graph);
    }

    final void init(ModuleManager mngr, InstallationState installState) {
        this.init(mngr, installState, null, null);
    }

    final synchronized void init(ModuleManager mngr, InstallationState installState, ModuleManager.NoChoicePredicate s, Collection<ModuleReference> refs) {
        if (this.isInited()) {
            throw new IllegalStateException("Already set : " + this.installState);
        }
        if (mngr == null) {
            throw new NullPointerException("Null manager");
        }
        this.mngr = mngr;
        this.setInstallState(installState);
        this.noChoice = s;
        this.refs = refs == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<ModuleReference>(refs));
    }

    private final synchronized boolean isInited() {
        return this.installState != null;
    }

    private final synchronized void setInstallState(InstallationState installState) {
        if (installState == null) {
            throw new NullPointerException();
        }
        this.installState = installState;
    }

    public final synchronized ModuleManager getManager() {
        if (!this.isInited()) {
            throw new IllegalStateException("Not set");
        }
        return this.mngr;
    }

    @Override
    public final synchronized InstallationState getInstallState() {
        if (!this.isInited()) {
            throw new IllegalStateException("Not set");
        }
        return this.installState;
    }

    public final synchronized ModuleManager.NoChoicePredicate getNoChoiceSolution() {
        if (!this.isInited()) {
            throw new IllegalStateException("Not initialized");
        }
        return this.noChoice;
    }

    @Override
    public final synchronized Set<ModuleReference> getUserReferencesToInstall() {
        if (!this.isInited()) {
            throw new IllegalStateException("Not initialized");
        }
        return this.refs;
    }

    @Override
    public final synchronized Set<ModuleReference> getReferencesToInstall() {
        if (!this.toAddComputed) {
            this.toAdd = this.computeReferencesToInstall();
            this.toAddComputed = true;
        }
        return this.toAdd;
    }

    private final Set<ModuleReference> computeReferencesToInstall() {
        Set<ModuleReference> localAndRemote = this.getInstallState().getLocalAndRemote();
        Set<ModuleFactory> factories = this.getGraph().getFactories();
        HashSet<ModuleReference> toInstall = new HashSet<ModuleReference>(factories.size());
        for (ModuleFactory f : factories) {
            if (localAndRemote.contains(f.getReference())) continue;
            toInstall.add(f.getReference());
        }
        ModuleManager.NoChoicePredicate s = this.getNoChoiceSolution();
        if (s == ModuleManager.NoChoicePredicate.NO_CHANGE && toInstall.size() > 0) {
            return null;
        }
        if (s == ModuleManager.NoChoicePredicate.ONLY_INSTALL_ARGUMENTS && !this.getUserReferencesToInstall().containsAll(toInstall)) {
            return null;
        }
        for (ModuleReference toInst : toInstall) {
            if (this.getManager().canCurrentUserInstall(ModuleManager.ModuleAction.INSTALL, toInst, this.getInstallState())) continue;
            return null;
        }
        return toInstall;
    }

    @Override
    public final synchronized Set<ModuleReference> getReferencesToRemove() {
        if (!this.toRemoveComputed) {
            this.toRemove = this.computeReferencesToRemove();
            this.toRemoveComputed = true;
        }
        return this.toRemove;
    }

    @Override
    public boolean forceRemove() {
        return false;
    }

    private final Set<ModuleReference> computeReferencesToRemove() {
        LinkedHashSet<ModuleReference> toUninstall;
        Set<ModuleFactory> factories = this.getGraph().getFactories();
        Collection<ModuleFactory> installedFactories = this.getInstallState().getAllInstalledFactories();
        if (installedFactories == null) {
            return null;
        }
        HashSet<ModuleReference> conflicts = new HashSet<ModuleReference>();
        for (ModuleFactory f : installedFactories) {
            if (!f.conflictsWith(factories)) continue;
            conflicts.add(f.getReference());
        }
        try {
            toUninstall = this.getManager().getAllOrderedDependentModulesRecursively(conflicts);
        }
        catch (Exception e) {
            throw new IllegalStateException("couldn't find needing modules for " + conflicts, e);
        }
        if (this.getNoChoiceSolution() != null && toUninstall.size() > 0) {
            return null;
        }
        for (ModuleReference toInst : toUninstall) {
            if (this.getManager().canCurrentUserInstall(ModuleManager.ModuleAction.UNINSTALL, toInst, this.getInstallState())) continue;
            return null;
        }
        return toUninstall;
    }
}

