/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.injector;

import java.math.BigDecimal;
import java.util.Collection;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;

public class FactureAvoirSQLInjector
extends SQLInjector {
    public FactureAvoirSQLInjector(DBRoot root) {
        super(root, "SAISIE_VENTE_FACTURE", "AVOIR_CLIENT", true);
        SQLTable tableFacture = this.getSource();
        SQLTable tableAvoir = this.getDestination();
        this.map(tableFacture.getField("ID_CLIENT"), tableAvoir.getField("ID_CLIENT"));
        this.map(tableFacture.getField("ID_ADRESSE"), tableAvoir.getField("ID_ADRESSE"));
        this.map(tableFacture.getField("ID_COMMERCIAL"), tableAvoir.getField("ID_COMMERCIAL"));
        this.map(tableFacture.getField("REMISE_HT"), tableAvoir.getField("REMISE_HT"));
        this.map(tableFacture.getField("PORT_HT"), tableAvoir.getField("PORT_HT"));
        if (this.getSource().getTable().contains("ID_CONTACT")) {
            this.map(this.getSource().getField("ID_CONTACT"), this.getDestination().getField("ID_CONTACT"));
        }
        if (this.getSource().contains("ID_ADRESSE") && this.getDestination().contains("ID_ADRESSE")) {
            this.map(this.getSource().getField("ID_ADRESSE"), this.getDestination().getField("ID_ADRESSE"));
        }
        if (this.getSource().contains("ID_ADRESSE_LIVRAISON") && this.getDestination().contains("ID_ADRESSE_LIVRAISON")) {
            this.map(this.getSource().getField("ID_ADRESSE_LIVRAISON"), this.getDestination().getField("ID_ADRESSE_LIVRAISON"));
        }
        if (this.getSource().getTable().contains("DATE_LIVRAISON") && this.getDestination().contains("DATE_LIVRAISON")) {
            this.map(this.getSource().getField("DATE_LIVRAISON"), this.getDestination().getField("DATE_LIVRAISON"));
        }
        if (this.getSource().getTable().contains("ID_CLIENT_DEPARTEMENT")) {
            this.map(this.getSource().getField("ID_CLIENT_DEPARTEMENT"), this.getDestination().getField("ID_CLIENT_DEPARTEMENT"));
        }
    }

    @Override
    protected void merge(SQLRowAccessor srcRow, SQLRowValues rowVals) {
        super.merge(srcRow, rowVals);
        SQLTable tableElementSource = this.getSource().getTable("SAISIE_VENTE_FACTURE_ELEMENT");
        SQLTable tableElementDestination = this.getSource().getTable("AVOIR_CLIENT_ELEMENT");
        Collection myListItem = srcRow.asRow().getReferentRows(tableElementSource);
        this.transfertReference(srcRow, rowVals, "NOM", "NOM");
        this.transfertNumberReference(srcRow, rowVals, tableElementDestination, "ID_AVOIR_CLIENT");
        if (myListItem.size() != 0) {
            SQLInjector injector = SQLInjector.getInjector(tableElementSource, tableElementDestination);
            for (SQLRowAccessor rowElt : myListItem) {
                SQLRowValues createRowValuesFrom = injector.createRowValuesFrom(rowElt.asRow());
                if (createRowValuesFrom.getTable().getFieldsName().contains("POURCENT_ACOMPTE") && createRowValuesFrom.getObject("POURCENT_ACOMPTE") == null) {
                    createRowValuesFrom.put("POURCENT_ACOMPTE", new BigDecimal(100.0));
                }
                createRowValuesFrom.put("ID_AVOIR_CLIENT", (Object)rowVals);
            }
        }
    }
}

