/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.injector;

import java.math.BigDecimal;
import java.util.Collection;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;

public class BonFactureSQLInjector
extends SQLInjector {
    public BonFactureSQLInjector(DBRoot root) {
        super(root.getTable("BON_DE_LIVRAISON"), root.getTable("SAISIE_VENTE_FACTURE"), true);
        SQLTable tableBon = this.getSource();
        SQLTable tableFacture = this.getDestination();
        this.map(tableBon.getField("ID_CLIENT"), tableFacture.getField("ID_CLIENT"));
        if (tableBon.getTable().contains("ID_POLE_PRODUIT")) {
            this.map(tableBon.getField("ID_POLE_PRODUIT"), tableFacture.getField("ID_POLE_PRODUIT"));
        }
        if (this.getSource().getTable().contains("ID_CONTACT")) {
            this.map(this.getSource().getField("ID_CONTACT"), this.getDestination().getField("ID_CONTACT"));
        }
        if (this.getSource().getTable().contains("ID_CLIENT_DEPARTEMENT")) {
            this.map(this.getSource().getField("ID_CLIENT_DEPARTEMENT"), this.getDestination().getField("ID_CLIENT_DEPARTEMENT"));
        }
        if (tableBon.contains("ID_TAXE_PORT")) {
            this.map(tableBon.getField("ID_TAXE_PORT"), tableFacture.getField("ID_TAXE_PORT"));
        }
        if (tableBon.contains("PORT_HT")) {
            this.map(tableBon.getField("PORT_HT"), tableFacture.getField("PORT_HT"));
        }
        if (tableBon.contains("REMISE_HT")) {
            this.map(tableBon.getField("REMISE_HT"), tableFacture.getField("REMISE_HT"));
        }
    }

    @Override
    protected void merge(SQLRowAccessor srcRow, SQLRowValues rowVals) {
        super.merge(srcRow, rowVals);
        SQLTable tableElementSource = this.getSource().getTable("BON_DE_LIVRAISON_ELEMENT");
        SQLTable tableElementDestination = this.getSource().getTable("SAISIE_VENTE_FACTURE_ELEMENT");
        Collection myListItem = srcRow.asRow().getReferentRows(tableElementSource);
        this.transfertReference(srcRow, rowVals, "NOM", "NOM");
        this.transfertReference(srcRow, rowVals, "INFOS", "INFOS");
        this.transfertNumberReference(srcRow, rowVals, tableElementDestination, "ID_SAISIE_VENTE_FACTURE");
        if (myListItem.size() != 0) {
            SQLInjector injector = SQLInjector.getInjector(tableElementSource, tableElementDestination);
            for (SQLRowAccessor rowElt : myListItem) {
                SQLRowValues createRowValuesFrom = injector.createRowValuesFrom(rowElt.asRow());
                if (createRowValuesFrom.getTable().getFieldsName().contains("POURCENT_ACOMPTE") && createRowValuesFrom.getObject("POURCENT_ACOMPTE") == null) {
                    createRowValuesFrom.put("POURCENT_ACOMPTE", new BigDecimal(100.0));
                }
                createRowValuesFrom.put("ID_SAISIE_VENTE_FACTURE", (Object)rowVals);
            }
        }
    }
}

