/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import java.math.BigDecimal;
import org.openconcerto.erp.core.common.ui.NumericFormat;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProvider;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.sql.model.SQLRowAccessor;

public class FormatedGlobalQtyTotalProvider
implements SpreadSheetCellValueProvider {
    private final boolean shortName;
    private final boolean alwaysShowOnZeroQty;
    private final Type type;

    private FormatedGlobalQtyTotalProvider(Type t, boolean shortName) {
        this(t, shortName, false);
    }

    private FormatedGlobalQtyTotalProvider(Type t, boolean shortName, boolean alwaysShowOnZeroQty) {
        this.shortName = shortName;
        this.type = t;
        this.alwaysShowOnZeroQty = alwaysShowOnZeroQty;
    }

    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        String field;
        SQLRowAccessor row = context.getRow();
        BigDecimal pv = row.getBigDecimal("PV_HT");
        if (!this.alwaysShowOnZeroQty && pv.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        String string = field = this.type == Type.NORMAL ? "QTE" : "QTE_LIVREE";
        if (row.getObject(field) == null) {
            return null;
        }
        int qte = row.getInt(field);
        if (row.getInt("ID_UNITE_VENTE") == 2) {
            return String.valueOf(qte);
        }
        String result = "";
        if (qte > 0) {
            if (qte > 1) {
                result = String.valueOf(result) + qte + " x ";
            }
            BigDecimal qteUV = row.getBigDecimal("QTE_UNITAIRE");
            result = String.valueOf(result) + NumericFormat.getQtyDecimalFormat().format(qteUV);
            SQLRowAccessor rMode = row.getForeign("ID_UNITE_VENTE");
            result = String.valueOf(result) + " " + (this.shortName ? rMode.getString("CODE") : rMode.getString("NOM"));
        }
        return result;
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("supplychain.element.qtyunit.short.with.quantity", new FormatedGlobalQtyTotalProvider(Type.NORMAL, true, true));
        SpreadSheetCellValueProviderManager.put("supplychain.element.qtyunit.short", new FormatedGlobalQtyTotalProvider(Type.NORMAL, true));
        SpreadSheetCellValueProviderManager.put("supplychain.element.qtyunit", new FormatedGlobalQtyTotalProvider(Type.NORMAL, false));
        SpreadSheetCellValueProviderManager.put("supplychain.element.qtyunit.deliver.short", new FormatedGlobalQtyTotalProvider(Type.SHIPMENT, true));
        SpreadSheetCellValueProviderManager.put("supplychain.element.qtyunit.deliver", new FormatedGlobalQtyTotalProvider(Type.SHIPMENT, false));
    }

    private static enum Type {
        NORMAL,
        SHIPMENT;

    }
}

