/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.gestcomm;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.generationDoc.AbstractListeSheetXml;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;

public class JournalPaieXmlSheet
extends AbstractListeSheetXml {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("dd/MM/yy");
    public static final String TEMPLATE_ID = "JournalPaie";
    public static final String TEMPLATE_PROPERTY_NAME = "Default";
    private int du;
    private int au;
    private int annee;
    Date d;
    private static final SQLTable tableSalarie = base.getTable("SALARIE");
    private static final SQLTable tableFichePaye = base.getTable("FICHE_PAYE");
    private static final SQLTable tableFichePayeElement = base.getTable("FICHE_PAYE_ELEMENT");
    private static final SQLTable tableMois = base.getTable("MOIS");
    private Map<SQLRow, Map<String, Object>> map = new HashMap<SQLRow, Map<String, Object>>();
    Map<String, Object> totalMap = new HashMap<String, Object>();

    public JournalPaieXmlSheet(int moisDu, int moisAu, int annee) {
        this.printer = PrinterNXProps.getInstance().getStringProperty("BonPrinter");
        this.du = moisDu;
        this.au = moisAu;
        this.annee = annee;
    }

    @Override
    public String getDefaultTemplateId() {
        return TEMPLATE_ID;
    }

    @Override
    protected String getStoragePathP() {
        return "Payes";
    }

    @Override
    public String getName() {
        if (this.d == null) {
            this.d = new Date();
        }
        return TEMPLATE_ID + this.d.getTime();
    }

    @Override
    protected void createListeValues() {
        SQLSelect sel = new SQLSelect();
        sel.addSelectStar(tableFichePaye);
        Where w2 = new Where((FieldRef)tableFichePaye.getField("ID_SALARIE"), "=", tableSalarie.getField("ID"));
        Where w3 = new Where((FieldRef)tableFichePaye.getField("ID_MOIS"), this.du, (Object)this.au);
        Where w4 = new Where((FieldRef)tableFichePaye.getField("ANNEE"), "=", this.annee);
        Where w5 = new Where((FieldRef)tableFichePaye.getField("VALIDE"), "=", (Object)Boolean.TRUE);
        sel.andWhere(w2);
        sel.andWhere(w3);
        sel.andWhere(w4);
        sel.andWhere(w5);
        String req = sel.asString();
        System.err.println(req);
        List<SQLRow> l = SQLRowListRSH.execute(sel);
        ArrayList<Map<String, Object>> listValues = new ArrayList<Map<String, Object>>();
        for (SQLRow sqlRow : l) {
            SQLRow foreignSal = sqlRow.getForeign("ID_SALARIE");
            SQLRow foreignVarSal = sqlRow.getForeign("ID_VARIABLE_SALARIE");
            Map<String, Object> map = this.getMapSalarie(foreignSal);
            map.put("CODE", foreignSal.getString("CODE"));
            map.put("NOM", String.valueOf(foreignSal.getString("NOM")) + " " + foreignSal.getString("PRENOM"));
            this.putValues("NET_IMP", sqlRow.getFloat("NET_IMP"), map);
            this.putValues("NET_A_PAYER", sqlRow.getFloat("NET_A_PAYER"), map);
            this.putValues("CSG_CRDS", (double)sqlRow.getFloat("CSG") * 0.029, map);
            this.putValues("CSG_DED", (double)sqlRow.getFloat("CSG") * 0.051, map);
            this.putValues("BASE_CSG", sqlRow.getFloat("CSG"), map);
            this.putValues("COT_SAL", sqlRow.getFloat("COT_SAL"), map);
            this.putValues("COT_PAT", sqlRow.getFloat("COT_PAT"), map);
            this.putValues("COT_TOTAL", sqlRow.getFloat("COT_PAT"), map);
            this.putValues("COT_TOTAL", sqlRow.getFloat("COT_SAL"), map);
            this.putValues("SAL_BRUT", sqlRow.getFloat("SAL_BRUT"), map);
            this.putValues("HEURES", foreignVarSal.getFloat("HEURE_TRAV"), map);
            this.putValues("HEURES_ABS", foreignVarSal.getFloat("HEURE_ABS"), map);
            this.putValues("HEURES_SUP", foreignVarSal.getFloat("HEURE_110"), map);
            this.putValues("HEURES_SUP", foreignVarSal.getFloat("HEURE_125"), map);
            this.putValues("HEURES_SUP", foreignVarSal.getFloat("HEURE_150"), map);
            this.putValues("HEURES_SUP", foreignVarSal.getFloat("HEURE_200"), map);
        }
        for (SQLRow row : this.map.keySet()) {
            listValues.add(this.map.get(row));
        }
        this.totalMap.put("NOM", "Total");
        listValues.add(this.totalMap);
        HashMap<String, String> values = new HashMap<String, String>();
        Calendar c = Calendar.getInstance();
        c.set(1, this.annee);
        c.set(2, this.du - 2);
        c.set(5, c.getActualMinimum(5));
        Date d1 = c.getTime();
        c.set(2, this.au - 2);
        c.set(5, c.getActualMaximum(5));
        Date d2 = c.getTime();
        values.put("PERIODE", "P\u00e9riode du " + DATE_FORMAT.format(d1) + " au " + DATE_FORMAT.format(d2));
        values.put("SOCIETE", ComptaPropsConfiguration.getInstanceCompta().getRowSociete().getString("NOM"));
        this.listAllSheetValues.put(0, listValues);
        this.mapAllSheetValues.put(0, values);
    }

    private Map<String, Object> getMapSalarie(SQLRow rowSalarie) {
        if (this.map.get(rowSalarie) == null) {
            this.map.put(rowSalarie, new HashMap());
        }
        return this.map.get(rowSalarie);
    }

    private void putValues(String key, double value, Map<String, Object> map) {
        double d;
        if (this.totalMap.get(key) != null) {
            d = ((Number)this.totalMap.get(key)).doubleValue();
            this.totalMap.put(key, value + d);
        } else {
            this.totalMap.put(key, value);
        }
        if (map.get(key) != null) {
            d = ((Number)map.get(key)).doubleValue();
            value += d;
        }
        map.put(key, value);
    }
}

