/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.gestcomm;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.generationDoc.AbstractListeSheetXml;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.AliasedField;
import org.openconcerto.sql.model.AliasedTable;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;

public class EtatVentesXmlSheet
extends AbstractListeSheetXml {
    private static final String MODE2 = "mod2";
    private static final String MODE1 = "mod1";
    public static final String TEMPLATE_ID = "EtatVentes";
    public static final String TEMPLATE_PROPERTY_NAME = "Default";
    private Timestamp du;
    private Timestamp au;
    Date d;

    public EtatVentesXmlSheet(Date du, Date au) {
        this.printer = PrinterNXProps.getInstance().getStringProperty("BonPrinter");
        if (du != null) {
            Calendar c1 = Calendar.getInstance();
            c1.setTime(du);
            c1.set(11, 0);
            c1.set(12, 0);
            c1.set(13, 0);
            this.du = new Timestamp(c1.getTimeInMillis());
        }
        if (au != null) {
            Calendar c2 = Calendar.getInstance();
            c2.setTime(au);
            c2.set(11, 23);
            c2.set(12, 59);
            c2.set(13, 59);
            this.au = new Timestamp(c2.getTimeInMillis());
        }
    }

    @Override
    public String getDefaultTemplateId() {
        return TEMPLATE_ID;
    }

    @Override
    protected String getStoragePathP() {
        return "Etat Ventes";
    }

    @Override
    public String getName() {
        if (this.d == null) {
            this.d = new Date();
        }
        return TEMPLATE_ID + this.d.getTime();
    }

    @Override
    protected void createListeValues() {
        SQLElementDirectory directory = Configuration.getInstance().getDirectory();
        SQLElement eltVenteFacutreElement = directory.getElement("SAISIE_VENTE_FACTURE_ELEMENT");
        SQLElement eltVenteFacture = directory.getElement("SAISIE_VENTE_FACTURE");
        SQLElement eltEncaissement = directory.getElement("ENCAISSER_MONTANT");
        SQLElement eltTicketCaisse = directory.getElement("TICKET_CAISSE");
        SQLElement eltModeReglement = directory.getElement("MODE_REGLEMENT");
        SQLTable tableModeReglement = eltModeReglement.getTable();
        SQLTable tableFactureElement = eltVenteFacutreElement.getTable();
        SQLTable tableFacture = eltVenteFacture.getTable();
        AliasedTable tableModeReglement1 = new AliasedTable(tableModeReglement, MODE1);
        AliasedTable tableModeReglement2 = new AliasedTable(tableModeReglement, MODE2);
        AliasedTable tableTicket = new AliasedTable(eltTicketCaisse.getTable(), "ticket");
        SQLSelect sel = new SQLSelect(Configuration.getInstance().getBase());
        sel.addSelect(tableFactureElement.getField("CODE"));
        sel.addSelect(tableFactureElement.getField("NOM"));
        Where w = new Where((FieldRef)tableFactureElement.getField("ID_TICKET_CAISSE"), "=", tableTicket.getTable().getUndefinedID());
        sel.addJoin("LEFT", tableFactureElement.getField("ID_SAISIE_VENTE_FACTURE")).setWhere(w);
        Where w2 = new Where((FieldRef)tableFactureElement.getField("ID_SAISIE_VENTE_FACTURE"), "=", 1);
        sel.addJoin("LEFT", tableFacture.getField("ID_MODE_REGLEMENT"), MODE1);
        sel.addJoin("LEFT", tableFactureElement.getField("ID_TICKET_CAISSE"), "ticket").setWhere(w2);
        sel.addBackwardJoin("LEFT", "enc", eltEncaissement.getTable().getField("ID_TICKET_CAISSE"), "ticket");
        sel.addJoin("LEFT", new AliasedField(eltEncaissement.getTable().getField("ID_MODE_REGLEMENT"), "enc"), MODE2);
        String idTypeReglement1 = tableModeReglement1.getField("ID_TYPE_REGLEMENT").getFieldRef();
        String idTypeReglement2 = tableModeReglement2.getField("ID_TYPE_REGLEMENT").getFieldRef();
        String qte = sel.getAlias(tableFactureElement.getField("QTE")).getFieldRef();
        sel.addRawSelect("SUM(CASE WHEN " + idTypeReglement1 + "=2 OR " + idTypeReglement2 + "=2 THEN " + qte + " ELSE 0 END)", "Cheque");
        sel.addRawSelect("SUM(CASE WHEN " + idTypeReglement1 + "=3 OR " + idTypeReglement2 + "=3 THEN " + qte + " ELSE 0 END)", "CB");
        sel.addRawSelect("SUM(CASE WHEN " + idTypeReglement1 + "=4 OR " + idTypeReglement2 + "=4 THEN " + qte + " ELSE 0 END)", "Especes");
        Where w3 = new Where((FieldRef)tableTicket.getField("DATE"), this.du, (Object)this.au);
        Where w4 = new Where((FieldRef)tableFacture.getField("DATE"), this.du, (Object)this.au);
        if (this.du != null && this.au != null) {
            sel.setWhere(w3.or(w4));
        }
        sel.addGroupBy(tableFactureElement.getField("NOM"));
        sel.addGroupBy(tableFactureElement.getField("CODE"));
        System.err.println(sel.asString());
        SQLSelect selQte = new SQLSelect(Configuration.getInstance().getBase());
        selQte.addSelect(tableFactureElement.getField("CODE"));
        selQte.addSelect(tableFactureElement.getField("NOM"));
        selQte.addSelect(tableFactureElement.getField("QTE"), "SUM");
        selQte.addSelect(tableFactureElement.getField("T_PA_HT"), "SUM");
        selQte.addSelect(tableFactureElement.getField("T_PV_HT"), "SUM");
        selQte.addSelect(tableFactureElement.getField("T_PV_TTC"), "SUM");
        selQte.addJoin("LEFT", tableFactureElement.getField("ID_SAISIE_VENTE_FACTURE")).setWhere(w);
        selQte.addJoin("LEFT", tableFactureElement.getField("ID_TICKET_CAISSE"), "ticket").setWhere(w2);
        if (this.du != null && this.au != null) {
            selQte.setWhere(w3.or(w4));
        }
        selQte.addGroupBy(tableFactureElement.getField("NOM"));
        selQte.addGroupBy(tableFactureElement.getField("CODE"));
        List listeQte = (List)Configuration.getInstance().getBase().getDataSource().execute(selQte.asString(), new ArrayListHandler());
        HashMap<String, ArticleVendu> map = new HashMap<String, ArticleVendu>();
        for (Object[] sqlRow : listeQte) {
            String code = (String)sqlRow[0];
            String nom = (String)sqlRow[1];
            Number qteVendu = (Number)sqlRow[2];
            Number ha = (Number)sqlRow[3];
            Number ht = (Number)sqlRow[4];
            Number ttc = (Number)sqlRow[5];
            ArticleVendu a = new ArticleVendu(code, nom, qteVendu.intValue(), (BigDecimal)ht, (BigDecimal)ha, (BigDecimal)ttc);
            map.put(String.valueOf(code) + "##" + nom, a);
        }
        List listeIds = (List)Configuration.getInstance().getBase().getDataSource().execute(sel.asString(), new ArrayListHandler());
        if (listeIds == null) {
            return;
        }
        ArrayList<Object> listValues = new ArrayList<Object>(listeIds.size());
        BigDecimal totalTPA = BigDecimal.ZERO;
        BigDecimal totalTPVTTC = BigDecimal.ZERO;
        for (Object[] obj : listeIds) {
            HashMap<String, Object> mValues = new HashMap<String, Object>();
            String code = (String)obj[0];
            String nom = (String)obj[1];
            ArticleVendu a = (ArticleVendu)map.get(String.valueOf(code) + "##" + nom);
            mValues.put("CODE", code);
            mValues.put("NOM", nom);
            mValues.put("QTE", a.qte);
            mValues.put("T_PA", a.ha);
            mValues.put("T_PV_HT", a.ht);
            mValues.put("T_PV_TTC", a.ttc);
            mValues.put("NB_CHEQUE", obj[2]);
            mValues.put("NB_CB", obj[3]);
            mValues.put("NB_ESPECES", obj[4]);
            totalTPA = totalTPA.add(a.ha);
            totalTPVTTC = totalTPVTTC.add(a.ttc);
            listValues.add(mValues);
            System.out.println("EtatVentesXmlSheet.createListeValues():" + listValues);
        }
        SQLTable venteComptoirT = directory.getElement("SAISIE_VENTE_COMPTOIR").getTable();
        SQLSelect selVC = new SQLSelect(venteComptoirT.getBase());
        selVC.addSelect(venteComptoirT.getField("NOM"));
        selVC.addSelect(venteComptoirT.getField("MONTANT_HT"), "SUM");
        selVC.addSelect(venteComptoirT.getField("MONTANT_TTC"), "SUM");
        selVC.addSelect(venteComptoirT.getField("NOM"), "COUNT");
        if (this.du != null && this.au != null) {
            Where wVC = new Where((FieldRef)venteComptoirT.getField("DATE"), this.du, (Object)this.au);
            wVC = wVC.and(new Where((FieldRef)venteComptoirT.getField("ID_ARTICLE"), "=", venteComptoirT.getForeignTable("ID_ARTICLE").getKey()));
            selVC.setWhere(wVC);
        } else {
            selVC.setWhere(new Where((FieldRef)venteComptoirT.getField("ID_ARTICLE"), "=", venteComptoirT.getForeignTable("ID_ARTICLE").getKey()));
        }
        selVC.addGroupBy(venteComptoirT.getField("NOM"));
        List listVC = (List)venteComptoirT.getDBSystemRoot().getDataSource().execute(selVC.asString(), new ArrayListHandler());
        long totalVCInCents = 0L;
        if (listVC.size() > 0) {
            HashMap<String, String> mValues = new HashMap<String, String>();
            mValues.put("NOM", " ");
            listValues.add(mValues);
            HashMap mValues2 = new HashMap();
            if (listVC.size() > 1) {
                mValues2.put("NOM", "VENTES COMPTOIR");
            } else {
                mValues2.put("NOM", "VENTE COMPTOIR");
            }
            HashMap<Integer, String> style = (HashMap<Integer, String>)this.styleAllSheetValues.get(0);
            if (style == null) {
                style = new HashMap<Integer, String>();
            }
            style.put(listValues.size(), "Titre 1");
            this.styleAllSheetValues.put(0, style);
            listValues.add(mValues2);
        }
        for (Object[] rowVenteComptoir : listVC) {
            HashMap<String, Object> mValues = new HashMap<String, Object>();
            mValues.put("NOM", rowVenteComptoir[0]);
            mValues.put("T_PV_HT", (double)((Number)rowVenteComptoir[1]).longValue() / 100.0);
            long ttcInCents = ((Number)rowVenteComptoir[2]).longValue();
            mValues.put("T_PV_TTC", (double)ttcInCents / 100.0);
            totalVCInCents += ttcInCents;
            mValues.put("QTE", rowVenteComptoir[3]);
            listValues.add(mValues);
        }
        ArrayList listValuesAchat = new ArrayList(listeIds.size());
        HashMap<String, Object> valuesAchat = (HashMap<String, Object>)this.mapAllSheetValues.get(1);
        if (valuesAchat == null) {
            valuesAchat = new HashMap<String, Object>();
        }
        SQLElement eltAchat = directory.getElement("SAISIE_ACHAT");
        SQLTable tableAchat = eltAchat.getTable();
        SQLSelect selAchat = new SQLSelect(Configuration.getInstance().getBase());
        selAchat.addSelect(tableAchat.getField("NOM"));
        selAchat.addSelect(tableAchat.getField("MONTANT_HT"), "SUM");
        selAchat.addSelect(tableAchat.getField("MONTANT_TTC"), "SUM");
        Where wHA = new Where((FieldRef)tableAchat.getField("DATE"), this.du, (Object)this.au);
        selAchat.setWhere(wHA);
        selAchat.addGroupBy(tableAchat.getField("NOM"));
        List listAchat = (List)Configuration.getInstance().getBase().getDataSource().execute(selAchat.asString(), new ArrayListHandler());
        long totalAchatInCents = 0L;
        for (Object[] row : listAchat) {
            HashMap<String, Object> mValues = new HashMap<String, Object>();
            mValues.put("NOM", row[0]);
            long ht = ((Number)row[1]).longValue();
            long pA = ((Number)row[2]).longValue();
            mValues.put("T_PV_HT", (double)(-ht) / 100.0);
            mValues.put("T_PV_TTC", (double)(-pA) / 100.0);
            totalAchatInCents -= pA;
            listValuesAchat.add(mValues);
        }
        totalTPVTTC = totalTPVTTC.add(new BigDecimal(totalVCInCents).movePointLeft(2));
        HashMap<String, Object> valuesE = (HashMap<String, Object>)this.mapAllSheetValues.get(2);
        if (valuesE == null) {
            valuesE = new HashMap<String, Object>();
        }
        SQLElement eltE = directory.getElement("ENCAISSER_MONTANT");
        SQLElement eltM = directory.getElement("MODE_REGLEMENT");
        SQLElement eltT = directory.getElement("TYPE_REGLEMENT");
        SQLSelect selE = new SQLSelect(Configuration.getInstance().getBase());
        selE.addSelect(eltT.getTable().getField("NOM"));
        selE.addSelect(eltT.getTable().getField("NOM"), "COUNT");
        selE.addSelect(eltE.getTable().getField("MONTANT"), "SUM");
        Where wE = new Where((FieldRef)eltE.getTable().getField("DATE"), this.du, (Object)this.au);
        wE = wE.and(new Where((FieldRef)eltE.getTable().getField("ID_MODE_REGLEMENT"), "=", eltM.getTable().getKey()));
        wE = wE.and(new Where((FieldRef)eltM.getTable().getField("ID_TYPE_REGLEMENT"), "=", eltT.getTable().getKey()));
        selE.setWhere(wE);
        selE.addGroupBy(eltT.getTable().getField("NOM"));
        selE.addFieldOrder(eltT.getTable().getField("NOM"));
        List listE = (List)Configuration.getInstance().getBase().getDataSource().execute(selE.asString(), new ArrayListHandler());
        ArrayList listValuesE = new ArrayList(listeIds.size());
        long totalEInCents = 0L;
        for (Object[] o : listE) {
            HashMap<String, Object> mValues = new HashMap<String, Object>();
            mValues.put("NOM", o[0]);
            long pA = ((Number)o[2]).longValue();
            mValues.put("QTE", o[1]);
            mValues.put("TOTAL", (double)pA / 100.0);
            totalEInCents += pA;
            listValuesE.add(mValues);
        }
        HashMap<String, Object> values = (HashMap<String, Object>)this.mapAllSheetValues.get(0);
        if (values == null) {
            values = new HashMap<String, Object>();
        }
        valuesAchat.put("TOTAL", Float.valueOf((float)totalAchatInCents / 100.0f));
        valuesE.put("TOTAL_HA", Float.valueOf((float)totalAchatInCents / 100.0f));
        valuesE.put("TOTAL", Float.valueOf((float)totalEInCents / 100.0f));
        valuesE.put("TOTAL_VT", totalTPVTTC);
        values.put("TOTAL", Float.valueOf((float)totalVCInCents / 100.0f));
        values.put("TOTAL_MARGE", totalTPVTTC.subtract(totalTPA));
        valuesE.put("TOTAL_GLOBAL", totalTPVTTC.add(new BigDecimal(totalAchatInCents).movePointLeft(2)));
        values.put("TOTAL_PA", totalTPA);
        values.put("TOTAL_PV_TTC", totalTPVTTC);
        String periode = "";
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yy");
        if (this.du != null && this.au != null) {
            periode = "P\u00e9riode du " + dateFormat.format(this.du) + " au " + dateFormat.format(this.au);
        } else if (this.du == null && this.au != null) {
            periode = "P\u00e9riode jusqu'au " + dateFormat.format(this.au);
        } else if (this.du != null && this.au == null) {
            periode = "P\u00e9riode depuis le " + dateFormat.format(this.du);
        }
        values.put("DATE", periode);
        valuesAchat.put("DATE", periode);
        valuesE.put("DATE", periode);
        System.err.println(this.du);
        System.err.println(this.au);
        this.listAllSheetValues.put(0, listValues);
        this.mapAllSheetValues.put(0, values);
        this.listAllSheetValues.put(1, listValuesAchat);
        this.mapAllSheetValues.put(1, valuesAchat);
        this.listAllSheetValues.put(2, listValuesE);
        this.mapAllSheetValues.put(2, valuesE);
    }

    class ArticleVendu {
        public String code;
        public String nom;
        public int qte;
        public BigDecimal ht;
        public BigDecimal ha;
        public BigDecimal ttc;

        public ArticleVendu(String code, String nom, int qte, BigDecimal ht, BigDecimal ha, BigDecimal ttc) {
            this.code = code;
            this.nom = nom;
            this.qte = qte;
            this.ht = ht;
            this.ha = ha;
            this.ttc = ttc;
        }
    }
}

