/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.erp.generationDoc.OOXMLCache;
import org.openconcerto.erp.generationDoc.OOXMLElement;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProvider;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.map.model.Ville;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.Nombre;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.Tuple2;

public class OOXMLField
extends OOXMLElement {
    private String op = "";

    public OOXMLField(Element eltField, SQLRowAccessor row, SQLElement sqlElt, int id, SQLRow rowLanguage, OOXMLCache cache) {
        super(eltField, sqlElt, id, rowLanguage, cache);
        String base = eltField.getAttributeValue("base");
        this.op = eltField.getAttributeValue("op");
        this.row = row;
        if ((this.row == null || !this.row.getTable().getSchema().getName().equalsIgnoreCase("Common")) && base != null && base.equalsIgnoreCase("COMMON")) {
            this.row = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete();
        }
        if (this.row == null) {
            this.row = sqlElt.getTable().getRow(id);
        }
    }

    @Override
    public Object getValue() {
        if (this.row != null && !this.row.isUndefined()) {
            boolean bIsCondValid;
            List excludeValue;
            boolean isForeignField;
            String field = this.elt.getAttributeValue("name");
            SQLField sqlField = field == null || field.trim().length() == 0 ? null : this.row.getTable().getField(field);
            boolean bl = isForeignField = sqlField == null ? false : this.row.getTable().getForeignKeys().contains(sqlField);
            if (isForeignField && this.elt.getChild("field") != null) {
                Boolean boolean1;
                String condField = this.elt.getAttributeValue("conditionField");
                if (!(condField == null || this.row.getTable().getField(condField).getType().getJavaType() != Boolean.class || (boolean1 = this.row.getBoolean(condField)) != null && boolean1.booleanValue())) {
                    return null;
                }
                SQLRowAccessor foreignRow = this.cache.getForeignRow(this.row, sqlField);
                if (foreignRow != null && foreignRow.getID() > 1) {
                    List children = this.elt.getChildren("field");
                    if (children.size() > 1) {
                        if (this.isValid()) {
                            String result = "";
                            for (Element ssComposant : children) {
                                OOXMLField childElt = new OOXMLField(ssComposant, foreignRow, this.sqlElt, this.id, this.rowLanguage, this.cache);
                                Object valueComposantO = childElt.getValue();
                                result = String.valueOf(result) + (valueComposantO == null ? "" : String.valueOf(valueComposantO.toString()) + " ");
                            }
                            String cellSize = this.elt.getAttributeValue("cellSize");
                            if (cellSize != null && cellSize.trim().length() != 0) {
                                result = this.splitStringCell(cellSize, result);
                            }
                            return result.trim();
                        }
                        return "";
                    }
                    if (this.isValid()) {
                        OOXMLField childElt = new OOXMLField(this.elt.getChild("field"), foreignRow, this.sqlElt, this.id, this.rowLanguage, this.cache);
                        return childElt.getValue();
                    }
                    return "";
                }
                return null;
            }
            if (this.op != null && this.op.trim().length() > 0) {
                String field2 = this.elt.getAttributeValue("name2");
                String typeComp = this.elt.getAttributeValue("type");
                Number o = (Number)this.row.getObject(field);
                Number o2 = field2 != null && field2.trim().length() > 0 ? (Number)((Number)this.row.getObject(field2)) : (Number)Double.parseDouble(this.elt.getAttributeValue("number"));
                if (typeComp != null && typeComp.trim().length() > 0 && typeComp.equalsIgnoreCase("Devise")) {
                    BigDecimal result = OOXMLField.calcul(o, o2, this.op);
                    if (o != null && o.getClass().isAssignableFrom(Long.class)) {
                        long resultLong = Math.round(result.doubleValue());
                        return Double.valueOf(GestionDevise.currencyToString(resultLong, false));
                    }
                    return result;
                }
                return OOXMLField.calcul(o, o2, this.op);
            }
            List<String> listOfExcludedValues = null;
            if (this.elt.getAttributeValue("valuesExpected") != null) {
                listOfExcludedValues = SQLRow.toList(this.elt.getAttributeValue("valuesExpected"));
            }
            if ((excludeValue = this.elt.getChildren("exclude")) != null && excludeValue.size() > 0) {
                listOfExcludedValues = listOfExcludedValues == null ? new ArrayList<String>() : new ArrayList<String>(listOfExcludedValues);
                for (Element element : excludeValue) {
                    String attributeValue = element.getAttributeValue("value");
                    listOfExcludedValues.add(attributeValue);
                }
            }
            String condField = this.elt.getAttributeValue("conditionField");
            String condValue = this.elt.getAttributeValue("conditionExpValue");
            boolean bl2 = bIsCondValid = condValue == null || !this.row.getObject(condField).toString().equalsIgnoreCase(condValue);
            if (condValue == null) {
                Boolean boolean1;
                boolean bIsBooleanCondValid = false;
                if (condField == null) {
                    bIsBooleanCondValid = true;
                } else if (this.row.getTable().getField(condField).getType().getJavaType() == Boolean.class && (boolean1 = this.row.getBoolean(condField)) != null && boolean1.booleanValue()) {
                    bIsBooleanCondValid = true;
                }
                bIsCondValid = bIsCondValid && bIsBooleanCondValid;
            } else {
                System.err.println();
            }
            if (bIsCondValid) {
                String stringValue;
                String typeComp = this.elt.getAttributeValue("type");
                Object o = this.getSpecialValue(typeComp);
                String scale = this.elt.getAttributeValue("decimalScale");
                if (o != null) {
                    if (o != null && scale != null && scale.trim().length() > 0) {
                        o = ((BigDecimal)o).setScale(Integer.valueOf(scale));
                    }
                    if (this.elt.getAttributeValue("upperCase") != null) {
                        o = o.toString().toUpperCase();
                    }
                    stringValue = o.toString();
                } else {
                    Object o2 = this.row.getObject(field);
                    if (o2 != null && scale != null && scale.trim().length() > 0) {
                        o2 = ((BigDecimal)o2).setScale(Integer.valueOf(scale));
                    }
                    String string = stringValue = o2 == null ? "" : o2.toString();
                }
                if (listOfExcludedValues == null || !listOfExcludedValues.contains(stringValue) && stringValue.trim().length() > 0) {
                    String prefix = this.elt.getAttributeValue("prefix");
                    String suffix = this.elt.getAttributeValue("suffix");
                    String display = this.elt.getAttributeValue("display");
                    String cellSize = this.elt.getAttributeValue("cellSize");
                    if (prefix != null || suffix != null) {
                        String result = "";
                        if (prefix != null) {
                            if (prefix.contains("#n")) {
                                prefix = prefix.replaceAll("#n", "\n");
                            }
                            result = String.valueOf(result) + prefix;
                        }
                        if (display == null || !display.equalsIgnoreCase("false")) {
                            result = String.valueOf(result) + stringValue;
                        }
                        if (suffix != null) {
                            result = String.valueOf(result) + suffix;
                        }
                        if (cellSize != null && cellSize.trim().length() != 0) {
                            result = this.splitStringCell(cellSize, result);
                        }
                        return result;
                    }
                    if (display == null || !display.equalsIgnoreCase("false")) {
                        if (cellSize != null && cellSize.trim().length() != 0 && o != null) {
                            return this.splitStringCell(cellSize, o.toString());
                        }
                        return o == null ? "" : o;
                    }
                    return "";
                }
            }
        }
        return null;
    }

    protected String splitStringCell(String cellSize, String result) {
        try {
            int nbCar = Integer.parseInt(cellSize);
            result = StringUtils.splitString(result, nbCar);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return result;
    }

    protected Object getSpecialValue(String typeComp) {
        String stringValue;
        SpreadSheetCellValueProvider provider = SpreadSheetCellValueProviderManager.get(typeComp);
        if (provider != null) {
            SpreadSheetCellValueContext context = new SpreadSheetCellValueContext(this.row);
            List attrs = this.elt.getAttributes();
            for (Attribute attr : attrs) {
                context.put(attr.getName(), attr.getValue());
            }
            return provider.getValue(context);
        }
        String field = this.elt.getAttributeValue("name");
        Object result = this.row.getObject(field);
        List<String> listOfExpectedValues = null;
        if (this.elt.getAttributeValue("valuesExpected") != null) {
            listOfExpectedValues = SQLRow.toList(this.elt.getAttributeValue("valuesExpected"));
        }
        String string = stringValue = result == null ? "" : result.toString();
        if (typeComp != null && typeComp.trim().length() > 0) {
            if (typeComp.equalsIgnoreCase("NumeroEcheance")) {
                SQLSelect sel = new SQLSelect(this.row.getTable().getBase());
                sel.addSelect(this.row.getTable().getKey(), "COUNT");
                Where w = new Where((FieldRef)this.row.getTable().getField("DATE"), "<=", (Object)this.row.getDate("DATE").getTime());
                sel.setWhere(w);
                return this.row.getTable().getBase().getDataSource().executeScalar(sel.asString());
            }
            if (typeComp.equalsIgnoreCase("Devise")) {
                Number prix = (Number)result;
                if (listOfExpectedValues != null) {
                    for (String string2 : listOfExpectedValues) {
                        Long l = Long.parseLong(string2);
                        if (l.longValue() != prix.longValue()) continue;
                        return "";
                    }
                }
                if (result instanceof Long) {
                    return new Double(GestionDevise.currencyToString(prix.longValue(), false));
                }
                String scale = this.elt.getAttributeValue("decimalScale");
                if (result != null && scale != null && scale.trim().length() > 0) {
                    return ((BigDecimal)result).setScale((int)Integer.valueOf(scale), RoundingMode.HALF_UP);
                }
                return result;
            }
            if (typeComp.equalsIgnoreCase("cumulPaye")) {
                double val = ((Number)result).doubleValue();
                double valC = ((Number)this.row.getForeign("ID_CUMULS_PAYE").getObject(String.valueOf(field) + "_C")).doubleValue();
                return new Double(val + valC);
            }
            if (typeComp.equalsIgnoreCase("globalAcompte")) {
                Long prix = (Long)result;
                int pourcent = this.row.getInt("POURCENT_ACOMPTE");
                long l = Math.round((double)prix.longValue() / ((double)pourcent / 100.0));
                return new Double(GestionDevise.currencyToString(l, false));
            }
            if (typeComp.equalsIgnoreCase("DatePaye")) {
                SQLRowAccessor rowRegl = this.row.getForeign("ID_REGLEMENT_PAYE");
                Calendar c = Calendar.getInstance();
                c.set(2, this.row.getInt("ID_MOIS") - 2);
                c.set(1, Integer.parseInt(this.row.getString("ANNEE")));
                if (rowRegl.getInt("LE") != 31) {
                    c.set(2, c.get(2) + 1);
                }
                int max = c.getActualMaximum(5);
                int day = Math.min(rowRegl.getInt("LE"), max);
                c.set(5, day);
                return c.getTime();
            }
            if (typeComp.equalsIgnoreCase("CumulPrec")) {
                long cumulPrecedent = OOXMLField.getCumulPrecedent(this.row);
                return new Double(GestionDevise.currencyToString(cumulPrecedent, false));
            }
            if (typeComp.equalsIgnoreCase("DeviseLettre")) {
                Long prix = (Long)result;
                return OOXMLField.getLettreFromDevise(prix, Nombre.FR, Tuple2.create(" euros ", " cents"));
            }
            if (typeComp.equalsIgnoreCase("DeviseLettreEng")) {
                Long prix = (Long)result;
                SQLRowAccessor tarif = this.row.getForeign("ID_TARIF");
                if (tarif.isUndefined()) {
                    return OOXMLField.getLettreFromDevise(prix, Nombre.EN, Tuple2.create(" euros ", " cents"));
                }
                SQLRowAccessor rowDevise = tarif.getForeign("ID_DEVISE");
                if (rowDevise.isUndefined()) {
                    return OOXMLField.getLettreFromDevise(prix, Nombre.EN, Tuple2.create(" euros ", " cents"));
                }
                return OOXMLField.getLettreFromDevise(prix, Nombre.EN, Tuple2.create(" " + rowDevise.getString("LIBELLE") + " ", " " + rowDevise.getString("LIBELLE_CENT") + " "));
            }
            if (typeComp.equalsIgnoreCase("VilleFull")) {
                return String.valueOf(this.row.getString("CODE_POSTAL")) + " " + this.row.getString("VILLE");
            }
            if (typeComp.equalsIgnoreCase("Ville")) {
                stringValue = result == null ? "" : result.toString();
                return stringValue;
            }
            if (typeComp.equalsIgnoreCase("Traduction")) {
                return this.getTraduction();
            }
            if (typeComp.equalsIgnoreCase("VilleCP")) {
                if (this.row.getTable().contains("CODE_POSTAL")) {
                    return this.row.getString("CODE_POSTAL");
                }
                Ville v = Ville.getVilleFromVilleEtCode((String)this.row.getString(field));
                if (v != null) {
                    return v.getCodepostal();
                }
                return null;
            }
            if (typeComp.equalsIgnoreCase("DateEcheance")) {
                int idModeReglement = this.row.getInt("ID_MODE_REGLEMENT");
                Date d = (Date)this.row.getObject("DATE");
                return this.getDateEcheance(idModeReglement, d, this.elt.getAttributeValue("datePattern"));
            }
            if (typeComp.equalsIgnoreCase("Jour")) {
                int day = this.row.getInt(field);
                stringValue = "le " + String.valueOf(day);
                if (day == 31) {
                    return "fin de mois";
                }
                if (day == 0) {
                    return "Date de facture";
                }
                return stringValue;
            }
            if (typeComp.equalsIgnoreCase("Date")) {
                String datePattern = this.elt.getAttributeValue("datePattern");
                if (datePattern == null || datePattern.trim().length() == 0) {
                    datePattern = "dd/MM/yyyy";
                }
                SimpleDateFormat format = new SimpleDateFormat(datePattern);
                if (result != null) {
                    Date d = (Date)result;
                    return format.format(d);
                }
                return "";
            }
            if (typeComp.equalsIgnoreCase("initiale")) {
                String string3 = stringValue = result == null ? "" : result.toString();
                if (stringValue.trim().length() > 0) {
                    stringValue = String.valueOf(stringValue.charAt(0));
                }
                return stringValue;
            }
            if (typeComp.equalsIgnoreCase("initiale2")) {
                String string4 = stringValue = result == null ? "" : result.toString();
                if (stringValue.trim().length() > 0) {
                    stringValue = String.valueOf(stringValue.substring(0, 2));
                }
                return stringValue;
            }
        }
        return result == null ? "" : result;
    }

    private Object getTraduction() {
        if (this.rowLanguage == null || this.rowLanguage.isUndefined()) {
            return null;
        }
        int id = ReferenceArticleSQLElement.getIdForCNM(this.row.asRowValues(), false);
        SQLTable table = Configuration.getInstance().getBase().getTable("ARTICLE_DESIGNATION");
        SQLSelect sel = new SQLSelect(table.getBase());
        sel.addSelectStar(table);
        Where w = new Where((FieldRef)table.getField("ID_ARTICLE"), "=", id);
        w = w.and(new Where((FieldRef)table.getField("ID_LANGUE"), "=", this.rowLanguage.getID()));
        sel.setWhere(w);
        List rows = (List)Configuration.getInstance().getBase().getDataSource().execute(sel.asString(), SQLRowListRSH.createFromSelect(sel));
        if (rows != null && rows.size() > 0) {
            return ((SQLRow)rows.get(0)).getString(this.elt.getAttributeValue("name"));
        }
        return this.row.getObject(this.elt.getAttributeValue("name"));
    }

    public boolean isValid() {
        boolean bIsCondValid;
        String condField = this.elt.getAttributeValue("conditionField");
        String condValue = this.elt.getAttributeValue("conditionExpValue");
        boolean bIsBooleanCondValid = condField == null || this.row.getTable().getField(condField).getType().getJavaType() == Boolean.class && this.row.getBoolean(condField) != false;
        boolean bl = bIsCondValid = condValue == null || this.row.getObject(condField).toString().equalsIgnoreCase(condValue);
        return bIsBooleanCondValid || !bIsCondValid;
    }

    private static long getCumulPrecedent(SQLRowAccessor rowFact) {
        long cumul;
        block4: {
            Calendar date;
            block3: {
                cumul = 0L;
                SQLRowAccessor rowAff = rowFact.getForeign("ID_AFFAIRE");
                date = rowFact.getDate("DATE");
                if (rowAff == null || rowAff.isUndefined()) break block3;
                if (!rowAff.getBoolean("CCI").booleanValue()) break block4;
                Collection rows = rowAff.asRow().getReferentRows(rowFact.getTable());
                for (SQLRow sqlRow : rows) {
                    if (sqlRow.getID() == rowFact.getID() || !sqlRow.getDate("DATE").before(date)) continue;
                    cumul += sqlRow.getLong("T_HT");
                }
                break block4;
            }
            SQLTable tableElt = Configuration.getInstance().getRoot().findTable("SAISIE_VENTE_FACTURE_ELEMENT");
            Collection<? extends SQLRowAccessor> factElts = rowFact.getReferentRows(tableElt);
            for (SQLRowAccessor sQLRowAccessor : factElts) {
                SQLRowAccessor foreign = sQLRowAccessor.getForeign("ID_MISSION");
                if (foreign.getID() <= 1) continue;
                Collection<? extends SQLRowAccessor> rowsElt = foreign.getReferentRows(tableElt);
                for (SQLRowAccessor sQLRowAccessor2 : rowsElt) {
                    SQLRowAccessor rowFacture = sQLRowAccessor2.getForeign("ID_SAISIE_VENTE_FACTURE");
                    if (!rowFacture.getDate("DATE").before(date)) continue;
                    cumul += sQLRowAccessor2.getLong("T_PV_HT");
                }
            }
        }
        return cumul;
    }

    private static long getMontantGlobal(SQLRowAccessor rowFact) {
        long cumul = 0L;
        BigDecimal cent = new BigDecimal(100);
        SQLTable tableElt = Configuration.getInstance().getRoot().findTable("SAISIE_VENTE_FACTURE_ELEMENT");
        Collection<? extends SQLRowAccessor> factElts = rowFact.getReferentRows(tableElt);
        for (SQLRowAccessor sQLRowAccessor : factElts) {
            BigDecimal p;
            BigDecimal lremise;
            BigDecimal bigDecimal = sQLRowAccessor.getBigDecimal("MONTANT_INITIAL");
            Long l0 = (Long)sQLRowAccessor.getObject("INDICE_0");
            Long lN = (Long)sQLRowAccessor.getObject("INDICE_N");
            BigDecimal o = sQLRowAccessor.getBigDecimal("POURCENT_ACOMPTE");
            BigDecimal o2 = sQLRowAccessor.getBigDecimal("POURCENT_REMISE");
            double lA = o == null ? 0.0 : o.doubleValue();
            BigDecimal bigDecimal2 = lremise = o2 == null ? BigDecimal.ZERO : o2;
            if (l0 != 0L) {
                double coeff = (double)lN.longValue() / (double)l0.longValue();
                BigDecimal d = new BigDecimal("0.15").add(new BigDecimal("0.85").multiply(new BigDecimal(coeff), DecimalUtils.HIGH_PRECISION));
                p = d.multiply(bigDecimal, DecimalUtils.HIGH_PRECISION);
            } else {
                p = bigDecimal;
            }
            if (lremise.signum() != 0 && lremise.compareTo(BigDecimal.ZERO) > 0 && lremise.compareTo(cent) < 100) {
                p = p.multiply(cent.subtract(lremise).movePointLeft(2), DecimalUtils.HIGH_PRECISION);
            }
            cumul += p.setScale(2, RoundingMode.HALF_UP).movePointRight(2).longValue();
        }
        SQLTable sQLTable = Configuration.getInstance().getRoot().findTable("ECHANTILLON_ELEMENT");
        Collection<? extends SQLRowAccessor> echElts = rowFact.getReferentRows(sQLTable);
        for (SQLRowAccessor sQLRowAccessor : echElts) {
            cumul += sQLRowAccessor.getBigDecimal("T_PV_HT").setScale(2, RoundingMode.HALF_UP).movePointRight(2).longValue();
        }
        return cumul;
    }

    private static List<Integer> getListId(Collection<SQLRow> rowFactElts) {
        return OOXMLField.getListId(rowFactElts, null);
    }

    private static List<Integer> getListId(Collection<SQLRow> rowFactElts, String field) {
        ArrayList<Integer> l = new ArrayList<Integer>();
        for (SQLRow row : rowFactElts) {
            if (field == null) {
                l.add(row.getID());
                continue;
            }
            l.add(row.getInt(field));
        }
        return l;
    }

    private static String getLettreFromDevise(long value, int langue, Tuple2<String, String> deviseName) {
        StringBuffer result = new StringBuffer();
        Long decimal = value % 100L;
        Long entier = value / 100L;
        Nombre n1 = new Nombre(entier.intValue(), langue);
        Nombre n2 = new Nombre(decimal.intValue(), langue);
        result.append(String.valueOf(n1.getText()) + " " + deviseName.get0().trim());
        if (decimal.intValue() > 0) {
            result.append(String.valueOf(langue == Nombre.FR ? " et " : " and ") + n2.getText() + deviseName.get1());
        }
        if (result != null && result.length() > 0) {
            return result.toString().replaceFirst(String.valueOf(result.charAt(0)), String.valueOf(result.charAt(0)).toUpperCase());
        }
        return result.toString();
    }

    private static BigDecimal calcul(Object o1, Object o2, String op) {
        BigDecimal d2;
        BigDecimal d1;
        if (o1 != null && o1 instanceof BigDecimal) {
            d1 = (BigDecimal)o1;
        } else {
            BigDecimal bigDecimal = d1 = o1 == null ? BigDecimal.ZERO : new BigDecimal(o1.toString());
        }
        if (o2 != null && o2 instanceof BigDecimal) {
            d2 = (BigDecimal)o2;
        } else {
            BigDecimal bigDecimal = d2 = o2 == null ? BigDecimal.ZERO : new BigDecimal(o2.toString());
        }
        if (op.equalsIgnoreCase("+")) {
            return d1.add(d2, DecimalUtils.HIGH_PRECISION);
        }
        if (op.equalsIgnoreCase("-")) {
            return d1.subtract(d2, DecimalUtils.HIGH_PRECISION);
        }
        if (op.equalsIgnoreCase("*")) {
            return d1.multiply(d2, DecimalUtils.HIGH_PRECISION);
        }
        if (op.equalsIgnoreCase("/") && d2.compareTo(BigDecimal.ZERO) != 0) {
            return d1.divide(d2, DecimalUtils.HIGH_PRECISION);
        }
        return BigDecimal.ZERO;
    }
}

